/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Notification;
import android.app.Service;
import android.content.Intent;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.PowerManager;
import android.util.Log;
import androidx.annotation.Nullable;
import com.baseflow.geolocator.location.BackgroundNotification;
import com.baseflow.geolocator.location.ForegroundNotificationOptions;
import com.baseflow.geolocator.location.GeolocationManager;
import com.baseflow.geolocator.location.LocationClient;
import com.baseflow.geolocator.location.LocationMapper;
import com.baseflow.geolocator.location.LocationOptions;
import io.flutter.plugin.common.EventChannel;

public class GeolocatorLocationService
extends Service {
    private static final String TAG = "FlutterGeolocator";
    private static final int ONGOING_NOTIFICATION_ID = 75415;
    private static final String CHANNEL_ID = "geolocator_channel_01";
    private final String WAKELOCK_TAG = "GeolocatorLocationService:Wakelock";
    private final String WIFILOCK_TAG = "GeolocatorLocationService:WifiLock";
    private final LocalBinder binder = new LocalBinder(this);
    private boolean isForeground = false;
    private int connectedEngines = 0;
    private int listenerCount = 0;
    @Nullable
    private Activity activity = null;
    @Nullable
    private GeolocationManager geolocationManager = null;
    @Nullable
    private LocationClient locationClient;
    @Nullable
    private PowerManager.WakeLock wakeLock = null;
    @Nullable
    private WifiManager.WifiLock wifiLock = null;
    @Nullable
    private BackgroundNotification backgroundNotification = null;

    public void onCreate() {
        super.onCreate();
        Log.d((String)TAG, (String)"Creating service.");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        Log.d((String)TAG, (String)"Binding to location service.");
        return this.binder;
    }

    public boolean onUnbind(Intent intent) {
        Log.d((String)TAG, (String)"Unbinding from location service.");
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        Log.d((String)TAG, (String)"Destroying location service.");
        this.stopLocationService();
        this.disableBackgroundMode();
        this.geolocationManager = null;
        this.backgroundNotification = null;
        Log.d((String)TAG, (String)"Destroyed location service.");
        super.onDestroy();
    }

    public boolean canStopLocationService(boolean cancellationRequested) {
        if (cancellationRequested) {
            return this.listenerCount == 1;
        }
        return this.connectedEngines == 0;
    }

    public void flutterEngineConnected() {
        ++this.connectedEngines;
        Log.d((String)TAG, (String)("Flutter engine connected. Connected engine count " + this.connectedEngines));
    }

    public void flutterEngineDisconnected() {
        --this.connectedEngines;
        Log.d((String)TAG, (String)("Flutter engine disconnected. Connected engine count " + this.connectedEngines));
    }

    public void startLocationService(boolean forceLocationManager, LocationOptions locationOptions, EventChannel.EventSink events) {
        ++this.listenerCount;
        if (this.geolocationManager != null) {
            this.locationClient = this.geolocationManager.createLocationClient(this.getApplicationContext(), Boolean.TRUE.equals(forceLocationManager), locationOptions);
            this.geolocationManager.startPositionUpdates(this.locationClient, this.activity, location -> events.success(LocationMapper.toHashMap(location)), errorCodes -> events.error(errorCodes.toString(), errorCodes.toDescription(), null));
        }
    }

    public void stopLocationService() {
        --this.listenerCount;
        Log.d((String)TAG, (String)"Stopping location service.");
        if (this.locationClient != null && this.geolocationManager != null) {
            this.geolocationManager.stopPositionUpdates(this.locationClient);
        }
    }

    public void enableBackgroundMode(ForegroundNotificationOptions options) {
        if (this.backgroundNotification != null) {
            Log.d((String)TAG, (String)"Service already in foreground mode.");
            this.changeNotificationOptions(options);
        } else {
            Log.d((String)TAG, (String)"Start service in foreground mode.");
            this.backgroundNotification = new BackgroundNotification(this.getApplicationContext(), CHANNEL_ID, 75415, options);
            this.backgroundNotification.updateChannel(options.getNotificationChannelName());
            Notification notification = this.backgroundNotification.build();
            this.startForeground(75415, notification);
            this.isForeground = true;
        }
        this.obtainWakeLocks(options);
    }

    public void disableBackgroundMode() {
        if (this.isForeground) {
            Log.d((String)TAG, (String)"Stop service in foreground.");
            if (Build.VERSION.SDK_INT >= 24) {
                this.stopForeground(1);
            } else {
                this.stopForeground(true);
            }
            this.releaseWakeLocks();
            this.isForeground = false;
            this.backgroundNotification = null;
        }
    }

    public void changeNotificationOptions(ForegroundNotificationOptions options) {
        if (this.backgroundNotification != null) {
            this.backgroundNotification.updateOptions(options, this.isForeground);
            this.obtainWakeLocks(options);
        }
    }

    public void setActivity(@Nullable Activity activity) {
        this.activity = activity;
    }

    public void setGeolocationManager(@Nullable GeolocationManager geolocationManager) {
        this.geolocationManager = geolocationManager;
    }

    private void releaseWakeLocks() {
        if (this.wakeLock != null && this.wakeLock.isHeld()) {
            this.wakeLock.release();
            this.wakeLock = null;
        }
        if (this.wifiLock != null && this.wifiLock.isHeld()) {
            this.wifiLock.release();
            this.wifiLock = null;
        }
    }

    @SuppressLint(value={"WakelockTimeout"})
    private void obtainWakeLocks(ForegroundNotificationOptions options) {
        WifiManager wifiManager;
        PowerManager powerManager;
        this.releaseWakeLocks();
        if (options.isEnableWakeLock() && (powerManager = (PowerManager)this.getApplicationContext().getSystemService("power")) != null) {
            this.wakeLock = powerManager.newWakeLock(1, "GeolocatorLocationService:Wakelock");
            this.wakeLock.setReferenceCounted(false);
            this.wakeLock.acquire();
        }
        if (options.isEnableWifiLock() && (wifiManager = (WifiManager)this.getApplicationContext().getSystemService("wifi")) != null) {
            this.wifiLock = wifiManager.createWifiLock(this.getWifiLockType(), "GeolocatorLocationService:WifiLock");
            this.wifiLock.setReferenceCounted(false);
            this.wifiLock.acquire();
        }
    }

    private int getWifiLockType() {
        if (Build.VERSION.SDK_INT < 29) {
            return 3;
        }
        return 4;
    }

    class LocalBinder
    extends Binder {
        private final GeolocatorLocationService locationService;

        LocalBinder(GeolocatorLocationService locationService) {
            this.locationService = locationService;
        }

        public GeolocatorLocationService getLocationService() {
            return this.locationService;
        }
    }
}

