/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.Nullable;
import com.baseflow.geolocator.GeolocatorLocationService;
import com.baseflow.geolocator.errors.ErrorCodes;
import com.baseflow.geolocator.errors.PermissionUndefinedException;
import com.baseflow.geolocator.location.ForegroundNotificationOptions;
import com.baseflow.geolocator.location.GeolocationManager;
import com.baseflow.geolocator.location.LocationClient;
import com.baseflow.geolocator.location.LocationMapper;
import com.baseflow.geolocator.location.LocationOptions;
import com.baseflow.geolocator.permission.PermissionManager;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.EventChannel;
import java.util.Map;

class StreamHandlerImpl
implements EventChannel.StreamHandler {
    private static final String TAG = "FlutterGeolocator";
    private final PermissionManager permissionManager;
    @Nullable
    private EventChannel channel;
    @Nullable
    private Context context;
    @Nullable
    private Activity activity;
    @Nullable
    private GeolocatorLocationService foregroundLocationService;
    @Nullable
    private GeolocationManager geolocationManager;
    @Nullable
    private LocationClient locationClient;

    public StreamHandlerImpl(PermissionManager permissionManager, GeolocationManager geolocationManager) {
        this.permissionManager = permissionManager;
        this.geolocationManager = geolocationManager;
    }

    public void setForegroundLocationService(@Nullable GeolocatorLocationService foregroundLocationService) {
        this.foregroundLocationService = foregroundLocationService;
    }

    public void setActivity(@Nullable Activity activity) {
        if (activity == null && this.locationClient != null && this.channel != null) {
            this.stopListening();
        }
        this.activity = activity;
    }

    void startListening(Context context, BinaryMessenger messenger) {
        if (this.channel != null) {
            Log.w((String)TAG, (String)"Setting a event call handler before the last was disposed.");
            this.stopListening();
        }
        this.channel = new EventChannel(messenger, "flutter.baseflow.com/geolocator_updates_android");
        this.channel.setStreamHandler((EventChannel.StreamHandler)this);
        this.context = context;
    }

    void stopListening() {
        if (this.channel == null) {
            Log.d((String)TAG, (String)"Tried to stop listening when no MethodChannel had been initialized.");
            return;
        }
        this.disposeListeners(false);
        this.channel.setStreamHandler(null);
        this.channel = null;
    }

    public void onListen(Object arguments, EventChannel.EventSink events) {
        try {
            if (!this.permissionManager.hasPermission(this.context)) {
                events.error(ErrorCodes.permissionDenied.toString(), ErrorCodes.permissionDenied.toDescription(), null);
                return;
            }
        }
        catch (PermissionUndefinedException e) {
            events.error(ErrorCodes.permissionDefinitionsNotFound.toString(), ErrorCodes.permissionDefinitionsNotFound.toDescription(), null);
            return;
        }
        if (this.foregroundLocationService == null) {
            Log.e((String)TAG, (String)"Location background service has not started correctly");
            return;
        }
        Map map = (Map)arguments;
        boolean forceLocationManager = false;
        if (map != null && map.get("forceLocationManager") != null) {
            forceLocationManager = (Boolean)map.get("forceLocationManager");
        }
        LocationOptions locationOptions = LocationOptions.parseArguments(map);
        ForegroundNotificationOptions foregroundNotificationOptions = null;
        if (map != null) {
            foregroundNotificationOptions = ForegroundNotificationOptions.parseArguments((Map)map.get("foregroundNotificationConfig"));
        }
        if (foregroundNotificationOptions != null) {
            Log.e((String)TAG, (String)"Geolocator position updates started using Android foreground service");
            this.foregroundLocationService.startLocationService(forceLocationManager, locationOptions, events);
            this.foregroundLocationService.enableBackgroundMode(foregroundNotificationOptions);
        } else {
            Log.e((String)TAG, (String)"Geolocator position updates started");
            this.locationClient = this.geolocationManager.createLocationClient(this.context, Boolean.TRUE.equals(forceLocationManager), locationOptions);
            this.geolocationManager.startPositionUpdates(this.locationClient, this.activity, location -> events.success(LocationMapper.toHashMap(location)), errorCodes -> events.error(errorCodes.toString(), errorCodes.toDescription(), null));
        }
    }

    public void onCancel(Object arguments) {
        this.disposeListeners(true);
    }

    private void disposeListeners(boolean cancelled) {
        Log.e((String)TAG, (String)"Geolocator position updates stopped");
        if (this.foregroundLocationService != null && this.foregroundLocationService.canStopLocationService(cancelled)) {
            this.foregroundLocationService.stopLocationService();
            this.foregroundLocationService.disableBackgroundMode();
        } else {
            Log.e((String)TAG, (String)"There is still another flutter engine connected, not stopping location service");
        }
        if (this.locationClient != null && this.geolocationManager != null) {
            this.geolocationManager.stopPositionUpdates(this.locationClient);
            this.locationClient = null;
        }
    }
}

