/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator.errors;

public enum ErrorCodes {
    activityMissing,
    errorWhileAcquiringPosition,
    locationServicesDisabled,
    permissionDefinitionsNotFound,
    permissionDenied,
    permissionRequestInProgress;


    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return "ACTIVITY_MISSING";
            }
            case 1: {
                return "ERROR_WHILE_ACQUIRING_POSITION";
            }
            case 2: {
                return "LOCATION_SERVICES_DISABLED";
            }
            case 3: {
                return "PERMISSION_DEFINITIONS_NOT_FOUND";
            }
            case 4: {
                return "PERMISSION_DENIED";
            }
            case 5: {
                return "PERMISSION_REQUEST_IN_PROGRESS";
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public String toDescription() {
        switch (this.ordinal()) {
            case 0: {
                return "Activity is missing. This might happen when running a certain function from the background that requires a UI element (e.g. requesting permissions or enabling the location services).";
            }
            case 1: {
                return "An unexpected error occurred while trying to acquire the device's position.";
            }
            case 2: {
                return "Location services are disabled. To receive location updates the location services should be enabled.";
            }
            case 3: {
                return "No location permissions are defined in the manifest. Make sure at least ACCESS_FINE_LOCATION or ACCESS_COARSE_LOCATION are defined in the manifest.";
            }
            case 4: {
                return "User denied permissions to access the device's location.";
            }
            case 5: {
                return "Already listening for location updates. If you want to restart listening please cancel other subscriptions first";
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

