/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator.location;

import android.content.Context;
import androidx.core.content.ContextCompat;
import com.baseflow.geolocator.errors.ErrorCallback;
import com.baseflow.geolocator.errors.ErrorCodes;
import com.baseflow.geolocator.location.LocationAccuracyStatus;

public class LocationAccuracyManager {
    private static LocationAccuracyManager locationAccuracyManagerInstance = null;

    private LocationAccuracyManager() {
    }

    public static synchronized LocationAccuracyManager getInstance() {
        if (locationAccuracyManagerInstance == null) {
            locationAccuracyManagerInstance = new LocationAccuracyManager();
        }
        return locationAccuracyManagerInstance;
    }

    public LocationAccuracyStatus getLocationAccuracy(Context context, ErrorCallback errorCallback) {
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0) {
            return LocationAccuracyStatus.precise;
        }
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0) {
            return LocationAccuracyStatus.reduced;
        }
        errorCallback.onError(ErrorCodes.permissionDenied);
        return null;
    }
}

