/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator.location;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import androidx.annotation.NonNull;
import com.baseflow.geolocator.location.ServiceStatus;
import io.flutter.plugin.common.EventChannel;

public class LocationServiceStatusReceiver
extends BroadcastReceiver {
    @NonNull
    private final EventChannel.EventSink events;
    private ServiceStatus lastKnownServiceStatus;

    public LocationServiceStatusReceiver(@NonNull EventChannel.EventSink events) {
        this.events = events;
    }

    public void onReceive(Context context, Intent intent) {
        if ("android.location.PROVIDERS_CHANGED".equals(intent.getAction())) {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            boolean isGpsEnabled = locationManager.isProviderEnabled("gps");
            boolean isNetworkEnabled = locationManager.isProviderEnabled("network");
            if (isGpsEnabled || isNetworkEnabled) {
                if (this.lastKnownServiceStatus == null || this.lastKnownServiceStatus == ServiceStatus.disabled) {
                    this.lastKnownServiceStatus = ServiceStatus.enabled;
                    this.events.success((Object)ServiceStatus.enabled.ordinal());
                }
            } else if (this.lastKnownServiceStatus == null || this.lastKnownServiceStatus == ServiceStatus.enabled) {
                this.lastKnownServiceStatus = ServiceStatus.disabled;
                this.events.success((Object)ServiceStatus.disabled.ordinal());
            }
        }
    }
}

