/*
 * Decompiled with CFR 0.152.
 */
package com.baseflow.geolocator.location;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.IntentSender;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baseflow.geolocator.errors.ErrorCallback;
import com.baseflow.geolocator.errors.ErrorCodes;
import com.baseflow.geolocator.location.LocationAccuracy;
import com.baseflow.geolocator.location.LocationClient;
import com.baseflow.geolocator.location.LocationOptions;
import com.baseflow.geolocator.location.LocationServiceListener;
import com.baseflow.geolocator.location.NmeaClient;
import com.baseflow.geolocator.location.PositionChangedCallback;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.location.LocationSettingsStates;
import com.google.android.gms.location.SettingsClient;
import java.security.SecureRandom;

class FusedLocationClient
implements LocationClient {
    private static final String TAG = "FlutterGeolocator";
    private final Context context;
    private final LocationCallback locationCallback;
    private final FusedLocationProviderClient fusedLocationProviderClient;
    private final NmeaClient nmeaClient;
    private final int activityRequestCode;
    @Nullable
    private final LocationOptions locationOptions;
    @Nullable
    private ErrorCallback errorCallback;
    @Nullable
    private PositionChangedCallback positionChangedCallback;

    public FusedLocationClient(final @NonNull Context context, final @Nullable LocationOptions locationOptions) {
        this.context = context;
        this.fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)context);
        this.locationOptions = locationOptions;
        this.nmeaClient = new NmeaClient(context, locationOptions);
        this.activityRequestCode = this.generateActivityRequestCode();
        this.locationCallback = new LocationCallback(){

            public synchronized void onLocationResult(@NonNull LocationResult locationResult) {
                if (FusedLocationClient.this.positionChangedCallback == null) {
                    Log.e((String)FusedLocationClient.TAG, (String)"LocationCallback was called with empty locationResult or no positionChangedCallback was registered.");
                    FusedLocationClient.this.fusedLocationProviderClient.removeLocationUpdates(FusedLocationClient.this.locationCallback);
                    if (FusedLocationClient.this.errorCallback != null) {
                        FusedLocationClient.this.errorCallback.onError(ErrorCodes.errorWhileAcquiringPosition);
                    }
                    return;
                }
                Location location = locationResult.getLastLocation();
                if (location == null) {
                    return;
                }
                if (location.getExtras() == null) {
                    location.setExtras(Bundle.EMPTY);
                }
                if (locationOptions != null) {
                    location.getExtras().putBoolean("geolocator_use_mslAltitude", locationOptions.isUseMSLAltitude());
                }
                FusedLocationClient.this.nmeaClient.enrichExtrasWithNmea(location);
                FusedLocationClient.this.positionChangedCallback.onPositionChanged(location);
            }

            public synchronized void onLocationAvailability(@NonNull LocationAvailability locationAvailability) {
                if (!locationAvailability.isLocationAvailable() && !FusedLocationClient.this.checkLocationService(context) && FusedLocationClient.this.errorCallback != null) {
                    FusedLocationClient.this.errorCallback.onError(ErrorCodes.locationServicesDisabled);
                }
            }
        };
    }

    private static LocationRequest buildLocationRequest(@Nullable LocationOptions options) {
        if (Build.VERSION.SDK_INT < 33) {
            return FusedLocationClient.buildLocationRequestDeprecated(options);
        }
        LocationRequest.Builder builder = new LocationRequest.Builder(0L);
        if (options != null) {
            builder.setPriority(FusedLocationClient.toPriority(options.getAccuracy()));
            builder.setIntervalMillis(options.getTimeInterval());
            builder.setMinUpdateIntervalMillis(options.getTimeInterval());
            builder.setMinUpdateDistanceMeters((float)options.getDistanceFilter());
        }
        return builder.build();
    }

    private static LocationRequest buildLocationRequestDeprecated(@Nullable LocationOptions options) {
        LocationRequest locationRequest = LocationRequest.create();
        if (options != null) {
            locationRequest.setPriority(FusedLocationClient.toPriority(options.getAccuracy()));
            locationRequest.setInterval(options.getTimeInterval());
            locationRequest.setFastestInterval(options.getTimeInterval() / 2L);
            locationRequest.setSmallestDisplacement((float)options.getDistanceFilter());
        }
        return locationRequest;
    }

    private static LocationSettingsRequest buildLocationSettingsRequest(LocationRequest locationRequest) {
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder();
        builder.addLocationRequest(locationRequest);
        return builder.build();
    }

    private static int toPriority(LocationAccuracy locationAccuracy) {
        switch (locationAccuracy) {
            case lowest: {
                return 105;
            }
            case low: {
                return 104;
            }
            case medium: {
                return 102;
            }
        }
        return 100;
    }

    private synchronized int generateActivityRequestCode() {
        SecureRandom random = new SecureRandom();
        return random.nextInt(65536);
    }

    @SuppressLint(value={"MissingPermission"})
    private void requestPositionUpdates(LocationOptions locationOptions) {
        LocationRequest locationRequest = FusedLocationClient.buildLocationRequest(locationOptions);
        this.nmeaClient.start();
        this.fusedLocationProviderClient.requestLocationUpdates(locationRequest, this.locationCallback, Looper.getMainLooper());
    }

    @Override
    public void isLocationServiceEnabled(LocationServiceListener listener) {
        LocationServices.getSettingsClient((Context)this.context).checkLocationSettings(new LocationSettingsRequest.Builder().build()).addOnCompleteListener(response -> {
            LocationSettingsResponse lsr;
            if (!response.isSuccessful()) {
                listener.onLocationServiceError(ErrorCodes.locationServicesDisabled);
            }
            if ((lsr = (LocationSettingsResponse)response.getResult()) != null) {
                LocationSettingsStates settingsStates = lsr.getLocationSettingsStates();
                boolean isGpsUsable = settingsStates != null && settingsStates.isGpsUsable();
                boolean isNetworkUsable = settingsStates != null && settingsStates.isNetworkLocationUsable();
                listener.onLocationServiceResult(isGpsUsable || isNetworkUsable);
            } else {
                listener.onLocationServiceError(ErrorCodes.locationServicesDisabled);
            }
        });
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void getLastKnownPosition(PositionChangedCallback positionChangedCallback, ErrorCallback errorCallback) {
        this.fusedLocationProviderClient.getLastLocation().addOnSuccessListener(positionChangedCallback::onPositionChanged).addOnFailureListener(e -> {
            Log.e((String)"Geolocator", (String)"Error trying to get last the last known GPS location");
            if (errorCallback != null) {
                errorCallback.onError(ErrorCodes.errorWhileAcquiringPosition);
            }
        });
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode) {
        if (requestCode == this.activityRequestCode) {
            if (resultCode == -1) {
                if (this.locationOptions == null || this.positionChangedCallback == null || this.errorCallback == null) {
                    return false;
                }
                this.requestPositionUpdates(this.locationOptions);
                return true;
            }
            if (this.errorCallback != null) {
                this.errorCallback.onError(ErrorCodes.locationServicesDisabled);
            }
        }
        return false;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void startPositionUpdates(@Nullable Activity activity, @NonNull PositionChangedCallback positionChangedCallback, @NonNull ErrorCallback errorCallback) {
        this.positionChangedCallback = positionChangedCallback;
        this.errorCallback = errorCallback;
        LocationRequest locationRequest = FusedLocationClient.buildLocationRequest(this.locationOptions);
        LocationSettingsRequest settingsRequest = FusedLocationClient.buildLocationSettingsRequest(locationRequest);
        SettingsClient settingsClient = LocationServices.getSettingsClient((Context)this.context);
        settingsClient.checkLocationSettings(settingsRequest).addOnSuccessListener(locationSettingsResponse -> this.requestPositionUpdates(this.locationOptions)).addOnFailureListener(e -> {
            if (e instanceof ResolvableApiException) {
                if (activity == null) {
                    errorCallback.onError(ErrorCodes.locationServicesDisabled);
                    return;
                }
                ResolvableApiException rae = (ResolvableApiException)e;
                int statusCode = rae.getStatusCode();
                if (statusCode == 6) {
                    try {
                        rae.startResolutionForResult(activity, this.activityRequestCode);
                    }
                    catch (IntentSender.SendIntentException sie) {
                        errorCallback.onError(ErrorCodes.locationServicesDisabled);
                    }
                } else {
                    errorCallback.onError(ErrorCodes.locationServicesDisabled);
                }
            } else {
                ApiException ae = (ApiException)e;
                int statusCode = ae.getStatusCode();
                if (statusCode == 8502) {
                    this.requestPositionUpdates(this.locationOptions);
                } else {
                    errorCallback.onError(ErrorCodes.locationServicesDisabled);
                }
            }
        });
    }

    @Override
    public void stopPositionUpdates() {
        this.nmeaClient.stop();
        this.fusedLocationProviderClient.removeLocationUpdates(this.locationCallback);
    }
}

