/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.android.gms.maps.model.TileOverlayOptions;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.Messages;
import io.flutter.plugins.googlemaps.TileOverlayBuilder;
import io.flutter.plugins.googlemaps.TileOverlayController;
import io.flutter.plugins.googlemaps.TileProviderController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TileOverlaysController {
    private final Map<String, TileOverlayController> tileOverlayIdToController = new HashMap<String, TileOverlayController>();
    private final Messages.MapsCallbackApi flutterApi;
    private GoogleMap googleMap;

    TileOverlaysController(Messages.MapsCallbackApi flutterApi) {
        this.flutterApi = flutterApi;
    }

    void setGoogleMap(GoogleMap googleMap) {
        this.googleMap = googleMap;
    }

    void addTileOverlays(@NonNull List<Messages.PlatformTileOverlay> tileOverlaysToAdd) {
        for (Messages.PlatformTileOverlay tileOverlayToAdd : tileOverlaysToAdd) {
            this.addTileOverlay(tileOverlayToAdd);
        }
    }

    void changeTileOverlays(@NonNull List<Messages.PlatformTileOverlay> tileOverlaysToChange) {
        for (Messages.PlatformTileOverlay tileOverlayToChange : tileOverlaysToChange) {
            this.changeTileOverlay(tileOverlayToChange);
        }
    }

    void removeTileOverlays(List<String> tileOverlayIdsToRemove) {
        if (tileOverlayIdsToRemove == null) {
            return;
        }
        for (String tileOverlayId : tileOverlayIdsToRemove) {
            if (tileOverlayId == null) continue;
            this.removeTileOverlay(tileOverlayId);
        }
    }

    void clearTileCache(String tileOverlayId) {
        if (tileOverlayId == null) {
            return;
        }
        TileOverlayController tileOverlayController = this.tileOverlayIdToController.get(tileOverlayId);
        if (tileOverlayController != null) {
            tileOverlayController.clearTileCache();
        }
    }

    @Nullable
    TileOverlay getTileOverlay(String tileOverlayId) {
        if (tileOverlayId == null) {
            return null;
        }
        TileOverlayController tileOverlayController = this.tileOverlayIdToController.get(tileOverlayId);
        if (tileOverlayController == null) {
            return null;
        }
        return tileOverlayController.getTileOverlay();
    }

    private void addTileOverlay(@NonNull Messages.PlatformTileOverlay platformTileOverlay) {
        TileOverlayBuilder tileOverlayOptionsBuilder = new TileOverlayBuilder();
        String tileOverlayId = Convert.interpretTileOverlayOptions(platformTileOverlay, tileOverlayOptionsBuilder);
        TileProviderController tileProviderController = new TileProviderController(this.flutterApi, tileOverlayId);
        tileOverlayOptionsBuilder.setTileProvider(tileProviderController);
        TileOverlayOptions options = tileOverlayOptionsBuilder.build();
        TileOverlay tileOverlay = this.googleMap.addTileOverlay(options);
        TileOverlayController tileOverlayController = new TileOverlayController(tileOverlay);
        this.tileOverlayIdToController.put(tileOverlayId, tileOverlayController);
    }

    private void changeTileOverlay(@NonNull Messages.PlatformTileOverlay platformTileOverlay) {
        String tileOverlayId = platformTileOverlay.getTileOverlayId();
        TileOverlayController tileOverlayController = this.tileOverlayIdToController.get(tileOverlayId);
        if (tileOverlayController != null) {
            Convert.interpretTileOverlayOptions(platformTileOverlay, tileOverlayController);
        }
    }

    private void removeTileOverlay(String tileOverlayId) {
        TileOverlayController tileOverlayController = this.tileOverlayIdToController.get(tileOverlayId);
        if (tileOverlayController != null) {
            tileOverlayController.remove();
            this.tileOverlayIdToController.remove(tileOverlayId);
        }
    }

    private static String getTileOverlayId(Map<String, ?> tileOverlay) {
        return (String)tileOverlay.get("tileOverlayId");
    }
}

