/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.os.Bundle;
import android.os.Process;
import android.util.Log;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.MapStyleOptions;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterManager;
import com.google.maps.android.collections.MarkerManager;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugins.googlemaps.CirclesController;
import io.flutter.plugins.googlemaps.ClusterManagersController;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.GoogleMapListener;
import io.flutter.plugins.googlemaps.GoogleMapOptionsSink;
import io.flutter.plugins.googlemaps.GroundOverlaysController;
import io.flutter.plugins.googlemaps.HeatmapsController;
import io.flutter.plugins.googlemaps.LifecycleProvider;
import io.flutter.plugins.googlemaps.MarkerBuilder;
import io.flutter.plugins.googlemaps.MarkersController;
import io.flutter.plugins.googlemaps.Messages;
import io.flutter.plugins.googlemaps.NoOpVoidResult;
import io.flutter.plugins.googlemaps.PolygonsController;
import io.flutter.plugins.googlemaps.PolylinesController;
import io.flutter.plugins.googlemaps.TileOverlaysController;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class GoogleMapController
implements ActivityPluginBinding.OnSaveInstanceStateListener,
ClusterManager.OnClusterItemClickListener<MarkerBuilder>,
ClusterManagersController.OnClusterItemRendered<MarkerBuilder>,
DefaultLifecycleObserver,
GoogleMapListener,
GoogleMapOptionsSink,
Messages.MapsApi,
Messages.MapsInspectorApi,
OnMapReadyCallback,
PlatformView {
    private static final String TAG = "GoogleMapController";
    private final int id;
    private final Messages.MapsCallbackApi flutterApi;
    private final BinaryMessenger binaryMessenger;
    private final GoogleMapOptions options;
    @Nullable
    private MapView mapView;
    @Nullable
    private GoogleMap googleMap;
    private boolean trackCameraPosition = false;
    private boolean myLocationEnabled = false;
    private boolean myLocationButtonEnabled = false;
    private boolean zoomControlsEnabled = true;
    private boolean indoorEnabled = true;
    private boolean trafficEnabled = false;
    private boolean buildingsEnabled = true;
    private boolean disposed = false;
    @VisibleForTesting
    final float density;
    @Nullable
    private Messages.VoidResult mapReadyResult;
    private final Context context;
    private final LifecycleProvider lifecycleProvider;
    private final MarkersController markersController;
    private final ClusterManagersController clusterManagersController;
    private final PolygonsController polygonsController;
    private final PolylinesController polylinesController;
    private final CirclesController circlesController;
    private final HeatmapsController heatmapsController;
    private final TileOverlaysController tileOverlaysController;
    private final GroundOverlaysController groundOverlaysController;
    private MarkerManager markerManager;
    private MarkerManager.Collection markerCollection;
    @Nullable
    private List<Messages.PlatformMarker> initialMarkers;
    @Nullable
    private List<Messages.PlatformClusterManager> initialClusterManagers;
    @Nullable
    private List<Messages.PlatformPolygon> initialPolygons;
    @Nullable
    private List<Messages.PlatformPolyline> initialPolylines;
    @Nullable
    private List<Messages.PlatformCircle> initialCircles;
    @Nullable
    private List<Messages.PlatformHeatmap> initialHeatmaps;
    @Nullable
    private List<Messages.PlatformTileOverlay> initialTileOverlays;
    @Nullable
    private List<Messages.PlatformGroundOverlay> initialGroundOverlays;
    @Nullable
    private String initialMapStyle;
    private boolean lastSetStyleSucceeded;
    @VisibleForTesting
    List<Float> initialPadding;

    GoogleMapController(int id, Context context, BinaryMessenger binaryMessenger, LifecycleProvider lifecycleProvider, GoogleMapOptions options) {
        this.id = id;
        this.context = context;
        this.options = options;
        this.mapView = new MapView(context, options);
        this.density = context.getResources().getDisplayMetrics().density;
        this.binaryMessenger = binaryMessenger;
        this.flutterApi = new Messages.MapsCallbackApi(binaryMessenger, Integer.toString(id));
        Messages.MapsApi.setUp(binaryMessenger, Integer.toString(id), this);
        Messages.MapsInspectorApi.setUp(binaryMessenger, Integer.toString(id), this);
        AssetManager assetManager = context.getAssets();
        this.lifecycleProvider = lifecycleProvider;
        this.clusterManagersController = new ClusterManagersController(this.flutterApi, context);
        this.markersController = new MarkersController(this.flutterApi, this.clusterManagersController, assetManager, this.density, new Convert.BitmapDescriptorFactoryWrapper());
        this.polygonsController = new PolygonsController(this.flutterApi, this.density);
        this.polylinesController = new PolylinesController(this.flutterApi, assetManager, this.density);
        this.circlesController = new CirclesController(this.flutterApi, this.density);
        this.heatmapsController = new HeatmapsController();
        this.tileOverlaysController = new TileOverlaysController(this.flutterApi);
        this.groundOverlaysController = new GroundOverlaysController(this.flutterApi, assetManager, this.density);
    }

    @VisibleForTesting
    GoogleMapController(int id, Context context, BinaryMessenger binaryMessenger, Messages.MapsCallbackApi flutterApi, LifecycleProvider lifecycleProvider, GoogleMapOptions options, ClusterManagersController clusterManagersController, MarkersController markersController, PolygonsController polygonsController, PolylinesController polylinesController, CirclesController circlesController, HeatmapsController heatmapController, TileOverlaysController tileOverlaysController, GroundOverlaysController groundOverlaysController) {
        this.id = id;
        this.context = context;
        this.binaryMessenger = binaryMessenger;
        this.flutterApi = flutterApi;
        this.options = options;
        this.mapView = new MapView(context, options);
        this.density = context.getResources().getDisplayMetrics().density;
        this.lifecycleProvider = lifecycleProvider;
        this.clusterManagersController = clusterManagersController;
        this.markersController = markersController;
        this.polygonsController = polygonsController;
        this.polylinesController = polylinesController;
        this.circlesController = circlesController;
        this.heatmapsController = heatmapController;
        this.tileOverlaysController = tileOverlaysController;
        this.groundOverlaysController = groundOverlaysController;
    }

    public View getView() {
        return this.mapView;
    }

    @VisibleForTesting
    void setView(MapView view) {
        this.mapView = view;
    }

    void init() {
        this.lifecycleProvider.getLifecycle().addObserver((LifecycleObserver)this);
        this.mapView.getMapAsync((OnMapReadyCallback)this);
    }

    public void onMapReady(@NonNull GoogleMap googleMap) {
        this.googleMap = googleMap;
        this.googleMap.setIndoorEnabled(this.indoorEnabled);
        this.googleMap.setTrafficEnabled(this.trafficEnabled);
        this.googleMap.setBuildingsEnabled(this.buildingsEnabled);
        this.installInvalidator();
        if (this.mapReadyResult != null) {
            this.mapReadyResult.success();
            this.mapReadyResult = null;
        }
        this.setGoogleMapListener(this);
        this.markerManager = new MarkerManager(googleMap);
        this.markerCollection = this.markerManager.newCollection();
        this.updateMyLocationSettings();
        this.markersController.setCollection(this.markerCollection);
        this.clusterManagersController.init(googleMap, this.markerManager);
        this.polygonsController.setGoogleMap(googleMap);
        this.polylinesController.setGoogleMap(googleMap);
        this.circlesController.setGoogleMap(googleMap);
        this.heatmapsController.setGoogleMap(googleMap);
        this.tileOverlaysController.setGoogleMap(googleMap);
        this.groundOverlaysController.setGoogleMap(googleMap);
        this.setMarkerCollectionListener(this);
        this.setClusterItemClickListener(this);
        this.setClusterItemRenderedListener(this);
        this.updateInitialClusterManagers();
        this.updateInitialMarkers();
        this.updateInitialPolygons();
        this.updateInitialPolylines();
        this.updateInitialCircles();
        this.updateInitialHeatmaps();
        this.updateInitialTileOverlays();
        this.updateInitialGroundOverlays();
        if (this.initialPadding != null && this.initialPadding.size() == 4) {
            this.setPadding(this.initialPadding.get(0).floatValue(), this.initialPadding.get(1).floatValue(), this.initialPadding.get(2).floatValue(), this.initialPadding.get(3).floatValue());
        }
        if (this.initialMapStyle != null) {
            this.updateMapStyle(this.initialMapStyle);
            this.initialMapStyle = null;
        }
    }

    private static TextureView findTextureView(ViewGroup group) {
        int n = group.getChildCount();
        for (int i = 0; i < n; ++i) {
            TextureView r;
            View view = group.getChildAt(i);
            if (view instanceof TextureView) {
                return (TextureView)view;
            }
            if (!(view instanceof ViewGroup) || (r = GoogleMapController.findTextureView((ViewGroup)view)) == null) continue;
            return r;
        }
        return null;
    }

    private void installInvalidator() {
        if (this.mapView == null) {
            return;
        }
        TextureView textureView = GoogleMapController.findTextureView((ViewGroup)this.mapView);
        if (textureView == null) {
            Log.i((String)TAG, (String)"No TextureView found. Likely using the LEGACY renderer.");
            return;
        }
        Log.i((String)TAG, (String)"Installing custom TextureView driven invalidator.");
        final TextureView.SurfaceTextureListener internalListener = textureView.getSurfaceTextureListener();
        final MapView mapView = this.mapView;
        textureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(@NonNull SurfaceTexture surface, int width, int height) {
                if (internalListener != null) {
                    internalListener.onSurfaceTextureAvailable(surface, width, height);
                }
            }

            public boolean onSurfaceTextureDestroyed(@NonNull SurfaceTexture surface) {
                if (internalListener != null) {
                    return internalListener.onSurfaceTextureDestroyed(surface);
                }
                return true;
            }

            public void onSurfaceTextureSizeChanged(@NonNull SurfaceTexture surface, int width, int height) {
                if (internalListener != null) {
                    internalListener.onSurfaceTextureSizeChanged(surface, width, height);
                }
            }

            public void onSurfaceTextureUpdated(@NonNull SurfaceTexture surface) {
                if (internalListener != null) {
                    internalListener.onSurfaceTextureUpdated(surface);
                }
                mapView.invalidate();
            }
        });
    }

    public void onMapClick(@NonNull LatLng latLng) {
        this.flutterApi.onTap(Convert.latLngToPigeon(latLng), new NoOpVoidResult());
    }

    public void onMapLongClick(@NonNull LatLng latLng) {
        this.flutterApi.onLongPress(Convert.latLngToPigeon(latLng), new NoOpVoidResult());
    }

    public void onCameraMoveStarted(int reason) {
        this.flutterApi.onCameraMoveStarted(new NoOpVoidResult());
    }

    public void onInfoWindowClick(Marker marker) {
        this.markersController.onInfoWindowTap(marker.getId());
    }

    public void onCameraMove() {
        if (!this.trackCameraPosition) {
            return;
        }
        this.flutterApi.onCameraMove(Convert.cameraPositionToPigeon(this.googleMap.getCameraPosition()), new NoOpVoidResult());
    }

    public void onCameraIdle() {
        this.clusterManagersController.onCameraIdle();
        this.flutterApi.onCameraIdle(new NoOpVoidResult());
    }

    public boolean onMarkerClick(Marker marker) {
        return this.markersController.onMapsMarkerTap(marker.getId());
    }

    public void onMarkerDragStart(Marker marker) {
        this.markersController.onMarkerDragStart(marker.getId(), marker.getPosition());
    }

    public void onMarkerDrag(Marker marker) {
        this.markersController.onMarkerDrag(marker.getId(), marker.getPosition());
    }

    public void onMarkerDragEnd(Marker marker) {
        this.markersController.onMarkerDragEnd(marker.getId(), marker.getPosition());
    }

    public void onPolygonClick(Polygon polygon) {
        this.polygonsController.onPolygonTap(polygon.getId());
    }

    public void onPolylineClick(Polyline polyline) {
        this.polylinesController.onPolylineTap(polyline.getId());
    }

    public void onCircleClick(Circle circle) {
        this.circlesController.onCircleTap(circle.getId());
    }

    public void onGroundOverlayClick(@NonNull GroundOverlay groundOverlay) {
        this.groundOverlaysController.onGroundOverlayTap(groundOverlay.getId());
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        Messages.MapsApi.setUp(this.binaryMessenger, Integer.toString(this.id), null);
        Messages.MapsInspectorApi.setUp(this.binaryMessenger, Integer.toString(this.id), null);
        this.setGoogleMapListener(null);
        this.setMarkerCollectionListener(null);
        this.setClusterItemClickListener(null);
        this.setClusterItemRenderedListener(null);
        this.destroyMapViewIfNecessary();
        Lifecycle lifecycle = this.lifecycleProvider.getLifecycle();
        if (lifecycle != null) {
            lifecycle.removeObserver((LifecycleObserver)this);
        }
    }

    private void setGoogleMapListener(@Nullable GoogleMapListener listener) {
        if (this.googleMap == null) {
            Log.v((String)TAG, (String)"Controller was disposed before GoogleMap was ready.");
            return;
        }
        this.googleMap.setOnCameraMoveStartedListener((GoogleMap.OnCameraMoveStartedListener)listener);
        this.googleMap.setOnCameraMoveListener((GoogleMap.OnCameraMoveListener)listener);
        this.googleMap.setOnCameraIdleListener((GoogleMap.OnCameraIdleListener)listener);
        this.googleMap.setOnPolygonClickListener((GoogleMap.OnPolygonClickListener)listener);
        this.googleMap.setOnPolylineClickListener((GoogleMap.OnPolylineClickListener)listener);
        this.googleMap.setOnCircleClickListener((GoogleMap.OnCircleClickListener)listener);
        this.googleMap.setOnMapClickListener((GoogleMap.OnMapClickListener)listener);
        this.googleMap.setOnMapLongClickListener((GoogleMap.OnMapLongClickListener)listener);
        this.googleMap.setOnGroundOverlayClickListener((GoogleMap.OnGroundOverlayClickListener)listener);
    }

    @VisibleForTesting
    public void setMarkerCollectionListener(@Nullable GoogleMapListener listener) {
        if (this.googleMap == null) {
            Log.v((String)TAG, (String)"Controller was disposed before GoogleMap was ready.");
            return;
        }
        this.markerCollection.setOnMarkerClickListener((GoogleMap.OnMarkerClickListener)listener);
        this.markerCollection.setOnMarkerDragListener((GoogleMap.OnMarkerDragListener)listener);
        this.markerCollection.setOnInfoWindowClickListener((GoogleMap.OnInfoWindowClickListener)listener);
    }

    @VisibleForTesting
    public void setClusterItemClickListener(@Nullable ClusterManager.OnClusterItemClickListener<MarkerBuilder> listener) {
        if (this.googleMap == null) {
            Log.v((String)TAG, (String)"Controller was disposed before GoogleMap was ready.");
            return;
        }
        this.clusterManagersController.setClusterItemClickListener(listener);
    }

    @VisibleForTesting
    public void setClusterItemRenderedListener(@Nullable ClusterManagersController.OnClusterItemRendered<MarkerBuilder> listener) {
        if (this.googleMap == null) {
            Log.v((String)TAG, (String)"Controller was disposed before GoogleMap was ready.");
            return;
        }
        this.clusterManagersController.setClusterItemRenderedListener(listener);
    }

    public void onCreate(@NonNull LifecycleOwner owner) {
        if (this.disposed) {
            return;
        }
        this.mapView.onCreate(null);
    }

    public void onStart(@NonNull LifecycleOwner owner) {
        if (this.disposed) {
            return;
        }
        this.mapView.onStart();
    }

    public void onResume(@NonNull LifecycleOwner owner) {
        if (this.disposed) {
            return;
        }
        this.mapView.onResume();
    }

    public void onPause(@NonNull LifecycleOwner owner) {
        if (this.disposed) {
            return;
        }
        this.mapView.onResume();
    }

    public void onStop(@NonNull LifecycleOwner owner) {
        if (this.disposed) {
            return;
        }
        this.mapView.onStop();
    }

    public void onDestroy(@NonNull LifecycleOwner owner) {
        owner.getLifecycle().removeObserver((LifecycleObserver)this);
        if (this.disposed) {
            return;
        }
        this.destroyMapViewIfNecessary();
    }

    public void onRestoreInstanceState(Bundle bundle) {
        if (this.disposed) {
            return;
        }
        this.mapView.onCreate(bundle);
    }

    public void onSaveInstanceState(@NonNull Bundle bundle) {
        if (this.disposed) {
            return;
        }
        this.mapView.onSaveInstanceState(bundle);
    }

    @Override
    public void setCameraTargetBounds(LatLngBounds bounds) {
        this.googleMap.setLatLngBoundsForCameraTarget(bounds);
    }

    @Override
    public void setCompassEnabled(boolean compassEnabled) {
        this.googleMap.getUiSettings().setCompassEnabled(compassEnabled);
    }

    @Override
    public void setMapToolbarEnabled(boolean mapToolbarEnabled) {
        this.googleMap.getUiSettings().setMapToolbarEnabled(mapToolbarEnabled);
    }

    @Override
    public void setMapType(int mapType) {
        this.googleMap.setMapType(mapType);
    }

    @Override
    public void setTrackCameraPosition(boolean trackCameraPosition) {
        this.trackCameraPosition = trackCameraPosition;
    }

    @Override
    public void setRotateGesturesEnabled(boolean rotateGesturesEnabled) {
        this.googleMap.getUiSettings().setRotateGesturesEnabled(rotateGesturesEnabled);
    }

    @Override
    public void setScrollGesturesEnabled(boolean scrollGesturesEnabled) {
        this.googleMap.getUiSettings().setScrollGesturesEnabled(scrollGesturesEnabled);
    }

    @Override
    public void setTiltGesturesEnabled(boolean tiltGesturesEnabled) {
        this.googleMap.getUiSettings().setTiltGesturesEnabled(tiltGesturesEnabled);
    }

    @Override
    public void setMinMaxZoomPreference(Float min, Float max) {
        this.googleMap.resetMinMaxZoomPreference();
        if (min != null) {
            this.googleMap.setMinZoomPreference(min.floatValue());
        }
        if (max != null) {
            this.googleMap.setMaxZoomPreference(max.floatValue());
        }
    }

    @Override
    public void setPadding(float top, float left, float bottom, float right) {
        if (this.googleMap != null) {
            this.googleMap.setPadding((int)(left * this.density), (int)(top * this.density), (int)(right * this.density), (int)(bottom * this.density));
        } else {
            this.setInitialPadding(top, left, bottom, right);
        }
    }

    @VisibleForTesting
    void setInitialPadding(float top, float left, float bottom, float right) {
        if (this.initialPadding == null) {
            this.initialPadding = new ArrayList<Float>();
        } else {
            this.initialPadding.clear();
        }
        this.initialPadding.add(Float.valueOf(top));
        this.initialPadding.add(Float.valueOf(left));
        this.initialPadding.add(Float.valueOf(bottom));
        this.initialPadding.add(Float.valueOf(right));
    }

    @Override
    public void setZoomGesturesEnabled(boolean zoomGesturesEnabled) {
        this.googleMap.getUiSettings().setZoomGesturesEnabled(zoomGesturesEnabled);
    }

    @Override
    public void setLiteModeEnabled(boolean liteModeEnabled) {
        this.options.liteMode(liteModeEnabled);
    }

    @Override
    public void setMyLocationEnabled(boolean myLocationEnabled) {
        if (this.myLocationEnabled == myLocationEnabled) {
            return;
        }
        this.myLocationEnabled = myLocationEnabled;
        if (this.googleMap != null) {
            this.updateMyLocationSettings();
        }
    }

    @Override
    public void setMyLocationButtonEnabled(boolean myLocationButtonEnabled) {
        if (this.myLocationButtonEnabled == myLocationButtonEnabled) {
            return;
        }
        this.myLocationButtonEnabled = myLocationButtonEnabled;
        if (this.googleMap != null) {
            this.updateMyLocationSettings();
        }
    }

    @Override
    public void setZoomControlsEnabled(boolean zoomControlsEnabled) {
        if (this.zoomControlsEnabled == zoomControlsEnabled) {
            return;
        }
        this.zoomControlsEnabled = zoomControlsEnabled;
        if (this.googleMap != null) {
            this.googleMap.getUiSettings().setZoomControlsEnabled(zoomControlsEnabled);
        }
    }

    @Override
    public void setInitialMarkers(@NonNull List<Messages.PlatformMarker> initialMarkers) {
        this.initialMarkers = initialMarkers;
        if (this.googleMap != null) {
            this.updateInitialMarkers();
        }
    }

    private void updateInitialMarkers() {
        if (this.initialMarkers != null) {
            this.markersController.addMarkers(this.initialMarkers);
        }
    }

    @Override
    public void setInitialClusterManagers(@NonNull List<Messages.PlatformClusterManager> initialClusterManagers) {
        this.initialClusterManagers = initialClusterManagers;
        if (this.googleMap != null) {
            this.updateInitialClusterManagers();
        }
    }

    private void updateInitialClusterManagers() {
        if (this.initialClusterManagers != null) {
            this.clusterManagersController.addClusterManagers(this.initialClusterManagers);
        }
    }

    @Override
    public void setInitialPolygons(@NonNull List<Messages.PlatformPolygon> initialPolygons) {
        this.initialPolygons = initialPolygons;
        if (this.googleMap != null) {
            this.updateInitialPolygons();
        }
    }

    private void updateInitialPolygons() {
        if (this.initialPolygons != null) {
            this.polygonsController.addPolygons(this.initialPolygons);
        }
    }

    @Override
    public void setInitialPolylines(@NonNull List<Messages.PlatformPolyline> initialPolylines) {
        this.initialPolylines = initialPolylines;
        if (this.googleMap != null) {
            this.updateInitialPolylines();
        }
    }

    private void updateInitialPolylines() {
        if (this.initialPolylines != null) {
            this.polylinesController.addPolylines(this.initialPolylines);
        }
    }

    @Override
    public void setInitialCircles(@NonNull List<Messages.PlatformCircle> initialCircles) {
        this.initialCircles = initialCircles;
        if (this.googleMap != null) {
            this.updateInitialCircles();
        }
    }

    @Override
    public void setInitialHeatmaps(@NonNull List<Messages.PlatformHeatmap> initialHeatmaps) {
        this.initialHeatmaps = initialHeatmaps;
        if (this.googleMap != null) {
            this.updateInitialHeatmaps();
        }
    }

    private void updateInitialCircles() {
        if (this.initialCircles != null) {
            this.circlesController.addCircles(this.initialCircles);
        }
    }

    private void updateInitialHeatmaps() {
        if (this.initialHeatmaps != null) {
            this.heatmapsController.addHeatmaps(this.initialHeatmaps);
        }
    }

    @Override
    public void setInitialTileOverlays(@NonNull List<Messages.PlatformTileOverlay> initialTileOverlays) {
        this.initialTileOverlays = initialTileOverlays;
        if (this.googleMap != null) {
            this.updateInitialTileOverlays();
        }
    }

    private void updateInitialTileOverlays() {
        if (this.initialTileOverlays != null) {
            this.tileOverlaysController.addTileOverlays(this.initialTileOverlays);
        }
    }

    @Override
    public void setInitialGroundOverlays(@NonNull List<Messages.PlatformGroundOverlay> initialGroundOverlays) {
        this.initialGroundOverlays = initialGroundOverlays;
        if (this.googleMap != null) {
            this.updateInitialGroundOverlays();
        }
    }

    private void updateInitialGroundOverlays() {
        if (this.initialGroundOverlays != null) {
            this.groundOverlaysController.addGroundOverlays(this.initialGroundOverlays);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void updateMyLocationSettings() {
        if (this.hasLocationPermission()) {
            this.googleMap.setMyLocationEnabled(this.myLocationEnabled);
            this.googleMap.getUiSettings().setMyLocationButtonEnabled(this.myLocationButtonEnabled);
        } else {
            Log.e((String)TAG, (String)"Cannot enable MyLocation layer as location permissions are not granted");
        }
    }

    private boolean hasLocationPermission() {
        return this.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0 || this.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0;
    }

    private int checkSelfPermission(String permission2) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        return this.context.checkPermission(permission2, Process.myPid(), Process.myUid());
    }

    private void destroyMapViewIfNecessary() {
        if (this.mapView == null) {
            return;
        }
        this.mapView.onDestroy();
        this.mapView = null;
    }

    @Override
    public void setIndoorEnabled(boolean indoorEnabled) {
        this.indoorEnabled = indoorEnabled;
    }

    @Override
    public void setTrafficEnabled(boolean trafficEnabled) {
        this.trafficEnabled = trafficEnabled;
        if (this.googleMap == null) {
            return;
        }
        this.googleMap.setTrafficEnabled(trafficEnabled);
    }

    @Override
    public void setBuildingsEnabled(boolean buildingsEnabled) {
        this.buildingsEnabled = buildingsEnabled;
    }

    @Override
    public void onClusterItemRendered(@NonNull MarkerBuilder markerBuilder, @NonNull Marker marker) {
        this.markersController.onClusterItemRendered(markerBuilder, marker);
    }

    public boolean onClusterItemClick(MarkerBuilder item) {
        return this.markersController.onMarkerTap(item.markerId());
    }

    @Override
    public void setMapStyle(@Nullable String style) {
        if (this.googleMap == null) {
            this.initialMapStyle = style;
        } else {
            this.updateMapStyle(style);
        }
    }

    private boolean updateMapStyle(String style) {
        MapStyleOptions mapStyleOptions = style == null || style.isEmpty() ? null : new MapStyleOptions(style);
        this.lastSetStyleSucceeded = Objects.requireNonNull(this.googleMap).setMapStyle(mapStyleOptions);
        return this.lastSetStyleSucceeded;
    }

    @Override
    public void waitForMap(@NonNull Messages.VoidResult result) {
        if (this.googleMap == null) {
            this.mapReadyResult = result;
        } else {
            result.success();
        }
    }

    @Override
    public void updateMapConfiguration(@NonNull Messages.PlatformMapConfiguration configuration) {
        Convert.interpretMapConfiguration(configuration, this);
    }

    @Override
    public void updateCircles(@NonNull List<Messages.PlatformCircle> toAdd, @NonNull List<Messages.PlatformCircle> toChange, @NonNull List<String> idsToRemove) {
        this.circlesController.addCircles(toAdd);
        this.circlesController.changeCircles(toChange);
        this.circlesController.removeCircles(idsToRemove);
    }

    @Override
    public void updateHeatmaps(@NonNull List<Messages.PlatformHeatmap> toAdd, @NonNull List<Messages.PlatformHeatmap> toChange, @NonNull List<String> idsToRemove) {
        this.heatmapsController.addHeatmaps(toAdd);
        this.heatmapsController.changeHeatmaps(toChange);
        this.heatmapsController.removeHeatmaps(idsToRemove);
    }

    @Override
    public void updateClusterManagers(@NonNull List<Messages.PlatformClusterManager> toAdd, @NonNull List<String> idsToRemove) {
        this.clusterManagersController.addClusterManagers(toAdd);
        this.clusterManagersController.removeClusterManagers(idsToRemove);
    }

    @Override
    public void updateMarkers(@NonNull List<Messages.PlatformMarker> toAdd, @NonNull List<Messages.PlatformMarker> toChange, @NonNull List<String> idsToRemove) {
        this.markersController.addMarkers(toAdd);
        this.markersController.changeMarkers(toChange);
        this.markersController.removeMarkers(idsToRemove);
    }

    @Override
    public void updatePolygons(@NonNull List<Messages.PlatformPolygon> toAdd, @NonNull List<Messages.PlatformPolygon> toChange, @NonNull List<String> idsToRemove) {
        this.polygonsController.addPolygons(toAdd);
        this.polygonsController.changePolygons(toChange);
        this.polygonsController.removePolygons(idsToRemove);
    }

    @Override
    public void updatePolylines(@NonNull List<Messages.PlatformPolyline> toAdd, @NonNull List<Messages.PlatformPolyline> toChange, @NonNull List<String> idsToRemove) {
        this.polylinesController.addPolylines(toAdd);
        this.polylinesController.changePolylines(toChange);
        this.polylinesController.removePolylines(idsToRemove);
    }

    @Override
    public void updateTileOverlays(@NonNull List<Messages.PlatformTileOverlay> toAdd, @NonNull List<Messages.PlatformTileOverlay> toChange, @NonNull List<String> idsToRemove) {
        this.tileOverlaysController.addTileOverlays(toAdd);
        this.tileOverlaysController.changeTileOverlays(toChange);
        this.tileOverlaysController.removeTileOverlays(idsToRemove);
    }

    @Override
    public void updateGroundOverlays(@NonNull List<Messages.PlatformGroundOverlay> toAdd, @NonNull List<Messages.PlatformGroundOverlay> toChange, @NonNull List<String> idsToRemove) {
        this.groundOverlaysController.addGroundOverlays(toAdd);
        this.groundOverlaysController.changeGroundOverlays(toChange);
        this.groundOverlaysController.removeGroundOverlays(idsToRemove);
    }

    @Override
    @NonNull
    public Messages.PlatformPoint getScreenCoordinate(@NonNull Messages.PlatformLatLng latLng) {
        if (this.googleMap == null) {
            throw new Messages.FlutterError("GoogleMap uninitialized", "getScreenCoordinate called prior to map initialization", null);
        }
        Point screenLocation = this.googleMap.getProjection().toScreenLocation(Convert.latLngFromPigeon(latLng));
        return Convert.pointToPigeon(screenLocation);
    }

    @Override
    @NonNull
    public Messages.PlatformLatLng getLatLng(@NonNull Messages.PlatformPoint screenCoordinate) {
        if (this.googleMap == null) {
            throw new Messages.FlutterError("GoogleMap uninitialized", "getLatLng called prior to map initialization", null);
        }
        LatLng latLng = this.googleMap.getProjection().fromScreenLocation(Convert.pointFromPigeon(screenCoordinate));
        return Convert.latLngToPigeon(latLng);
    }

    @Override
    @NonNull
    public Messages.PlatformLatLngBounds getVisibleRegion() {
        if (this.googleMap == null) {
            throw new Messages.FlutterError("GoogleMap uninitialized", "getVisibleRegion called prior to map initialization", null);
        }
        LatLngBounds latLngBounds = this.googleMap.getProjection().getVisibleRegion().latLngBounds;
        return Convert.latLngBoundsToPigeon(latLngBounds);
    }

    @Override
    public void moveCamera(@NonNull Messages.PlatformCameraUpdate cameraUpdate) {
        if (this.googleMap == null) {
            throw new Messages.FlutterError("GoogleMap uninitialized", "moveCamera called prior to map initialization", null);
        }
        this.googleMap.moveCamera(Convert.cameraUpdateFromPigeon(cameraUpdate, this.density));
    }

    @Override
    public void animateCamera(@NonNull Messages.PlatformCameraUpdate cameraUpdate, @Nullable Long durationMilliseconds) {
        if (this.googleMap == null) {
            throw new Messages.FlutterError("GoogleMap uninitialized", "animateCamera called prior to map initialization", null);
        }
        CameraUpdate update = Convert.cameraUpdateFromPigeon(cameraUpdate, this.density);
        if (durationMilliseconds != null) {
            this.googleMap.animateCamera(update, durationMilliseconds.intValue(), null);
        } else {
            this.googleMap.animateCamera(update);
        }
    }

    @Override
    @NonNull
    public Double getZoomLevel() {
        if (this.googleMap == null) {
            throw new Messages.FlutterError("GoogleMap uninitialized", "getZoomLevel called prior to map initialization", null);
        }
        return this.googleMap.getCameraPosition().zoom;
    }

    @Override
    public void showInfoWindow(@NonNull String markerId) {
        this.markersController.showMarkerInfoWindow(markerId);
    }

    @Override
    public void hideInfoWindow(@NonNull String markerId) {
        this.markersController.hideMarkerInfoWindow(markerId);
    }

    @Override
    @NonNull
    public Boolean isInfoWindowShown(@NonNull String markerId) {
        return this.markersController.isInfoWindowShown(markerId);
    }

    @Override
    @NonNull
    public Boolean setStyle(@NonNull String style) {
        return this.updateMapStyle(style);
    }

    @Override
    @NonNull
    public Boolean didLastStyleSucceed() {
        return this.lastSetStyleSucceeded;
    }

    @Override
    public void clearTileCache(@NonNull String tileOverlayId) {
        this.tileOverlaysController.clearTileCache(tileOverlayId);
    }

    @Override
    public void takeSnapshot(@NonNull Messages.Result<byte[]> result) {
        if (this.googleMap == null) {
            result.error(new Messages.FlutterError("GoogleMap uninitialized", "takeSnapshot", null));
        } else {
            this.googleMap.snapshot(bitmap -> {
                if (bitmap == null) {
                    result.error(new Messages.FlutterError("Snapshot failure", "Unable to take snapshot", null));
                } else {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
                    byte[] byteArray = stream.toByteArray();
                    bitmap.recycle();
                    result.success(byteArray);
                }
            });
        }
    }

    @Override
    @NonNull
    public Boolean areBuildingsEnabled() {
        return Objects.requireNonNull(this.googleMap).isBuildingsEnabled();
    }

    @Override
    @NonNull
    public Boolean areRotateGesturesEnabled() {
        return Objects.requireNonNull(this.googleMap).getUiSettings().isRotateGesturesEnabled();
    }

    @Override
    @NonNull
    public Boolean areZoomControlsEnabled() {
        return Objects.requireNonNull(this.googleMap).getUiSettings().isZoomControlsEnabled();
    }

    @Override
    @NonNull
    public Boolean areScrollGesturesEnabled() {
        return Objects.requireNonNull(this.googleMap).getUiSettings().isScrollGesturesEnabled();
    }

    @Override
    @NonNull
    public Boolean areTiltGesturesEnabled() {
        return Objects.requireNonNull(this.googleMap).getUiSettings().isTiltGesturesEnabled();
    }

    @Override
    @NonNull
    public Boolean areZoomGesturesEnabled() {
        return Objects.requireNonNull(this.googleMap).getUiSettings().isZoomGesturesEnabled();
    }

    @Override
    @NonNull
    public Boolean isCompassEnabled() {
        return Objects.requireNonNull(this.googleMap).getUiSettings().isCompassEnabled();
    }

    @Override
    public Boolean isLiteModeEnabled() {
        return this.options.getLiteMode();
    }

    @Override
    @NonNull
    public Boolean isMapToolbarEnabled() {
        return Objects.requireNonNull(this.googleMap).getUiSettings().isMapToolbarEnabled();
    }

    @Override
    @NonNull
    public Boolean isMyLocationButtonEnabled() {
        return Objects.requireNonNull(this.googleMap).getUiSettings().isMyLocationButtonEnabled();
    }

    @Override
    @NonNull
    public Boolean isTrafficEnabled() {
        return Objects.requireNonNull(this.googleMap).isTrafficEnabled();
    }

    @Override
    @NonNull
    public Messages.PlatformCameraPosition getCameraPosition() {
        return Convert.cameraPositionToPigeon(Objects.requireNonNull(this.googleMap).getCameraPosition());
    }

    @Override
    @Nullable
    public Messages.PlatformTileLayer getTileOverlayInfo(@NonNull String tileOverlayId) {
        TileOverlay tileOverlay = this.tileOverlaysController.getTileOverlay(tileOverlayId);
        if (tileOverlay == null) {
            return null;
        }
        return new Messages.PlatformTileLayer.Builder().setFadeIn(tileOverlay.getFadeIn()).setTransparency(Double.valueOf(tileOverlay.getTransparency())).setZIndex(Double.valueOf(tileOverlay.getZIndex())).setVisible(tileOverlay.isVisible()).build();
    }

    @Override
    @Nullable
    public Messages.PlatformGroundOverlay getGroundOverlayInfo(@NonNull String groundOverlayId) {
        GroundOverlay groundOverlay = this.groundOverlaysController.getGroundOverlay(groundOverlayId);
        if (groundOverlay == null) {
            return null;
        }
        return Convert.groundOverlayToPigeon(groundOverlay, groundOverlayId, this.groundOverlaysController.isCreatedWithBounds(groundOverlayId));
    }

    @Override
    @NonNull
    public Messages.PlatformZoomRange getZoomRange() {
        return new Messages.PlatformZoomRange.Builder().setMin(Double.valueOf(Objects.requireNonNull(this.googleMap).getMinZoomLevel())).setMax(Double.valueOf(Objects.requireNonNull(this.googleMap).getMaxZoomLevel())).build();
    }

    @Override
    @NonNull
    public List<Messages.PlatformCluster> getClusters(@NonNull String clusterManagerId) {
        Set<? extends Cluster<MarkerBuilder>> clusters = this.clusterManagersController.getClustersWithClusterManagerId(clusterManagerId);
        ArrayList<Messages.PlatformCluster> data = new ArrayList<Messages.PlatformCluster>(clusters.size());
        for (Cluster<MarkerBuilder> cluster : clusters) {
            data.add(Convert.clusterToPigeon(clusterManagerId, cluster));
        }
        return data;
    }
}

