/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import androidx.annotation.NonNull;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.Messages;
import io.flutter.plugins.googlemaps.NoOpVoidResult;
import io.flutter.plugins.googlemaps.PolygonBuilder;
import io.flutter.plugins.googlemaps.PolygonController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PolygonsController {
    private final Map<String, PolygonController> polygonIdToController = new HashMap<String, PolygonController>();
    private final Map<String, String> googleMapsPolygonIdToDartPolygonId = new HashMap<String, String>();
    @NonNull
    private final Messages.MapsCallbackApi flutterApi;
    private final float density;
    private GoogleMap googleMap;

    PolygonsController(@NonNull Messages.MapsCallbackApi flutterApi, float density) {
        this.flutterApi = flutterApi;
        this.density = density;
    }

    void setGoogleMap(GoogleMap googleMap) {
        this.googleMap = googleMap;
    }

    void addPolygons(@NonNull List<Messages.PlatformPolygon> polygonsToAdd) {
        for (Messages.PlatformPolygon polygonToAdd : polygonsToAdd) {
            this.addPolygon(polygonToAdd);
        }
    }

    void changePolygons(@NonNull List<Messages.PlatformPolygon> polygonsToChange) {
        for (Messages.PlatformPolygon polygonToChange : polygonsToChange) {
            this.changePolygon(polygonToChange);
        }
    }

    void removePolygons(@NonNull List<String> polygonIdsToRemove) {
        for (String polygonId : polygonIdsToRemove) {
            PolygonController polygonController = this.polygonIdToController.remove(polygonId);
            if (polygonController == null) continue;
            polygonController.remove();
            this.googleMapsPolygonIdToDartPolygonId.remove(polygonController.getGoogleMapsPolygonId());
        }
    }

    boolean onPolygonTap(String googlePolygonId) {
        String polygonId = this.googleMapsPolygonIdToDartPolygonId.get(googlePolygonId);
        if (polygonId == null) {
            return false;
        }
        this.flutterApi.onPolygonTap(polygonId, new NoOpVoidResult());
        PolygonController polygonController = this.polygonIdToController.get(polygonId);
        if (polygonController != null) {
            return polygonController.consumeTapEvents();
        }
        return false;
    }

    private void addPolygon(@NonNull Messages.PlatformPolygon polygon) {
        PolygonBuilder polygonBuilder = new PolygonBuilder(this.density);
        String polygonId = Convert.interpretPolygonOptions(polygon, polygonBuilder);
        PolygonOptions options = polygonBuilder.build();
        this.addPolygon(polygonId, options, polygonBuilder.consumeTapEvents());
    }

    private void addPolygon(String polygonId, PolygonOptions polygonOptions, boolean consumeTapEvents) {
        Polygon polygon = this.googleMap.addPolygon(polygonOptions);
        PolygonController controller = new PolygonController(polygon, consumeTapEvents, this.density);
        this.polygonIdToController.put(polygonId, controller);
        this.googleMapsPolygonIdToDartPolygonId.put(polygon.getId(), polygonId);
    }

    private void changePolygon(@NonNull Messages.PlatformPolygon polygon) {
        PolygonController polygonController = this.polygonIdToController.get(polygon.getPolygonId());
        if (polygonController != null) {
            Convert.interpretPolygonOptions(polygon, polygonController);
        }
    }

    private static String getPolygonId(Map<String, ?> polygon) {
        return (String)polygon.get("polygonId");
    }
}

