/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.LatLng;
import io.flutter.plugins.googlemaps.CircleOptionsSink;

class CircleController
implements CircleOptionsSink {
    private final Circle circle;
    private final String googleMapsCircleId;
    private final float density;
    private boolean consumeTapEvents;

    CircleController(Circle circle, boolean consumeTapEvents, float density) {
        this.circle = circle;
        this.consumeTapEvents = consumeTapEvents;
        this.density = density;
        this.googleMapsCircleId = circle.getId();
    }

    void remove() {
        this.circle.remove();
    }

    @Override
    public void setConsumeTapEvents(boolean consumeTapEvents) {
        this.consumeTapEvents = consumeTapEvents;
        this.circle.setClickable(consumeTapEvents);
    }

    @Override
    public void setStrokeColor(int strokeColor) {
        this.circle.setStrokeColor(strokeColor);
    }

    @Override
    public void setFillColor(int fillColor) {
        this.circle.setFillColor(fillColor);
    }

    @Override
    public void setCenter(LatLng center) {
        this.circle.setCenter(center);
    }

    @Override
    public void setRadius(double radius) {
        this.circle.setRadius(radius);
    }

    @Override
    public void setVisible(boolean visible) {
        this.circle.setVisible(visible);
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        this.circle.setStrokeWidth(strokeWidth * this.density);
    }

    @Override
    public void setZIndex(float zIndex) {
        this.circle.setZIndex(zIndex);
    }

    String getGoogleMapsCircleId() {
        return this.googleMapsCircleId;
    }

    boolean consumeTapEvents() {
        return this.consumeTapEvents;
    }
}

