/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolygonOptions;
import io.flutter.plugins.googlemaps.PolygonOptionsSink;
import java.util.List;

class PolygonBuilder
implements PolygonOptionsSink {
    private final PolygonOptions polygonOptions = new PolygonOptions();
    private final float density;
    private boolean consumeTapEvents;

    PolygonBuilder(float density) {
        this.density = density;
    }

    PolygonOptions build() {
        return this.polygonOptions;
    }

    boolean consumeTapEvents() {
        return this.consumeTapEvents;
    }

    @Override
    public void setFillColor(int color) {
        this.polygonOptions.fillColor(color);
    }

    @Override
    public void setStrokeColor(int color) {
        this.polygonOptions.strokeColor(color);
    }

    @Override
    public void setPoints(List<LatLng> points) {
        this.polygonOptions.addAll(points);
    }

    @Override
    public void setHoles(List<List<LatLng>> holes) {
        for (List<LatLng> hole : holes) {
            this.polygonOptions.addHole(hole);
        }
    }

    @Override
    public void setConsumeTapEvents(boolean consumeTapEvents) {
        this.consumeTapEvents = consumeTapEvents;
        this.polygonOptions.clickable(consumeTapEvents);
    }

    @Override
    public void setGeodesic(boolean geodisc) {
        this.polygonOptions.geodesic(geodisc);
    }

    @Override
    public void setVisible(boolean visible) {
        this.polygonOptions.visible(visible);
    }

    @Override
    public void setStrokeWidth(float width) {
        this.polygonOptions.strokeWidth(width * this.density);
    }

    @Override
    public void setZIndex(float zIndex) {
        this.polygonOptions.zIndex(zIndex);
    }
}

