/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import android.content.res.AssetManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import io.flutter.plugins.googlemaps.Convert;
import io.flutter.plugins.googlemaps.GroundOverlayBuilder;
import io.flutter.plugins.googlemaps.GroundOverlayController;
import io.flutter.plugins.googlemaps.Messages;
import io.flutter.plugins.googlemaps.NoOpVoidResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GroundOverlaysController {
    private final Map<String, GroundOverlayController> groundOverlayIdToController = new HashMap<String, GroundOverlayController>();
    private final HashMap<String, String> googleMapsGroundOverlayIdToDartGroundOverlayId = new HashMap();
    private final Messages.MapsCallbackApi flutterApi;
    private GoogleMap googleMap;
    private final AssetManager assetManager;
    private final float density;
    private final Convert.BitmapDescriptorFactoryWrapper bitmapDescriptorFactoryWrapper;

    GroundOverlaysController(@NonNull Messages.MapsCallbackApi flutterApi, @NonNull AssetManager assetManager, float density) {
        this(flutterApi, assetManager, density, new Convert.BitmapDescriptorFactoryWrapper());
    }

    @VisibleForTesting
    GroundOverlaysController(@NonNull Messages.MapsCallbackApi flutterApi, @NonNull AssetManager assetManager, float density, @NonNull Convert.BitmapDescriptorFactoryWrapper bitmapDescriptorFactoryWrapper) {
        this.flutterApi = flutterApi;
        this.assetManager = assetManager;
        this.density = density;
        this.bitmapDescriptorFactoryWrapper = bitmapDescriptorFactoryWrapper;
    }

    void setGoogleMap(GoogleMap googleMap) {
        this.googleMap = googleMap;
    }

    void addGroundOverlays(@NonNull List<Messages.PlatformGroundOverlay> groundOverlaysToAdd) {
        for (Messages.PlatformGroundOverlay groundOverlayToAdd : groundOverlaysToAdd) {
            this.addGroundOverlay(groundOverlayToAdd);
        }
    }

    void changeGroundOverlays(@NonNull List<Messages.PlatformGroundOverlay> groundOverlaysToChange) {
        for (Messages.PlatformGroundOverlay groundOverlayToChange : groundOverlaysToChange) {
            this.changeGroundOverlay(groundOverlayToChange);
        }
    }

    void removeGroundOverlays(@NonNull List<String> groundOverlayIdsToRemove) {
        for (String groundOverlayId : groundOverlayIdsToRemove) {
            this.removeGroundOverlay(groundOverlayId);
        }
    }

    @Nullable
    GroundOverlay getGroundOverlay(@NonNull String groundOverlayId) {
        GroundOverlayController groundOverlayController = this.groundOverlayIdToController.get(groundOverlayId);
        if (groundOverlayController == null) {
            return null;
        }
        return groundOverlayController.getGroundOverlay();
    }

    private void addGroundOverlay(@NonNull Messages.PlatformGroundOverlay platformGroundOverlay) {
        GroundOverlayBuilder groundOverlayOptionsBuilder = new GroundOverlayBuilder();
        String groundOverlayId = Convert.interpretGroundOverlayOptions(platformGroundOverlay, groundOverlayOptionsBuilder, this.assetManager, this.density, this.bitmapDescriptorFactoryWrapper);
        GroundOverlayOptions options = groundOverlayOptionsBuilder.build();
        GroundOverlay groundOverlay = this.googleMap.addGroundOverlay(options);
        if (groundOverlay != null) {
            GroundOverlayController groundOverlayController = new GroundOverlayController(groundOverlay, platformGroundOverlay.getBounds() != null);
            this.groundOverlayIdToController.put(groundOverlayId, groundOverlayController);
            this.googleMapsGroundOverlayIdToDartGroundOverlayId.put(groundOverlay.getId(), groundOverlayId);
        }
    }

    private void changeGroundOverlay(@NonNull Messages.PlatformGroundOverlay platformGroundOverlay) {
        String groundOverlayId = platformGroundOverlay.getGroundOverlayId();
        GroundOverlayController groundOverlayController = this.groundOverlayIdToController.get(groundOverlayId);
        if (groundOverlayController != null) {
            Convert.interpretGroundOverlayOptions(platformGroundOverlay, groundOverlayController, this.assetManager, this.density, this.bitmapDescriptorFactoryWrapper);
        }
    }

    private void removeGroundOverlay(@NonNull String groundOverlayId) {
        GroundOverlayController groundOverlayController = this.groundOverlayIdToController.get(groundOverlayId);
        if (groundOverlayController != null) {
            groundOverlayController.remove();
            this.groundOverlayIdToController.remove(groundOverlayId);
            this.googleMapsGroundOverlayIdToDartGroundOverlayId.remove(groundOverlayController.getGoogleMapsGroundOverlayId());
        }
    }

    void onGroundOverlayTap(@NonNull String googleGroundOverlayId) {
        String groundOverlayId = this.googleMapsGroundOverlayIdToDartGroundOverlayId.get(googleGroundOverlayId);
        if (groundOverlayId == null) {
            return;
        }
        this.flutterApi.onGroundOverlayTap(groundOverlayId, new NoOpVoidResult());
    }

    boolean isCreatedWithBounds(@NonNull String groundOverlayId) {
        GroundOverlayController groundOverlayController = this.groundOverlayIdToController.get(groundOverlayId);
        if (groundOverlayController == null) {
            return false;
        }
        return groundOverlayController.isCreatedWithBounds();
    }
}

