/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlemaps;

import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.Polyline;
import io.flutter.plugins.googlemaps.PolylineOptionsSink;
import java.util.List;

class PolylineController
implements PolylineOptionsSink {
    private final Polyline polyline;
    private final String googleMapsPolylineId;
    private boolean consumeTapEvents;
    private final float density;

    PolylineController(Polyline polyline, boolean consumeTapEvents, float density) {
        this.polyline = polyline;
        this.consumeTapEvents = consumeTapEvents;
        this.density = density;
        this.googleMapsPolylineId = polyline.getId();
    }

    void remove() {
        this.polyline.remove();
    }

    @Override
    public void setConsumeTapEvents(boolean consumeTapEvents) {
        this.consumeTapEvents = consumeTapEvents;
        this.polyline.setClickable(consumeTapEvents);
    }

    @Override
    public void setColor(int color) {
        this.polyline.setColor(color);
    }

    @Override
    public void setEndCap(Cap endCap) {
        this.polyline.setEndCap(endCap);
    }

    @Override
    public void setGeodesic(boolean geodesic) {
        this.polyline.setGeodesic(geodesic);
    }

    @Override
    public void setJointType(int jointType) {
        this.polyline.setJointType(jointType);
    }

    @Override
    public void setPattern(List<PatternItem> pattern) {
        this.polyline.setPattern(pattern);
    }

    @Override
    public void setPoints(List<LatLng> points) {
        this.polyline.setPoints(points);
    }

    @Override
    public void setStartCap(Cap startCap) {
        this.polyline.setStartCap(startCap);
    }

    @Override
    public void setVisible(boolean visible) {
        this.polyline.setVisible(visible);
    }

    @Override
    public void setWidth(float width) {
        this.polyline.setWidth(width * this.density);
    }

    @Override
    public void setZIndex(float zIndex) {
        this.polyline.setZIndex(zIndex);
    }

    String getGoogleMapsPolylineId() {
        return this.googleMapsPolylineId;
    }

    boolean consumeTapEvents() {
        return this.consumeTapEvents;
    }
}

