/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.imagepicker;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.SizeFCompat;
import androidx.exifinterface.media.ExifInterface;
import io.flutter.plugins.imagepicker.ExifDataCopier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ImageResizer {
    private final Context context;
    private final ExifDataCopier exifDataCopier;

    ImageResizer(@NonNull Context context, @NonNull ExifDataCopier exifDataCopier) {
        this.context = context;
        this.exifDataCopier = exifDataCopier;
    }

    String resizeImageIfNeeded(String imagePath, @Nullable Double maxWidth, @Nullable Double maxHeight, int imageQuality) {
        boolean shouldScale;
        SizeFCompat originalSize = this.readFileDimensions(imagePath);
        if (originalSize.getWidth() == -1.0f || originalSize.getHeight() == -1.0f) {
            return imagePath;
        }
        boolean bl = shouldScale = maxWidth != null || maxHeight != null || imageQuality < 100;
        if (!shouldScale) {
            return imagePath;
        }
        try {
            String[] pathParts = imagePath.split("/");
            String imageName = pathParts[pathParts.length - 1];
            SizeFCompat targetSize = this.calculateTargetSize(originalSize.getWidth(), originalSize.getHeight(), maxWidth, maxHeight);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = this.calculateSampleSize(options, (int)targetSize.getWidth(), (int)targetSize.getHeight());
            Bitmap bmp = this.decodeFile(imagePath, options);
            if (bmp == null) {
                return imagePath;
            }
            File file = this.resizedImage(bmp, Double.valueOf(targetSize.getWidth()), Double.valueOf(targetSize.getHeight()), imageQuality, imageName);
            this.copyExif(imagePath, file.getPath());
            return file.getPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File resizedImage(Bitmap bmp, Double width, Double height, int imageQuality, String outputImageName) throws IOException {
        Bitmap scaledBmp = this.createScaledBitmap(bmp, width.intValue(), height.intValue(), false);
        File file = this.createImageOnExternalDirectory("/scaled_" + outputImageName, scaledBmp, imageQuality);
        return file;
    }

    private SizeFCompat calculateTargetSize(double originalWidth, double originalHeight, @Nullable Double maxWidth, @Nullable Double maxHeight) {
        boolean shouldDownscale;
        double aspectRatio = originalWidth / originalHeight;
        boolean hasMaxWidth = maxWidth != null;
        boolean hasMaxHeight = maxHeight != null;
        double width = hasMaxWidth ? Math.min(originalWidth, (double)Math.round(maxWidth)) : originalWidth;
        double height = hasMaxHeight ? Math.min(originalHeight, (double)Math.round(maxHeight)) : originalHeight;
        boolean shouldDownscaleWidth = hasMaxWidth && maxWidth < originalWidth;
        boolean shouldDownscaleHeight = hasMaxHeight && maxHeight < originalHeight;
        boolean bl = shouldDownscale = shouldDownscaleWidth || shouldDownscaleHeight;
        if (shouldDownscale) {
            double WidthForMaxHeight = height * aspectRatio;
            double heightForMaxWidth = width / aspectRatio;
            if (heightForMaxWidth > height) {
                width = Math.round(WidthForMaxHeight);
            } else {
                height = Math.round(heightForMaxWidth);
            }
        }
        return new SizeFCompat((float)width, (float)height);
    }

    private File createFile(File externalFilesDirectory, String child) {
        File image = new File(externalFilesDirectory, child);
        if (!image.getParentFile().exists()) {
            image.getParentFile().mkdirs();
        }
        return image;
    }

    private FileOutputStream createOutputStream(File imageFile) throws IOException {
        return new FileOutputStream(imageFile);
    }

    private void copyExif(String filePathOri, String filePathDest) {
        try {
            this.exifDataCopier.copyExif(new ExifInterface(filePathOri), new ExifInterface(filePathDest));
        }
        catch (Exception ex) {
            Log.e((String)"ImageResizer", (String)("Error preserving Exif data on selected image: " + ex));
        }
    }

    @VisibleForTesting
    SizeFCompat readFileDimensions(String path) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        this.decodeFile(path, options);
        return new SizeFCompat((float)options.outWidth, (float)options.outHeight);
    }

    private Bitmap decodeFile(String path, @Nullable BitmapFactory.Options opts) {
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts);
    }

    private Bitmap createScaledBitmap(Bitmap bmp, int width, int height, boolean filter) {
        return Bitmap.createScaledBitmap((Bitmap)bmp, (int)width, (int)height, (boolean)filter);
    }

    private int calculateSampleSize(BitmapFactory.Options options, int targetWidth, int targetHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int sampleSize = 1;
        if (height > targetHeight || width > targetWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / sampleSize >= targetHeight && halfWidth / sampleSize >= targetWidth) {
                sampleSize *= 2;
            }
        }
        return sampleSize;
    }

    private File createImageOnExternalDirectory(String name, Bitmap bitmap, int imageQuality) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean saveAsPNG = bitmap.hasAlpha();
        if (saveAsPNG) {
            Log.d((String)"ImageResizer", (String)"image_picker: compressing is not supported for type PNG. Returning the image with original quality");
        }
        bitmap.compress(saveAsPNG ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG, imageQuality, (OutputStream)outputStream);
        File cacheDirectory = this.context.getCacheDir();
        File imageFile = this.createFile(cacheDirectory, name);
        FileOutputStream fileOutput = this.createOutputStream(imageFile);
        fileOutput.write(outputStream.toByteArray());
        fileOutput.close();
        return imageFile;
    }
}

