/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.imagepicker;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

class FileUtils {
    FileUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String getPathFromUri(Context context, Uri uri) {
        try (InputStream inputStream = context.getContentResolver().openInputStream(uri);){
            String string;
            String uuid = UUID.randomUUID().toString();
            File targetDirectory = new File(context.getCacheDir(), uuid);
            targetDirectory.mkdir();
            targetDirectory.deleteOnExit();
            String fileName = FileUtils.getImageName(context, uri);
            String extension = FileUtils.getImageExtension(context, uri);
            if (fileName == null) {
                Log.w((String)"FileUtils", (String)("Cannot get file name for " + uri));
                if (extension == null) {
                    extension = ".jpg";
                }
                fileName = "image_picker" + extension;
            } else if (extension != null) {
                fileName = FileUtils.getBaseName(fileName) + extension;
            }
            String filePath = new File(targetDirectory, fileName).getPath();
            File outputFile = FileUtils.saferOpenFile(filePath, targetDirectory.getCanonicalPath());
            try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                FileUtils.copy(inputStream, outputStream);
                string = outputFile.getPath();
            }
            return string;
        }
        catch (IOException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static String getImageExtension(Context context, Uri uriImage) {
        String extension;
        try {
            if (uriImage.getScheme().equals("content")) {
                MimeTypeMap mime = MimeTypeMap.getSingleton();
                extension = mime.getExtensionFromMimeType(context.getContentResolver().getType(uriImage));
            } else {
                extension = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uriImage.getPath())).toString());
            }
        }
        catch (Exception e) {
            return null;
        }
        if (extension == null || extension.isEmpty()) {
            return null;
        }
        return "." + FileUtils.sanitizeFilename(extension);
    }

    @Nullable
    protected static String sanitizeFilename(@Nullable String displayName) {
        if (displayName == null) {
            return null;
        }
        String[] badCharacters = new String[]{"..", "/"};
        String[] segments = displayName.split("/");
        String fileName = segments[segments.length - 1];
        for (String suspString : badCharacters) {
            fileName = fileName.replace(suspString, "_");
        }
        return fileName;
    }

    @NonNull
    protected static File saferOpenFile(@NonNull String path, @NonNull String expectedDir) throws IllegalArgumentException, IOException {
        File f = new File(path);
        String canonicalPath = f.getCanonicalPath();
        if (!canonicalPath.startsWith(expectedDir)) {
            throw new IllegalArgumentException("Trying to open path outside of the expected directory. File: " + f.getCanonicalPath() + " was expected to be within directory: " + expectedDir + ".");
        }
        return f;
    }

    private static String getImageName(Context context, Uri uriImage) {
        try (Cursor cursor = FileUtils.queryImageName(context, uriImage);){
            if (cursor == null || !cursor.moveToFirst() || cursor.getColumnCount() < 1) {
                String string = null;
                return string;
            }
            String unsanitizedImageName = cursor.getString(0);
            String string = FileUtils.sanitizeFilename(unsanitizedImageName);
            return string;
        }
    }

    private static Cursor queryImageName(Context context, Uri uriImage) {
        return context.getContentResolver().query(uriImage, new String[]{"_display_name"}, null, null, null);
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
    }

    private static String getBaseName(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return fileName;
        }
        return fileName.substring(0, lastDotIndex);
    }
}

