/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.imagepicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.MediaStore;
import androidx.activity.result.contract.ActivityResultContracts;
import io.flutter.plugins.imagepicker.Messages;
import java.util.Arrays;

final class ImagePickerUtils {
    ImagePickerUtils() {
    }

    private static boolean isPermissionPresentInManifest(Context context, String permissionName) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = Build.VERSION.SDK_INT >= 33 ? packageManager.getPackageInfo(context.getPackageName(), PackageManager.PackageInfoFlags.of((long)4096L)) : ImagePickerUtils.getPermissionsPackageInfoPreApi33(packageManager, context.getPackageName());
            String[] requestedPermissions = packageInfo.requestedPermissions;
            return Arrays.asList(requestedPermissions).contains(permissionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static PackageInfo getPermissionsPackageInfoPreApi33(PackageManager packageManager, String packageName) throws PackageManager.NameNotFoundException {
        return packageManager.getPackageInfo(packageName, 4096);
    }

    static boolean needRequestCameraPermission(Context context) {
        boolean greatOrEqualM = Build.VERSION.SDK_INT >= 23;
        return greatOrEqualM && ImagePickerUtils.isPermissionPresentInManifest(context, "android.permission.CAMERA");
    }

    @SuppressLint(value={"NewApi", "ClassVerificationFailure"})
    static int getMaxItems() {
        if (ActivityResultContracts.PickVisualMedia.isSystemPickerAvailable$activity_release()) {
            return MediaStore.getPickImagesMaxLimit();
        }
        return Integer.MAX_VALUE;
    }

    static int getLimitFromOption(Messages.GeneralOptions generalOptions) {
        Long limit = generalOptions.getLimit();
        int effectiveLimit = ImagePickerUtils.getMaxItems();
        if (limit != null && limit < (long)effectiveLimit) {
            effectiveLimit = Math.toIntExact(limit);
        }
        return effectiveLimit;
    }
}

