/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.imagepicker;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Messages {
    @NonNull
    protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
        ArrayList<Object> errorList = new ArrayList<Object>(3);
        if (exception instanceof FlutterError) {
            FlutterError error = (FlutterError)exception;
            errorList.add(error.code);
            errorList.add(error.getMessage());
            errorList.add(error.details);
        } else {
            errorList.add(exception.toString());
            errorList.add(exception.getClass().getSimpleName());
            errorList.add("Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString((Throwable)exception));
        }
        return errorList;
    }

    public static class FlutterError
    extends RuntimeException {
        public final String code;
        public final Object details;

        public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
            super(message);
            this.code = code;
            this.details = details;
        }
    }

    public static interface ImagePickerApi {
        public void pickImages(@NonNull SourceSpecification var1, @NonNull ImageSelectionOptions var2, @NonNull GeneralOptions var3, @NonNull Result<List<String>> var4);

        public void pickVideos(@NonNull SourceSpecification var1, @NonNull VideoSelectionOptions var2, @NonNull GeneralOptions var3, @NonNull Result<List<String>> var4);

        public void pickMedia(@NonNull MediaSelectionOptions var1, @NonNull GeneralOptions var2, @NonNull Result<List<String>> var3);

        @Nullable
        public CacheRetrievalResult retrieveLostResults();

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable ImagePickerApi api) {
            ImagePickerApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable ImagePickerApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BinaryMessenger.TaskQueue taskQueue = binaryMessenger.makeBackgroundTaskQueue();
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.image_picker_android.ImagePickerApi.pickImages" + messageChannelSuffix, ImagePickerApi.getCodec(), taskQueue);
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    SourceSpecification sourceArg = (SourceSpecification)args.get(0);
                    ImageSelectionOptions optionsArg = (ImageSelectionOptions)args.get(1);
                    GeneralOptions generalOptionsArg = (GeneralOptions)args.get(2);
                    Result<List<String>> resultCallback = new Result<List<String>>(){

                        @Override
                        public void success(List<String> result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.pickImages(sourceArg, optionsArg, generalOptionsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.image_picker_android.ImagePickerApi.pickVideos" + messageChannelSuffix, ImagePickerApi.getCodec(), taskQueue);
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    SourceSpecification sourceArg = (SourceSpecification)args.get(0);
                    VideoSelectionOptions optionsArg = (VideoSelectionOptions)args.get(1);
                    GeneralOptions generalOptionsArg = (GeneralOptions)args.get(2);
                    Result<List<String>> resultCallback = new Result<List<String>>(){

                        @Override
                        public void success(List<String> result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.pickVideos(sourceArg, optionsArg, generalOptionsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.image_picker_android.ImagePickerApi.pickMedia" + messageChannelSuffix, ImagePickerApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    MediaSelectionOptions mediaSelectionOptionsArg = (MediaSelectionOptions)args.get(0);
                    GeneralOptions generalOptionsArg = (GeneralOptions)args.get(1);
                    Result<List<String>> resultCallback = new Result<List<String>>(){

                        @Override
                        public void success(List<String> result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.pickMedia(mediaSelectionOptionsArg, generalOptionsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.image_picker_android.ImagePickerApi.retrieveLostResults" + messageChannelSuffix, ImagePickerApi.getCodec(), taskQueue);
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<CacheRetrievalResult>();
                    try {
                        CacheRetrievalResult output = api.retrieveLostResults();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    public static interface VoidResult {
        public void success();

        public void error(@NonNull Throwable var1);
    }

    public static interface NullableResult<T> {
        public void success(@Nullable T var1);

        public void error(@NonNull Throwable var1);
    }

    public static interface Result<T> {
        public void success(@NonNull T var1);

        public void error(@NonNull Throwable var1);
    }

    private static class PigeonCodec
    extends StandardMessageCodec {
        public static final PigeonCodec INSTANCE = new PigeonCodec();

        private PigeonCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -127: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : SourceCamera.values()[((Long)value).intValue()];
                }
                case -126: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : SourceType.values()[((Long)value).intValue()];
                }
                case -125: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : CacheRetrievalType.values()[((Long)value).intValue()];
                }
                case -124: {
                    return GeneralOptions.fromList((ArrayList)this.readValue(buffer));
                }
                case -123: {
                    return ImageSelectionOptions.fromList((ArrayList)this.readValue(buffer));
                }
                case -122: {
                    return MediaSelectionOptions.fromList((ArrayList)this.readValue(buffer));
                }
                case -121: {
                    return VideoSelectionOptions.fromList((ArrayList)this.readValue(buffer));
                }
                case -120: {
                    return SourceSpecification.fromList((ArrayList)this.readValue(buffer));
                }
                case -119: {
                    return CacheRetrievalError.fromList((ArrayList)this.readValue(buffer));
                }
                case -118: {
                    return CacheRetrievalResult.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof SourceCamera) {
                stream.write(129);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((SourceCamera)((Object)value)).index));
            } else if (value instanceof SourceType) {
                stream.write(130);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((SourceType)((Object)value)).index));
            } else if (value instanceof CacheRetrievalType) {
                stream.write(131);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((CacheRetrievalType)((Object)value)).index));
            } else if (value instanceof GeneralOptions) {
                stream.write(132);
                this.writeValue(stream, ((GeneralOptions)value).toList());
            } else if (value instanceof ImageSelectionOptions) {
                stream.write(133);
                this.writeValue(stream, ((ImageSelectionOptions)value).toList());
            } else if (value instanceof MediaSelectionOptions) {
                stream.write(134);
                this.writeValue(stream, ((MediaSelectionOptions)value).toList());
            } else if (value instanceof VideoSelectionOptions) {
                stream.write(135);
                this.writeValue(stream, ((VideoSelectionOptions)value).toList());
            } else if (value instanceof SourceSpecification) {
                stream.write(136);
                this.writeValue(stream, ((SourceSpecification)value).toList());
            } else if (value instanceof CacheRetrievalError) {
                stream.write(137);
                this.writeValue(stream, ((CacheRetrievalError)value).toList());
            } else if (value instanceof CacheRetrievalResult) {
                stream.write(138);
                this.writeValue(stream, ((CacheRetrievalResult)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static final class CacheRetrievalResult {
        @NonNull
        private CacheRetrievalType type;
        @Nullable
        private CacheRetrievalError error;
        @NonNull
        private List<String> paths;

        @NonNull
        public CacheRetrievalType getType() {
            return this.type;
        }

        public void setType(@NonNull CacheRetrievalType setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"type\" is null.");
            }
            this.type = setterArg;
        }

        @Nullable
        public CacheRetrievalError getError() {
            return this.error;
        }

        public void setError(@Nullable CacheRetrievalError setterArg) {
            this.error = setterArg;
        }

        @NonNull
        public List<String> getPaths() {
            return this.paths;
        }

        public void setPaths(@NonNull List<String> setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"paths\" is null.");
            }
            this.paths = setterArg;
        }

        CacheRetrievalResult() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheRetrievalResult that = (CacheRetrievalResult)o;
            return this.type.equals((Object)that.type) && Objects.equals(this.error, that.error) && this.paths.equals(that.paths);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.error, this.paths});
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add((Object)this.type);
            toListResult.add(this.error);
            toListResult.add(this.paths);
            return toListResult;
        }

        @NonNull
        static CacheRetrievalResult fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            CacheRetrievalResult pigeonResult = new CacheRetrievalResult();
            Object type = pigeonVar_list.get(0);
            pigeonResult.setType((CacheRetrievalType)((Object)type));
            Object error = pigeonVar_list.get(1);
            pigeonResult.setError((CacheRetrievalError)error);
            Object paths = pigeonVar_list.get(2);
            pigeonResult.setPaths((List)paths);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private CacheRetrievalType type;
            @Nullable
            private CacheRetrievalError error;
            @Nullable
            private List<String> paths;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setType(@NonNull CacheRetrievalType setterArg) {
                this.type = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setError(@Nullable CacheRetrievalError setterArg) {
                this.error = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPaths(@NonNull List<String> setterArg) {
                this.paths = setterArg;
                return this;
            }

            @NonNull
            public CacheRetrievalResult build() {
                CacheRetrievalResult pigeonReturn = new CacheRetrievalResult();
                pigeonReturn.setType(this.type);
                pigeonReturn.setError(this.error);
                pigeonReturn.setPaths(this.paths);
                return pigeonReturn;
            }
        }
    }

    public static final class CacheRetrievalError {
        @NonNull
        private String code;
        @Nullable
        private String message;

        @NonNull
        public String getCode() {
            return this.code;
        }

        public void setCode(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"code\" is null.");
            }
            this.code = setterArg;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }

        public void setMessage(@Nullable String setterArg) {
            this.message = setterArg;
        }

        CacheRetrievalError() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheRetrievalError that = (CacheRetrievalError)o;
            return this.code.equals(that.code) && Objects.equals(this.message, that.message);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.message);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.code);
            toListResult.add(this.message);
            return toListResult;
        }

        @NonNull
        static CacheRetrievalError fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            CacheRetrievalError pigeonResult = new CacheRetrievalError();
            Object code = pigeonVar_list.get(0);
            pigeonResult.setCode((String)code);
            Object message = pigeonVar_list.get(1);
            pigeonResult.setMessage((String)message);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String code;
            @Nullable
            private String message;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCode(@NonNull String setterArg) {
                this.code = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMessage(@Nullable String setterArg) {
                this.message = setterArg;
                return this;
            }

            @NonNull
            public CacheRetrievalError build() {
                CacheRetrievalError pigeonReturn = new CacheRetrievalError();
                pigeonReturn.setCode(this.code);
                pigeonReturn.setMessage(this.message);
                return pigeonReturn;
            }
        }
    }

    public static final class SourceSpecification {
        @NonNull
        private SourceType type;
        @Nullable
        private SourceCamera camera;

        @NonNull
        public SourceType getType() {
            return this.type;
        }

        public void setType(@NonNull SourceType setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"type\" is null.");
            }
            this.type = setterArg;
        }

        @Nullable
        public SourceCamera getCamera() {
            return this.camera;
        }

        public void setCamera(@Nullable SourceCamera setterArg) {
            this.camera = setterArg;
        }

        SourceSpecification() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceSpecification that = (SourceSpecification)o;
            return this.type.equals((Object)that.type) && Objects.equals((Object)this.camera, (Object)that.camera);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.camera});
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add((Object)this.type);
            toListResult.add((Object)this.camera);
            return toListResult;
        }

        @NonNull
        static SourceSpecification fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            SourceSpecification pigeonResult = new SourceSpecification();
            Object type = pigeonVar_list.get(0);
            pigeonResult.setType((SourceType)((Object)type));
            Object camera = pigeonVar_list.get(1);
            pigeonResult.setCamera((SourceCamera)((Object)camera));
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private SourceType type;
            @Nullable
            private SourceCamera camera;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setType(@NonNull SourceType setterArg) {
                this.type = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCamera(@Nullable SourceCamera setterArg) {
                this.camera = setterArg;
                return this;
            }

            @NonNull
            public SourceSpecification build() {
                SourceSpecification pigeonReturn = new SourceSpecification();
                pigeonReturn.setType(this.type);
                pigeonReturn.setCamera(this.camera);
                return pigeonReturn;
            }
        }
    }

    public static final class VideoSelectionOptions {
        @Nullable
        private Long maxDurationSeconds;

        @Nullable
        public Long getMaxDurationSeconds() {
            return this.maxDurationSeconds;
        }

        public void setMaxDurationSeconds(@Nullable Long setterArg) {
            this.maxDurationSeconds = setterArg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VideoSelectionOptions that = (VideoSelectionOptions)o;
            return Objects.equals(this.maxDurationSeconds, that.maxDurationSeconds);
        }

        public int hashCode() {
            return Objects.hash(this.maxDurationSeconds);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.maxDurationSeconds);
            return toListResult;
        }

        @NonNull
        static VideoSelectionOptions fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            VideoSelectionOptions pigeonResult = new VideoSelectionOptions();
            Object maxDurationSeconds = pigeonVar_list.get(0);
            pigeonResult.setMaxDurationSeconds((Long)maxDurationSeconds);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Long maxDurationSeconds;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMaxDurationSeconds(@Nullable Long setterArg) {
                this.maxDurationSeconds = setterArg;
                return this;
            }

            @NonNull
            public VideoSelectionOptions build() {
                VideoSelectionOptions pigeonReturn = new VideoSelectionOptions();
                pigeonReturn.setMaxDurationSeconds(this.maxDurationSeconds);
                return pigeonReturn;
            }
        }
    }

    public static final class MediaSelectionOptions {
        @NonNull
        private ImageSelectionOptions imageSelectionOptions;

        @NonNull
        public ImageSelectionOptions getImageSelectionOptions() {
            return this.imageSelectionOptions;
        }

        public void setImageSelectionOptions(@NonNull ImageSelectionOptions setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"imageSelectionOptions\" is null.");
            }
            this.imageSelectionOptions = setterArg;
        }

        MediaSelectionOptions() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MediaSelectionOptions that = (MediaSelectionOptions)o;
            return this.imageSelectionOptions.equals(that.imageSelectionOptions);
        }

        public int hashCode() {
            return Objects.hash(this.imageSelectionOptions);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(1);
            toListResult.add(this.imageSelectionOptions);
            return toListResult;
        }

        @NonNull
        static MediaSelectionOptions fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            MediaSelectionOptions pigeonResult = new MediaSelectionOptions();
            Object imageSelectionOptions = pigeonVar_list.get(0);
            pigeonResult.setImageSelectionOptions((ImageSelectionOptions)imageSelectionOptions);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private ImageSelectionOptions imageSelectionOptions;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setImageSelectionOptions(@NonNull ImageSelectionOptions setterArg) {
                this.imageSelectionOptions = setterArg;
                return this;
            }

            @NonNull
            public MediaSelectionOptions build() {
                MediaSelectionOptions pigeonReturn = new MediaSelectionOptions();
                pigeonReturn.setImageSelectionOptions(this.imageSelectionOptions);
                return pigeonReturn;
            }
        }
    }

    public static final class ImageSelectionOptions {
        @Nullable
        private Double maxWidth;
        @Nullable
        private Double maxHeight;
        @NonNull
        private Long quality;

        @Nullable
        public Double getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxWidth(@Nullable Double setterArg) {
            this.maxWidth = setterArg;
        }

        @Nullable
        public Double getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxHeight(@Nullable Double setterArg) {
            this.maxHeight = setterArg;
        }

        @NonNull
        public Long getQuality() {
            return this.quality;
        }

        public void setQuality(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"quality\" is null.");
            }
            this.quality = setterArg;
        }

        ImageSelectionOptions() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageSelectionOptions that = (ImageSelectionOptions)o;
            return Objects.equals(this.maxWidth, that.maxWidth) && Objects.equals(this.maxHeight, that.maxHeight) && this.quality.equals(that.quality);
        }

        public int hashCode() {
            return Objects.hash(this.maxWidth, this.maxHeight, this.quality);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.maxWidth);
            toListResult.add(this.maxHeight);
            toListResult.add(this.quality);
            return toListResult;
        }

        @NonNull
        static ImageSelectionOptions fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            ImageSelectionOptions pigeonResult = new ImageSelectionOptions();
            Object maxWidth = pigeonVar_list.get(0);
            pigeonResult.setMaxWidth((Double)maxWidth);
            Object maxHeight = pigeonVar_list.get(1);
            pigeonResult.setMaxHeight((Double)maxHeight);
            Object quality = pigeonVar_list.get(2);
            pigeonResult.setQuality((Long)quality);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double maxWidth;
            @Nullable
            private Double maxHeight;
            @Nullable
            private Long quality;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMaxWidth(@Nullable Double setterArg) {
                this.maxWidth = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setMaxHeight(@Nullable Double setterArg) {
                this.maxHeight = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setQuality(@NonNull Long setterArg) {
                this.quality = setterArg;
                return this;
            }

            @NonNull
            public ImageSelectionOptions build() {
                ImageSelectionOptions pigeonReturn = new ImageSelectionOptions();
                pigeonReturn.setMaxWidth(this.maxWidth);
                pigeonReturn.setMaxHeight(this.maxHeight);
                pigeonReturn.setQuality(this.quality);
                return pigeonReturn;
            }
        }
    }

    public static final class GeneralOptions {
        @NonNull
        private Boolean allowMultiple;
        @NonNull
        private Boolean usePhotoPicker;
        @Nullable
        private Long limit;

        @NonNull
        public Boolean getAllowMultiple() {
            return this.allowMultiple;
        }

        public void setAllowMultiple(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"allowMultiple\" is null.");
            }
            this.allowMultiple = setterArg;
        }

        @NonNull
        public Boolean getUsePhotoPicker() {
            return this.usePhotoPicker;
        }

        public void setUsePhotoPicker(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"usePhotoPicker\" is null.");
            }
            this.usePhotoPicker = setterArg;
        }

        @Nullable
        public Long getLimit() {
            return this.limit;
        }

        public void setLimit(@Nullable Long setterArg) {
            this.limit = setterArg;
        }

        GeneralOptions() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GeneralOptions that = (GeneralOptions)o;
            return this.allowMultiple.equals(that.allowMultiple) && this.usePhotoPicker.equals(that.usePhotoPicker) && Objects.equals(this.limit, that.limit);
        }

        public int hashCode() {
            return Objects.hash(this.allowMultiple, this.usePhotoPicker, this.limit);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.allowMultiple);
            toListResult.add(this.usePhotoPicker);
            toListResult.add(this.limit);
            return toListResult;
        }

        @NonNull
        static GeneralOptions fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            GeneralOptions pigeonResult = new GeneralOptions();
            Object allowMultiple = pigeonVar_list.get(0);
            pigeonResult.setAllowMultiple((Boolean)allowMultiple);
            Object usePhotoPicker = pigeonVar_list.get(1);
            pigeonResult.setUsePhotoPicker((Boolean)usePhotoPicker);
            Object limit = pigeonVar_list.get(2);
            pigeonResult.setLimit((Long)limit);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Boolean allowMultiple;
            @Nullable
            private Boolean usePhotoPicker;
            @Nullable
            private Long limit;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAllowMultiple(@NonNull Boolean setterArg) {
                this.allowMultiple = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setUsePhotoPicker(@NonNull Boolean setterArg) {
                this.usePhotoPicker = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setLimit(@Nullable Long setterArg) {
                this.limit = setterArg;
                return this;
            }

            @NonNull
            public GeneralOptions build() {
                GeneralOptions pigeonReturn = new GeneralOptions();
                pigeonReturn.setAllowMultiple(this.allowMultiple);
                pigeonReturn.setUsePhotoPicker(this.usePhotoPicker);
                pigeonReturn.setLimit(this.limit);
                return pigeonReturn;
            }
        }
    }

    public static enum CacheRetrievalType {
        IMAGE(0),
        VIDEO(1);

        final int index;

        private CacheRetrievalType(int index) {
            this.index = index;
        }
    }

    public static enum SourceType {
        CAMERA(0),
        GALLERY(1);

        final int index;

        private SourceType(int index) {
            this.index = index;
        }
    }

    public static enum SourceCamera {
        REAR(0),
        FRONT(1);

        final int index;

        private SourceCamera(int index) {
            this.index = index;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    static @interface CanIgnoreReturnValue {
    }
}

