/*
 * Decompiled with CFR 0.152.
 */
package com.ryanheise.just_audio;

import android.content.Context;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.Equalizer;
import android.media.audiofx.LoudnessEnhancer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Metadata;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Player;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.Tracks;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultDataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.exoplayer.DefaultLivePlaybackSpeedControl;
import androidx.media3.exoplayer.DefaultLoadControl;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.LivePlaybackSpeedControl;
import androidx.media3.exoplayer.LoadControl;
import androidx.media3.exoplayer.dash.DashMediaSource;
import androidx.media3.exoplayer.hls.HlsMediaSource;
import androidx.media3.exoplayer.metadata.MetadataOutput;
import androidx.media3.exoplayer.source.ClippingMediaSource;
import androidx.media3.exoplayer.source.ConcatenatingMediaSource;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.ProgressiveMediaSource;
import androidx.media3.exoplayer.source.ShuffleOrder;
import androidx.media3.exoplayer.source.SilenceMediaSource;
import androidx.media3.extractor.DefaultExtractorsFactory;
import androidx.media3.extractor.ExtractorsFactory;
import androidx.media3.extractor.metadata.icy.IcyHeaders;
import androidx.media3.extractor.metadata.icy.IcyInfo;
import com.ryanheise.just_audio.BetterEventChannel;
import io.flutter.Log;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class AudioPlayer
implements MethodChannel.MethodCallHandler,
Player.Listener,
MetadataOutput {
    static final String TAG = "AudioPlayer";
    private static Random random = new Random();
    private final Context context;
    private final MethodChannel methodChannel;
    private final BetterEventChannel eventChannel;
    private final BetterEventChannel dataEventChannel;
    private ProcessingState processingState;
    private long updatePosition;
    private long updateTime;
    private long bufferedPosition;
    private Long seekPos;
    private long initialPos;
    private Integer initialIndex;
    private MethodChannel.Result prepareResult;
    private MethodChannel.Result playResult;
    private MethodChannel.Result seekResult;
    private Map<String, MediaSource> mediaSources = new HashMap<String, MediaSource>();
    private IcyInfo icyInfo;
    private IcyHeaders icyHeaders;
    private int errorCount;
    private AudioAttributes pendingAudioAttributes;
    private LoadControl loadControl;
    private boolean offloadSchedulingEnabled;
    private LivePlaybackSpeedControl livePlaybackSpeedControl;
    private List<Object> rawAudioEffects;
    private List<AudioEffect> audioEffects = new ArrayList<AudioEffect>();
    private Map<String, AudioEffect> audioEffectsMap = new HashMap<String, AudioEffect>();
    private int lastPlaylistLength = 0;
    private Map<String, Object> pendingPlaybackEvent;
    private ExoPlayer player;
    private Integer audioSessionId;
    private MediaSource mediaSource;
    private Integer currentIndex;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Runnable bufferWatcher = new Runnable(){

        @Override
        public void run() {
            if (AudioPlayer.this.player == null) {
                return;
            }
            long newBufferedPosition = AudioPlayer.this.player.getBufferedPosition();
            if (newBufferedPosition != AudioPlayer.this.bufferedPosition) {
                AudioPlayer.this.broadcastImmediatePlaybackEvent();
            }
            switch (AudioPlayer.this.player.getPlaybackState()) {
                case 2: {
                    AudioPlayer.this.handler.postDelayed((Runnable)this, 200L);
                    break;
                }
                case 3: {
                    if (AudioPlayer.this.player.getPlayWhenReady()) {
                        AudioPlayer.this.handler.postDelayed((Runnable)this, 500L);
                        break;
                    }
                    AudioPlayer.this.handler.postDelayed((Runnable)this, 1000L);
                    break;
                }
            }
        }
    };

    public AudioPlayer(Context applicationContext, BinaryMessenger messenger, String id, Map<?, ?> audioLoadConfiguration, List<Object> rawAudioEffects, Boolean offloadSchedulingEnabled) {
        this.context = applicationContext;
        this.rawAudioEffects = rawAudioEffects;
        this.offloadSchedulingEnabled = offloadSchedulingEnabled != null ? offloadSchedulingEnabled : false;
        this.methodChannel = new MethodChannel(messenger, "com.ryanheise.just_audio.methods." + id);
        this.methodChannel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        this.eventChannel = new BetterEventChannel(messenger, "com.ryanheise.just_audio.events." + id);
        this.dataEventChannel = new BetterEventChannel(messenger, "com.ryanheise.just_audio.data." + id);
        this.processingState = ProcessingState.none;
        if (audioLoadConfiguration != null) {
            Map livePlaybackSpeedControlMap;
            Map loadControlMap = (Map)audioLoadConfiguration.get("androidLoadControl");
            if (loadControlMap != null) {
                DefaultLoadControl.Builder builder = new DefaultLoadControl.Builder().setBufferDurationsMs((int)(AudioPlayer.getLong(loadControlMap.get("minBufferDuration")) / 1000L), (int)(AudioPlayer.getLong(loadControlMap.get("maxBufferDuration")) / 1000L), (int)(AudioPlayer.getLong(loadControlMap.get("bufferForPlaybackDuration")) / 1000L), (int)(AudioPlayer.getLong(loadControlMap.get("bufferForPlaybackAfterRebufferDuration")) / 1000L)).setPrioritizeTimeOverSizeThresholds(((Boolean)loadControlMap.get("prioritizeTimeOverSizeThresholds")).booleanValue()).setBackBuffer((int)(AudioPlayer.getLong(loadControlMap.get("backBufferDuration")) / 1000L), false);
                if (loadControlMap.get("targetBufferBytes") != null) {
                    builder.setTargetBufferBytes(((Integer)loadControlMap.get("targetBufferBytes")).intValue());
                }
                this.loadControl = builder.build();
            }
            if ((livePlaybackSpeedControlMap = (Map)audioLoadConfiguration.get("androidLivePlaybackSpeedControl")) != null) {
                DefaultLivePlaybackSpeedControl.Builder builder = new DefaultLivePlaybackSpeedControl.Builder().setFallbackMinPlaybackSpeed((float)((Double)livePlaybackSpeedControlMap.get("fallbackMinPlaybackSpeed")).doubleValue()).setFallbackMaxPlaybackSpeed((float)((Double)livePlaybackSpeedControlMap.get("fallbackMaxPlaybackSpeed")).doubleValue()).setMinUpdateIntervalMs(AudioPlayer.getLong(livePlaybackSpeedControlMap.get("minUpdateInterval")) / 1000L).setProportionalControlFactor((float)((Double)livePlaybackSpeedControlMap.get("proportionalControlFactor")).doubleValue()).setMaxLiveOffsetErrorMsForUnitSpeed(AudioPlayer.getLong(livePlaybackSpeedControlMap.get("maxLiveOffsetErrorForUnitSpeed")) / 1000L).setTargetLiveOffsetIncrementOnRebufferMs(AudioPlayer.getLong(livePlaybackSpeedControlMap.get("targetLiveOffsetIncrementOnRebuffer")) / 1000L).setMinPossibleLiveOffsetSmoothingFactor((float)((Double)livePlaybackSpeedControlMap.get("minPossibleLiveOffsetSmoothingFactor")).doubleValue());
                this.livePlaybackSpeedControl = builder.build();
            }
        }
    }

    private void startWatchingBuffer() {
        this.handler.removeCallbacks(this.bufferWatcher);
        this.handler.post(this.bufferWatcher);
    }

    private void setAudioSessionId(int audioSessionId) {
        this.audioSessionId = audioSessionId == 0 ? null : Integer.valueOf(audioSessionId);
        this.clearAudioEffects();
        if (this.audioSessionId != null) {
            for (Object rawAudioEffect : this.rawAudioEffects) {
                Map json = (Map)rawAudioEffect;
                AudioEffect audioEffect = this.decodeAudioEffect(rawAudioEffect, this.audioSessionId);
                if (((Boolean)json.get("enabled")).booleanValue()) {
                    audioEffect.setEnabled(true);
                }
                this.audioEffects.add(audioEffect);
                this.audioEffectsMap.put((String)json.get("type"), audioEffect);
            }
        }
        this.enqueuePlaybackEvent();
    }

    public void onAudioSessionIdChanged(int audioSessionId) {
        this.setAudioSessionId(audioSessionId);
        this.broadcastPendingPlaybackEvent();
    }

    public void onMetadata(Metadata metadata) {
        for (int i = 0; i < metadata.length(); ++i) {
            Metadata.Entry entry = metadata.get(i);
            if (!(entry instanceof IcyInfo)) continue;
            this.icyInfo = (IcyInfo)entry;
            this.broadcastImmediatePlaybackEvent();
        }
    }

    public void onTracksChanged(Tracks tracks) {
        for (int i = 0; i < tracks.getGroups().size(); ++i) {
            TrackGroup trackGroup = ((Tracks.Group)tracks.getGroups().get(i)).getMediaTrackGroup();
            for (int j = 0; j < trackGroup.length; ++j) {
                Metadata metadata = trackGroup.getFormat((int)j).metadata;
                if (metadata == null) continue;
                for (int k = 0; k < metadata.length(); ++k) {
                    Metadata.Entry entry = metadata.get(k);
                    if (!(entry instanceof IcyHeaders)) continue;
                    this.icyHeaders = (IcyHeaders)entry;
                    this.broadcastImmediatePlaybackEvent();
                }
            }
        }
    }

    private boolean updatePositionIfChanged() {
        if (this.getCurrentPosition() == this.updatePosition) {
            return false;
        }
        this.updatePosition = this.getCurrentPosition();
        this.updateTime = System.currentTimeMillis();
        return true;
    }

    private void updatePosition() {
        this.updatePosition = this.getCurrentPosition();
        this.updateTime = System.currentTimeMillis();
    }

    public void onPositionDiscontinuity(Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
        this.updatePosition();
        switch (reason) {
            case 0: 
            case 1: {
                this.updateCurrentIndex();
            }
        }
        this.broadcastImmediatePlaybackEvent();
    }

    public void onTimelineChanged(Timeline timeline, int reason) {
        if (this.initialPos != -9223372036854775807L || this.initialIndex != null) {
            int windowIndex = this.initialIndex != null ? this.initialIndex : 0;
            this.player.seekTo(windowIndex, this.initialPos);
            this.initialIndex = null;
            this.initialPos = -9223372036854775807L;
        }
        if (this.updateCurrentIndex()) {
            this.broadcastImmediatePlaybackEvent();
        }
        if (this.player.getPlaybackState() == 4) {
            try {
                if (this.player.getPlayWhenReady()) {
                    if (this.lastPlaylistLength == 0 && this.player.getMediaItemCount() > 0) {
                        this.player.seekTo(0, 0L);
                    } else if (this.player.hasNextMediaItem()) {
                        this.player.seekToNextMediaItem();
                    }
                } else if (this.player.getCurrentMediaItemIndex() < this.player.getMediaItemCount()) {
                    this.player.seekTo(this.player.getCurrentMediaItemIndex(), 0L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.lastPlaylistLength = this.player.getMediaItemCount();
    }

    private boolean updateCurrentIndex() {
        Integer newIndex = this.player.getCurrentMediaItemIndex();
        if (!newIndex.equals(this.currentIndex)) {
            this.currentIndex = newIndex;
            return true;
        }
        return false;
    }

    public void onPlaybackStateChanged(int playbackState) {
        switch (playbackState) {
            case 3: {
                if (this.player.getPlayWhenReady()) {
                    this.updatePosition();
                }
                this.processingState = ProcessingState.ready;
                this.broadcastImmediatePlaybackEvent();
                if (this.prepareResult != null) {
                    HashMap<String, Long> response = new HashMap<String, Long>();
                    response.put("duration", this.getDuration() == -9223372036854775807L ? null : Long.valueOf(1000L * this.getDuration()));
                    this.prepareResult.success(response);
                    this.prepareResult = null;
                    if (this.pendingAudioAttributes != null) {
                        this.player.setAudioAttributes(this.pendingAudioAttributes, false);
                        this.pendingAudioAttributes = null;
                    }
                }
                if (this.seekResult == null) break;
                this.completeSeek();
                break;
            }
            case 2: {
                this.updatePositionIfChanged();
                if (this.processingState != ProcessingState.buffering && this.processingState != ProcessingState.loading) {
                    this.processingState = ProcessingState.buffering;
                    this.broadcastImmediatePlaybackEvent();
                }
                this.startWatchingBuffer();
                break;
            }
            case 4: {
                if (this.processingState != ProcessingState.completed) {
                    this.updatePosition();
                    this.processingState = ProcessingState.completed;
                    this.broadcastImmediatePlaybackEvent();
                }
                if (this.prepareResult != null) {
                    HashMap response = new HashMap();
                    this.prepareResult.success(response);
                    this.prepareResult = null;
                    if (this.pendingAudioAttributes != null) {
                        this.player.setAudioAttributes(this.pendingAudioAttributes, false);
                        this.pendingAudioAttributes = null;
                    }
                }
                if (this.playResult == null) break;
                this.playResult.success(new HashMap());
                this.playResult = null;
            }
        }
    }

    public void onPlayerError(PlaybackException error) {
        Timeline timeline;
        int nextIndex;
        if (error instanceof ExoPlaybackException) {
            ExoPlaybackException exoError = (ExoPlaybackException)error;
            switch (exoError.type) {
                case 0: {
                    Log.e((String)TAG, (String)("TYPE_SOURCE: " + exoError.getSourceException().getMessage()));
                    break;
                }
                case 1: {
                    Log.e((String)TAG, (String)("TYPE_RENDERER: " + exoError.getRendererException().getMessage()));
                    break;
                }
                case 2: {
                    Log.e((String)TAG, (String)("TYPE_UNEXPECTED: " + exoError.getUnexpectedException().getMessage()));
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("default ExoPlaybackException: " + exoError.getUnexpectedException().getMessage()));
                }
            }
            this.sendError(String.valueOf(exoError.type), exoError.getMessage(), AudioPlayer.mapOf("index", this.currentIndex));
        } else {
            Log.e((String)TAG, (String)("default PlaybackException: " + error.getMessage()));
            this.sendError(String.valueOf(error.errorCode), error.getMessage(), AudioPlayer.mapOf("index", this.currentIndex));
        }
        ++this.errorCount;
        if (this.player.hasNextMediaItem() && this.currentIndex != null && this.errorCount <= 5 && (nextIndex = this.currentIndex + 1) < (timeline = this.player.getCurrentTimeline()).getWindowCount()) {
            this.player.setMediaSource(this.mediaSource);
            this.player.prepare();
            this.player.seekTo(nextIndex, 0L);
        }
    }

    private void completeSeek() {
        this.seekPos = null;
        this.seekResult.success(new HashMap());
        this.seekResult = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        this.ensurePlayerInitialized();
        try {
            switch (call.method) {
                case "load": {
                    Long initialPosition = AudioPlayer.getLong(call.argument("initialPosition"));
                    Integer initialIndex = (Integer)call.argument("initialIndex");
                    this.load(this.getAudioSource(call.argument("audioSource")), initialPosition == null ? -9223372036854775807L : initialPosition / 1000L, initialIndex, result);
                    return;
                }
                case "play": {
                    this.play(result);
                    return;
                }
                case "pause": {
                    this.pause();
                    result.success(new HashMap());
                    return;
                }
                case "setVolume": {
                    this.setVolume((float)((Double)call.argument("volume")).doubleValue());
                    result.success(new HashMap());
                    return;
                }
                case "setSpeed": {
                    this.setSpeed((float)((Double)call.argument("speed")).doubleValue());
                    result.success(new HashMap());
                    return;
                }
                case "setPitch": {
                    this.setPitch((float)((Double)call.argument("pitch")).doubleValue());
                    result.success(new HashMap());
                    return;
                }
                case "setSkipSilence": {
                    this.setSkipSilenceEnabled((Boolean)call.argument("enabled"));
                    result.success(new HashMap());
                    return;
                }
                case "setLoopMode": {
                    this.setLoopMode((Integer)call.argument("loopMode"));
                    result.success(new HashMap());
                    return;
                }
                case "setShuffleMode": {
                    this.setShuffleModeEnabled((Integer)call.argument("shuffleMode") == 1);
                    result.success(new HashMap());
                    return;
                }
                case "setShuffleOrder": {
                    this.setShuffleOrder(call.argument("audioSource"));
                    result.success(new HashMap());
                    return;
                }
                case "setAutomaticallyWaitsToMinimizeStalling": {
                    result.success(new HashMap());
                    return;
                }
                case "setCanUseNetworkResourcesForLiveStreamingWhilePaused": {
                    result.success(new HashMap());
                    return;
                }
                case "setPreferredPeakBitRate": {
                    result.success(new HashMap());
                    return;
                }
                case "seek": {
                    Long position = AudioPlayer.getLong(call.argument("position"));
                    Integer index = (Integer)call.argument("index");
                    this.seek(position == null ? -9223372036854775807L : position / 1000L, index, result);
                    return;
                }
                case "concatenatingInsertAll": {
                    this.concatenating(call.argument("id")).addMediaSources(((Integer)call.argument("index")).intValue(), this.getAudioSources(call.argument("children")), this.handler, () -> result.success(new HashMap()));
                    this.concatenating(call.argument("id")).setShuffleOrder(this.decodeShuffleOrder((List)call.argument("shuffleOrder")));
                    return;
                }
                case "concatenatingRemoveRange": {
                    this.concatenating(call.argument("id")).removeMediaSourceRange(((Integer)call.argument("startIndex")).intValue(), ((Integer)call.argument("endIndex")).intValue(), this.handler, () -> result.success(new HashMap()));
                    this.concatenating(call.argument("id")).setShuffleOrder(this.decodeShuffleOrder((List)call.argument("shuffleOrder")));
                    return;
                }
                case "concatenatingMove": {
                    this.concatenating(call.argument("id")).moveMediaSource(((Integer)call.argument("currentIndex")).intValue(), ((Integer)call.argument("newIndex")).intValue(), this.handler, () -> result.success(new HashMap()));
                    this.concatenating(call.argument("id")).setShuffleOrder(this.decodeShuffleOrder((List)call.argument("shuffleOrder")));
                    return;
                }
                case "setAndroidAudioAttributes": {
                    this.setAudioAttributes((Integer)call.argument("contentType"), (Integer)call.argument("flags"), (Integer)call.argument("usage"));
                    result.success(new HashMap());
                    return;
                }
                case "audioEffectSetEnabled": {
                    this.audioEffectSetEnabled((String)call.argument("type"), (Boolean)call.argument("enabled"));
                    result.success(new HashMap());
                    return;
                }
                case "androidLoudnessEnhancerSetTargetGain": {
                    this.loudnessEnhancerSetTargetGain((Double)call.argument("targetGain"));
                    result.success(new HashMap());
                    return;
                }
                case "androidEqualizerGetParameters": {
                    result.success(this.equalizerAudioEffectGetParameters());
                    return;
                }
                case "androidEqualizerBandSetGain": {
                    this.equalizerBandSetGain((Integer)call.argument("bandIndex"), (Double)call.argument("gain"));
                    result.success(new HashMap());
                    return;
                }
                default: {
                    result.notImplemented();
                    return;
                }
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            result.error("Illegal state: " + e.getMessage(), e.toString(), null);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            result.error("Error: " + e, e.toString(), null);
            return;
        }
        finally {
            this.broadcastPendingPlaybackEvent();
        }
    }

    private ShuffleOrder decodeShuffleOrder(List<Integer> indexList) {
        int[] shuffleIndices = new int[indexList.size()];
        for (int i = 0; i < shuffleIndices.length; ++i) {
            shuffleIndices[i] = indexList.get(i);
        }
        return new ShuffleOrder.DefaultShuffleOrder(shuffleIndices, random.nextLong());
    }

    private static int[] shuffle(int length, Integer firstIndex) {
        int[] shuffleOrder = new int[length];
        int i = 0;
        while (i < length) {
            int j = random.nextInt(i + 1);
            shuffleOrder[i] = shuffleOrder[j];
            shuffleOrder[j] = i++;
        }
        if (firstIndex != null) {
            for (i = 1; i < length; ++i) {
                if (shuffleOrder[i] != firstIndex) continue;
                int v = shuffleOrder[0];
                shuffleOrder[0] = shuffleOrder[i];
                shuffleOrder[i] = v;
                break;
            }
        }
        return shuffleOrder;
    }

    private ShuffleOrder createShuffleOrder(int length, Integer firstIndex) {
        int[] shuffleIndices = AudioPlayer.shuffle(length, firstIndex);
        return new ShuffleOrder.DefaultShuffleOrder(shuffleIndices, random.nextLong());
    }

    private ConcatenatingMediaSource concatenating(Object index) {
        return (ConcatenatingMediaSource)this.mediaSources.get((String)index);
    }

    private void setShuffleOrder(Object json) {
        Map map = (Map)json;
        String id = (String)AudioPlayer.mapGet(map, "id");
        MediaSource mediaSource = this.mediaSources.get(id);
        if (mediaSource == null) {
            return;
        }
        switch ((String)AudioPlayer.mapGet(map, "type")) {
            case "concatenating": {
                ConcatenatingMediaSource concatenatingMediaSource = (ConcatenatingMediaSource)mediaSource;
                concatenatingMediaSource.setShuffleOrder(this.decodeShuffleOrder((List)AudioPlayer.mapGet(map, "shuffleOrder")));
                List children = (List)AudioPlayer.mapGet(map, "children");
                for (Object child : children) {
                    this.setShuffleOrder(child);
                }
                break;
            }
            case "looping": {
                this.setShuffleOrder(AudioPlayer.mapGet(map, "child"));
            }
        }
    }

    private MediaSource getAudioSource(Object json) {
        Map map = (Map)json;
        String id = (String)map.get("id");
        MediaSource mediaSource = this.mediaSources.get(id);
        if (mediaSource == null) {
            mediaSource = this.decodeAudioSource(map);
            this.mediaSources.put(id, mediaSource);
        }
        return mediaSource;
    }

    private DefaultExtractorsFactory buildExtractorsFactory(Map<?, ?> options) {
        Map androidExtractorOptions;
        DefaultExtractorsFactory extractorsFactory = new DefaultExtractorsFactory();
        boolean constantBitrateSeekingEnabled = true;
        boolean constantBitrateSeekingAlwaysEnabled = false;
        int mp3Flags = 0;
        if (options != null && (androidExtractorOptions = (Map)options.get("androidExtractorOptions")) != null) {
            constantBitrateSeekingEnabled = (Boolean)androidExtractorOptions.get("constantBitrateSeekingEnabled");
            constantBitrateSeekingAlwaysEnabled = (Boolean)androidExtractorOptions.get("constantBitrateSeekingAlwaysEnabled");
            mp3Flags = (Integer)androidExtractorOptions.get("mp3Flags");
        }
        extractorsFactory.setConstantBitrateSeekingEnabled(constantBitrateSeekingEnabled);
        extractorsFactory.setConstantBitrateSeekingAlwaysEnabled(constantBitrateSeekingAlwaysEnabled);
        extractorsFactory.setMp3ExtractorFlags(mp3Flags);
        return extractorsFactory;
    }

    private MediaSource decodeAudioSource(Object json) {
        Map map = (Map)json;
        String id = (String)map.get("id");
        switch ((String)map.get("type")) {
            case "progressive": {
                return new ProgressiveMediaSource.Factory(this.buildDataSourceFactory((Map)AudioPlayer.mapGet(map, "headers")), (ExtractorsFactory)this.buildExtractorsFactory((Map)AudioPlayer.mapGet(map, "options"))).createMediaSource(new MediaItem.Builder().setUri(Uri.parse((String)((String)map.get("uri")))).setTag((Object)id).build());
            }
            case "dash": {
                return new DashMediaSource.Factory(this.buildDataSourceFactory((Map)AudioPlayer.mapGet(map, "headers"))).createMediaSource(new MediaItem.Builder().setUri(Uri.parse((String)((String)map.get("uri")))).setMimeType("application/dash+xml").setTag((Object)id).build());
            }
            case "hls": {
                return new HlsMediaSource.Factory(this.buildDataSourceFactory((Map)AudioPlayer.mapGet(map, "headers"))).createMediaSource(new MediaItem.Builder().setUri(Uri.parse((String)((String)map.get("uri")))).setMimeType("application/x-mpegURL").build());
            }
            case "silence": {
                return new SilenceMediaSource.Factory().setDurationUs(AudioPlayer.getLong(map.get("duration")).longValue()).setTag((Object)id).createMediaSource();
            }
            case "concatenating": {
                MediaSource[] mediaSources = this.getAudioSourcesArray(map.get("children"));
                return new ConcatenatingMediaSource(false, ((Boolean)map.get("useLazyPreparation")).booleanValue(), this.decodeShuffleOrder((List)AudioPlayer.mapGet(map, "shuffleOrder")), mediaSources);
            }
            case "clipping": {
                Long start = AudioPlayer.getLong(map.get("start"));
                Long end = AudioPlayer.getLong(map.get("end"));
                return new ClippingMediaSource(this.getAudioSource(map.get("child")), start != null ? start : 0L, end != null ? end : Long.MIN_VALUE);
            }
            case "looping": {
                Integer count = (Integer)map.get("count");
                MediaSource looperChild = this.getAudioSource(map.get("child"));
                MediaSource[] looperChildren = new MediaSource[count.intValue()];
                for (int i = 0; i < looperChildren.length; ++i) {
                    looperChildren[i] = looperChild;
                }
                return new ConcatenatingMediaSource(looperChildren);
            }
        }
        throw new IllegalArgumentException("Unknown AudioSource type: " + map.get("type"));
    }

    private MediaSource[] getAudioSourcesArray(Object json) {
        List<MediaSource> mediaSources = this.getAudioSources(json);
        MediaSource[] mediaSourcesArray = new MediaSource[mediaSources.size()];
        mediaSources.toArray(mediaSourcesArray);
        return mediaSourcesArray;
    }

    private List<MediaSource> getAudioSources(Object json) {
        if (!(json instanceof List)) {
            throw new RuntimeException("List expected: " + json);
        }
        List audioSources = (List)json;
        ArrayList<MediaSource> mediaSources = new ArrayList<MediaSource>();
        for (int i = 0; i < audioSources.size(); ++i) {
            mediaSources.add(this.getAudioSource(audioSources.get(i)));
        }
        return mediaSources;
    }

    private AudioEffect decodeAudioEffect(Object json, int audioSessionId) {
        String type;
        Map map = (Map)json;
        switch (type = (String)map.get("type")) {
            case "AndroidLoudnessEnhancer": {
                if (Build.VERSION.SDK_INT < 19) {
                    throw new RuntimeException("AndroidLoudnessEnhancer requires minSdkVersion >= 19");
                }
                int targetGain = (int)Math.round((Double)map.get("targetGain") * 1000.0);
                LoudnessEnhancer loudnessEnhancer = new LoudnessEnhancer(audioSessionId);
                loudnessEnhancer.setTargetGain(targetGain);
                return loudnessEnhancer;
            }
            case "AndroidEqualizer": {
                Equalizer equalizer = new Equalizer(0, audioSessionId);
                return equalizer;
            }
        }
        throw new IllegalArgumentException("Unknown AudioEffect type: " + map.get("type"));
    }

    private void clearAudioEffects() {
        Iterator<AudioEffect> it = this.audioEffects.iterator();
        while (it.hasNext()) {
            AudioEffect audioEffect = it.next();
            audioEffect.release();
            it.remove();
        }
        this.audioEffectsMap.clear();
    }

    private DataSource.Factory buildDataSourceFactory(Map<?, ?> headers) {
        Map<String, String> stringHeaders = AudioPlayer.castToStringMap(headers);
        String userAgent = null;
        if (stringHeaders != null && (userAgent = stringHeaders.remove("User-Agent")) == null) {
            userAgent = stringHeaders.remove("user-agent");
        }
        if (userAgent == null) {
            userAgent = Util.getUserAgent((Context)this.context, (String)"just_audio");
        }
        DefaultHttpDataSource.Factory httpDataSourceFactory = new DefaultHttpDataSource.Factory().setUserAgent(userAgent).setAllowCrossProtocolRedirects(true);
        if (stringHeaders != null && stringHeaders.size() > 0) {
            httpDataSourceFactory.setDefaultRequestProperties(stringHeaders);
        }
        return new DefaultDataSource.Factory(this.context, (DataSource.Factory)httpDataSourceFactory);
    }

    private void load(MediaSource mediaSource, long initialPosition, Integer initialIndex, MethodChannel.Result result) {
        this.initialPos = initialPosition;
        this.initialIndex = initialIndex;
        this.currentIndex = initialIndex != null ? initialIndex : 0;
        switch (this.processingState) {
            case none: {
                break;
            }
            case loading: {
                this.abortExistingConnection();
                this.player.stop();
                break;
            }
            default: {
                this.player.stop();
            }
        }
        this.errorCount = 0;
        this.prepareResult = result;
        this.updatePosition();
        this.processingState = ProcessingState.loading;
        this.enqueuePlaybackEvent();
        this.mediaSource = mediaSource;
        this.player.setMediaSource(mediaSource);
        this.player.prepare();
    }

    private void ensurePlayerInitialized() {
        if (this.player == null) {
            ExoPlayer.Builder builder = new ExoPlayer.Builder(this.context);
            if (this.loadControl != null) {
                builder.setLoadControl(this.loadControl);
            }
            if (this.livePlaybackSpeedControl != null) {
                builder.setLivePlaybackSpeedControl(this.livePlaybackSpeedControl);
            }
            this.player = builder.build();
            this.player.setTrackSelectionParameters(this.player.getTrackSelectionParameters().buildUpon().setAudioOffloadPreferences(new TrackSelectionParameters.AudioOffloadPreferences.Builder().setIsGaplessSupportRequired(!this.offloadSchedulingEnabled).setIsSpeedChangeSupportRequired(!this.offloadSchedulingEnabled).setAudioOffloadMode(1).build()).build());
            this.setAudioSessionId(this.player.getAudioSessionId());
            this.player.addListener((Player.Listener)this);
        }
    }

    private void setAudioAttributes(int contentType, int flags, int usage) {
        AudioAttributes.Builder builder = new AudioAttributes.Builder();
        builder.setContentType(contentType);
        builder.setFlags(flags);
        builder.setUsage(usage);
        AudioAttributes audioAttributes = builder.build();
        if (this.processingState == ProcessingState.loading) {
            this.pendingAudioAttributes = audioAttributes;
        } else {
            this.player.setAudioAttributes(audioAttributes, false);
        }
    }

    private void audioEffectSetEnabled(String type, boolean enabled) {
        this.audioEffectsMap.get(type).setEnabled(enabled);
    }

    private void loudnessEnhancerSetTargetGain(double targetGain) {
        int targetGainMillibels = (int)Math.round(targetGain * 1000.0);
        ((LoudnessEnhancer)this.audioEffectsMap.get("AndroidLoudnessEnhancer")).setTargetGain(targetGainMillibels);
    }

    private Map<String, Object> equalizerAudioEffectGetParameters() {
        Equalizer equalizer = (Equalizer)this.audioEffectsMap.get("AndroidEqualizer");
        ArrayList<Map<String, Object>> rawBands = new ArrayList<Map<String, Object>>();
        for (short i = 0; i < equalizer.getNumberOfBands(); i = (short)(i + 1)) {
            rawBands.add(AudioPlayer.mapOf("index", i, "lowerFrequency", (double)equalizer.getBandFreqRange(i)[0] / 1000.0, "upperFrequency", (double)equalizer.getBandFreqRange(i)[1] / 1000.0, "centerFrequency", (double)equalizer.getCenterFreq(i) / 1000.0, "gain", (double)equalizer.getBandLevel(i) / 1000.0));
        }
        return AudioPlayer.mapOf("parameters", AudioPlayer.mapOf("minDecibels", (double)equalizer.getBandLevelRange()[0] / 1000.0, "maxDecibels", (double)equalizer.getBandLevelRange()[1] / 1000.0, "bands", rawBands));
    }

    private void equalizerBandSetGain(int bandIndex, double gain) {
        ((Equalizer)this.audioEffectsMap.get("AndroidEqualizer")).setBandLevel((short)bandIndex, (short)Math.round(gain * 1000.0));
    }

    private Map<String, Object> createPlaybackEvent() {
        HashMap<String, Object> event = new HashMap<String, Object>();
        Long duration = this.getDuration() == -9223372036854775807L ? null : Long.valueOf(1000L * this.getDuration());
        this.bufferedPosition = this.player != null ? this.player.getBufferedPosition() : 0L;
        event.put("processingState", this.processingState.ordinal());
        event.put("updatePosition", 1000L * this.updatePosition);
        event.put("updateTime", this.updateTime);
        event.put("bufferedPosition", 1000L * Math.max(this.updatePosition, this.bufferedPosition));
        event.put("icyMetadata", this.collectIcyMetadata());
        event.put("duration", duration);
        event.put("currentIndex", this.currentIndex);
        event.put("androidAudioSessionId", this.audioSessionId);
        return event;
    }

    private void broadcastPendingPlaybackEvent() {
        if (this.pendingPlaybackEvent != null) {
            this.eventChannel.success(this.pendingPlaybackEvent);
            this.pendingPlaybackEvent = null;
        }
    }

    private void enqueuePlaybackEvent() {
        HashMap event = new HashMap();
        this.pendingPlaybackEvent = this.createPlaybackEvent();
    }

    private void broadcastImmediatePlaybackEvent() {
        this.enqueuePlaybackEvent();
        this.broadcastPendingPlaybackEvent();
    }

    private Map<String, Object> collectIcyMetadata() {
        HashMap<String, Object> icyData = new HashMap<String, Object>();
        if (this.icyInfo != null) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("title", this.icyInfo.title);
            info.put("url", this.icyInfo.url);
            icyData.put("info", info);
        }
        if (this.icyHeaders != null) {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("bitrate", this.icyHeaders.bitrate);
            headers.put("genre", this.icyHeaders.genre);
            headers.put("name", this.icyHeaders.name);
            headers.put("metadataInterval", this.icyHeaders.metadataInterval);
            headers.put("url", this.icyHeaders.url);
            headers.put("isPublic", this.icyHeaders.isPublic);
            icyData.put("headers", headers);
        }
        return icyData;
    }

    private long getCurrentPosition() {
        if (this.initialPos != -9223372036854775807L) {
            return this.initialPos;
        }
        if (this.processingState == ProcessingState.none || this.processingState == ProcessingState.loading) {
            long pos = this.player.getCurrentPosition();
            if (pos < 0L) {
                pos = 0L;
            }
            return pos;
        }
        if (this.seekPos != null && this.seekPos != -9223372036854775807L) {
            return this.seekPos;
        }
        return this.player.getCurrentPosition();
    }

    private long getDuration() {
        if (this.processingState == ProcessingState.none || this.processingState == ProcessingState.loading || this.player == null) {
            return -9223372036854775807L;
        }
        return this.player.getDuration();
    }

    private void sendError(String errorCode, String errorMsg) {
        this.sendError(errorCode, errorMsg, null);
    }

    private void sendError(String errorCode, String errorMsg, Object details) {
        if (this.prepareResult != null) {
            this.prepareResult.error(errorCode, errorMsg, details);
            this.prepareResult = null;
        }
        this.eventChannel.error(errorCode, errorMsg, details);
    }

    private String getLowerCaseExtension(Uri uri) {
        String fragment = uri.getFragment();
        String filename = fragment != null && fragment.contains(".") ? fragment : uri.getPath();
        return filename.replaceAll("^.*\\.", "").toLowerCase();
    }

    public void play(MethodChannel.Result result) {
        if (this.player.getPlayWhenReady()) {
            result.success(new HashMap());
            return;
        }
        if (this.playResult != null) {
            this.playResult.success(new HashMap());
        }
        this.playResult = result;
        this.player.setPlayWhenReady(true);
        this.updatePosition();
        if (this.processingState == ProcessingState.completed && this.playResult != null) {
            this.playResult.success(new HashMap());
            this.playResult = null;
        }
    }

    public void pause() {
        if (!this.player.getPlayWhenReady()) {
            return;
        }
        this.player.setPlayWhenReady(false);
        this.updatePosition();
        if (this.playResult != null) {
            this.playResult.success(new HashMap());
            this.playResult = null;
        }
    }

    public void setVolume(float volume) {
        this.player.setVolume(volume);
    }

    public void setSpeed(float speed) {
        PlaybackParameters params = this.player.getPlaybackParameters();
        if (params.speed == speed) {
            return;
        }
        this.player.setPlaybackParameters(new PlaybackParameters(speed, params.pitch));
        if (this.player.getPlayWhenReady()) {
            this.updatePosition();
        }
        this.enqueuePlaybackEvent();
    }

    public void setPitch(float pitch) {
        PlaybackParameters params = this.player.getPlaybackParameters();
        if (params.pitch == pitch) {
            return;
        }
        this.player.setPlaybackParameters(new PlaybackParameters(params.speed, pitch));
        this.enqueuePlaybackEvent();
    }

    public void setSkipSilenceEnabled(boolean enabled) {
        this.player.setSkipSilenceEnabled(enabled);
    }

    public void setLoopMode(int mode) {
        this.player.setRepeatMode(mode);
    }

    public void setShuffleModeEnabled(boolean enabled) {
        this.player.setShuffleModeEnabled(enabled);
    }

    public void seek(long position, Integer index, MethodChannel.Result result) {
        if (this.processingState == ProcessingState.none || this.processingState == ProcessingState.loading) {
            result.success(new HashMap());
            return;
        }
        this.abortSeek();
        this.seekPos = position;
        this.seekResult = result;
        try {
            int windowIndex = index != null ? index.intValue() : this.player.getCurrentMediaItemIndex();
            this.player.seekTo(windowIndex, position);
        }
        catch (RuntimeException e) {
            this.seekResult = null;
            this.seekPos = null;
            throw e;
        }
    }

    public void dispose() {
        if (this.processingState == ProcessingState.loading) {
            this.abortExistingConnection();
        }
        if (this.playResult != null) {
            this.playResult.success(new HashMap());
            this.playResult = null;
        }
        this.mediaSources.clear();
        this.mediaSource = null;
        this.clearAudioEffects();
        if (this.player != null) {
            this.player.release();
            this.player = null;
            this.processingState = ProcessingState.none;
            this.broadcastImmediatePlaybackEvent();
        }
        this.eventChannel.endOfStream();
        this.dataEventChannel.endOfStream();
    }

    private void abortSeek() {
        if (this.seekResult != null) {
            try {
                this.seekResult.success(new HashMap());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.seekResult = null;
            this.seekPos = null;
        }
    }

    private void abortExistingConnection() {
        this.sendError("abort", "Connection aborted");
    }

    public static Long getLong(Object o) {
        return o == null || o instanceof Long ? (Long)o : Long.valueOf(((Integer)o).intValue());
    }

    static <T> T mapGet(Object o, String key) {
        if (o instanceof Map) {
            return (T)((Map)o).get(key);
        }
        return null;
    }

    static Map<String, Object> mapOf(Object ... args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < args.length; i += 2) {
            map.put((String)args[i], args[i + 1]);
        }
        return map;
    }

    static Map<String, String> castToStringMap(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (Object key : map.keySet()) {
            map2.put((String)key, (String)map.get(key));
        }
        return map2;
    }

    static enum ProcessingState {
        none,
        loading,
        buffering,
        ready,
        completed;

    }
}

