/*
 * Decompiled with CFR 0.152.
 */
package com.ryanheise.just_audio;

import android.content.Context;
import androidx.annotation.NonNull;
import com.ryanheise.just_audio.MainMethodCallHandler;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodChannel;

public class JustAudioPlugin
implements FlutterPlugin {
    private MethodChannel channel;
    private MainMethodCallHandler methodCallHandler;

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        Context applicationContext = binding.getApplicationContext();
        BinaryMessenger messenger = binding.getBinaryMessenger();
        this.methodCallHandler = new MainMethodCallHandler(applicationContext, messenger);
        this.channel = new MethodChannel(messenger, "com.ryanheise.just_audio.methods");
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this.methodCallHandler);
        FlutterEngine engine = binding.getFlutterEngine();
        engine.addEngineLifecycleListener(new FlutterEngine.EngineLifecycleListener(){

            public void onPreEngineRestart() {
                JustAudioPlugin.this.methodCallHandler.dispose();
            }

            public void onEngineWillDestroy() {
            }
        });
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.methodCallHandler.dispose();
        this.methodCallHandler = null;
        this.channel.setMethodCallHandler(null);
    }
}

