/*
 * Decompiled with CFR 0.152.
 */
package com.ryanheise.just_audio;

import android.content.Context;
import androidx.annotation.NonNull;
import com.ryanheise.just_audio.AudioPlayer;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MainMethodCallHandler
implements MethodChannel.MethodCallHandler {
    private final Context applicationContext;
    private final BinaryMessenger messenger;
    private final Map<String, AudioPlayer> players = new HashMap<String, AudioPlayer>();

    public MainMethodCallHandler(Context applicationContext, BinaryMessenger messenger) {
        this.applicationContext = applicationContext;
        this.messenger = messenger;
    }

    public void onMethodCall(MethodCall call, @NonNull MethodChannel.Result result) {
        switch (call.method) {
            case "init": {
                String id = (String)call.argument("id");
                if (this.players.containsKey(id)) {
                    result.error("Platform player " + id + " already exists", null, null);
                    break;
                }
                List rawAudioEffects = (List)call.argument("androidAudioEffects");
                this.players.put(id, new AudioPlayer(this.applicationContext, this.messenger, id, (Map)call.argument("audioLoadConfiguration"), rawAudioEffects, (Boolean)call.argument("androidOffloadSchedulingEnabled")));
                result.success(null);
                break;
            }
            case "disposePlayer": {
                String id = (String)call.argument("id");
                AudioPlayer player = this.players.get(id);
                if (player != null) {
                    player.dispose();
                    this.players.remove(id);
                }
                result.success(new HashMap());
                break;
            }
            case "disposeAllPlayers": {
                this.dispose();
                result.success(new HashMap());
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    void dispose() {
        for (AudioPlayer player : new ArrayList<AudioPlayer>(this.players.values())) {
            player.dispose();
        }
        this.players.clear();
    }
}

