/*
 * Decompiled with CFR 0.152.
 */
package com.lyokone.location;

import android.app.Activity;
import android.app.Notification;
import android.app.Service;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import com.lyokone.location.BackgroundNotification;
import com.lyokone.location.FlutterLocation;
import com.lyokone.location.NotificationOptions;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\u0018\u0000 =2\u00020\u00012\u00020\u0002:\u0002=>B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0018\u00010!2\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020\u000bJ\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(J\u0006\u0010*\u001a\u00020\u000bJ\u0012\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020(H\u0016J\b\u00100\u001a\u00020(H\u0016J-\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u0002032\u000e\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"052\u0006\u00106\u001a\u000207H\u0016\u00a2\u0006\u0002\u00108J\u0012\u00109\u001a\u00020\u000b2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0006\u0010:\u001a\u00020(J\u0010\u0010;\u001a\u00020(2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\b\u0010<\u001a\u00020\u000bH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017\u00a8\u0006?"}, d2={"Lcom/lyokone/location/FlutterLocationService;", "Landroid/app/Service;", "Lio/flutter/plugin/common/PluginRegistry$RequestPermissionsResultListener;", "()V", "activity", "Landroid/app/Activity;", "backgroundNotification", "Lcom/lyokone/location/BackgroundNotification;", "binder", "Lcom/lyokone/location/FlutterLocationService$LocalBinder;", "isForeground", "", "<set-?>", "Lcom/lyokone/location/FlutterLocation;", "location", "getLocation", "()Lcom/lyokone/location/FlutterLocation;", "locationActivityResultListener", "Lio/flutter/plugin/common/PluginRegistry$ActivityResultListener;", "getLocationActivityResultListener", "()Lio/flutter/plugin/common/PluginRegistry$ActivityResultListener;", "locationRequestPermissionsResultListener", "getLocationRequestPermissionsResultListener", "()Lio/flutter/plugin/common/PluginRegistry$RequestPermissionsResultListener;", "result", "Lio/flutter/plugin/common/MethodChannel$Result;", "getResult", "()Lio/flutter/plugin/common/MethodChannel$Result;", "setResult", "(Lio/flutter/plugin/common/MethodChannel$Result;)V", "serviceRequestPermissionsResultListener", "getServiceRequestPermissionsResultListener", "changeNotificationOptions", "", "", "", "options", "Lcom/lyokone/location/NotificationOptions;", "checkBackgroundPermissions", "disableBackgroundMode", "", "enableBackgroundMode", "isInForegroundMode", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onCreate", "onDestroy", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "grantResults", "", "(I[Ljava/lang/String;[I)Z", "onUnbind", "requestBackgroundPermissions", "setActivity", "shouldShowRequestBackgroundPermissionRationale", "Companion", "LocalBinder", "location_release"})
public final class FlutterLocationService
extends Service
implements PluginRegistry.RequestPermissionsResultListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalBinder binder = new LocalBinder();
    private boolean isForeground;
    @Nullable
    private Activity activity;
    @Nullable
    private BackgroundNotification backgroundNotification;
    @Nullable
    private FlutterLocation location;
    @Nullable
    private MethodChannel.Result result;
    @NotNull
    private static final String TAG = "FlutterLocationService";
    private static final int REQUEST_PERMISSIONS_REQUEST_CODE = 641;
    private static final int ONGOING_NOTIFICATION_ID = 75418;
    @NotNull
    private static final String CHANNEL_ID = "flutter_location_channel_01";

    @Nullable
    public final FlutterLocation getLocation() {
        return this.location;
    }

    @Nullable
    public final MethodChannel.Result getResult() {
        return this.result;
    }

    public final void setResult(@Nullable MethodChannel.Result result) {
        this.result = result;
    }

    @Nullable
    public final PluginRegistry.ActivityResultListener getLocationActivityResultListener() {
        return this.location;
    }

    @Nullable
    public final PluginRegistry.RequestPermissionsResultListener getLocationRequestPermissionsResultListener() {
        return this.location;
    }

    @NotNull
    public final PluginRegistry.RequestPermissionsResultListener getServiceRequestPermissionsResultListener() {
        return this;
    }

    public void onCreate() {
        super.onCreate();
        Log.d((String)TAG, (String)"Creating service.");
        this.location = new FlutterLocation(this.getApplicationContext(), null);
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        this.backgroundNotification = new BackgroundNotification(context, CHANNEL_ID, 75418);
    }

    @NotNull
    public IBinder onBind(@Nullable Intent intent) {
        Log.d((String)TAG, (String)"Binding to location service.");
        return (IBinder)this.binder;
    }

    public boolean onUnbind(@Nullable Intent intent) {
        Log.d((String)TAG, (String)"Unbinding from location service.");
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        Log.d((String)TAG, (String)"Destroying service.");
        this.location = null;
        this.backgroundNotification = null;
        super.onDestroy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean checkBackgroundPermissions() {
        if (Build.VERSION.SDK_INT >= 29) {
            Activity activity = this.activity;
            if (activity == null) throw new ActivityNotFoundException();
            Activity it = activity;
            boolean bl = false;
            int locationPermissionState = ActivityCompat.checkSelfPermission((Context)((Context)it), (String)"android.permission.ACCESS_BACKGROUND_LOCATION");
            if (locationPermissionState != 0) return false;
            return true;
        }
        FlutterLocation flutterLocation = this.location;
        if (flutterLocation == null) return false;
        boolean bl = flutterLocation.checkPermissions();
        return bl;
    }

    public final void requestBackgroundPermissions() {
        if (Build.VERSION.SDK_INT >= 29) {
            Unit unit;
            Activity activity = this.activity;
            if (activity != null) {
                Activity it = activity;
                boolean bl = false;
                String[] stringArray = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_BACKGROUND_LOCATION"};
                ActivityCompat.requestPermissions((Activity)it, (String[])stringArray, (int)641);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw new ActivityNotFoundException();
            }
        } else {
            if (this.location != null) {
                this.location.result = this.result;
            }
            FlutterLocation flutterLocation = this.location;
            if (flutterLocation != null) {
                flutterLocation.requestPermissions();
            }
            this.result = null;
        }
    }

    public final boolean isInForegroundMode() {
        return this.isForeground;
    }

    public final void enableBackgroundMode() {
        if (this.isForeground) {
            Log.d((String)TAG, (String)"Service already in foreground mode.");
        } else {
            Log.d((String)TAG, (String)"Start service in foreground mode.");
            BackgroundNotification backgroundNotification = this.backgroundNotification;
            Intrinsics.checkNotNull((Object)backgroundNotification);
            Notification notification = backgroundNotification.build();
            this.startForeground(75418, notification);
            this.isForeground = true;
        }
    }

    public final void disableBackgroundMode() {
        Log.d((String)TAG, (String)"Stop service in foreground.");
        if (Build.VERSION.SDK_INT >= 24) {
            this.stopForeground(1);
        } else {
            this.stopForeground(true);
        }
        this.isForeground = false;
    }

    @Nullable
    public final Map<String, Object> changeNotificationOptions(@NotNull NotificationOptions options) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        BackgroundNotification backgroundNotification = this.backgroundNotification;
        if (backgroundNotification != null) {
            backgroundNotification.updateOptions(options, this.isForeground);
        }
        if (this.isForeground) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"channelId", (Object)CHANNEL_ID), TuplesKt.to((Object)"notificationId", (Object)75418)};
            map = MapsKt.mapOf((Pair[])pairArray);
        } else {
            map = null;
        }
        return map;
    }

    public final void setActivity(@Nullable Activity activity) {
        block0: {
            this.activity = activity;
            FlutterLocation flutterLocation = this.location;
            if (flutterLocation == null) break block0;
            flutterLocation.setActivity(activity);
        }
    }

    public boolean onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        if (Build.VERSION.SDK_INT >= 29 && requestCode == 641 && permissions.length == 2 && Intrinsics.areEqual((Object)permissions[0], (Object)"android.permission.ACCESS_FINE_LOCATION") && Intrinsics.areEqual((Object)permissions[1], (Object)"android.permission.ACCESS_BACKGROUND_LOCATION")) {
            if (grantResults[0] == 0 && grantResults[1] == 0) {
                this.enableBackgroundMode();
                MethodChannel.Result result = this.result;
                if (result != null) {
                    result.success((Object)1);
                }
                this.result = null;
            } else {
                if (!this.shouldShowRequestBackgroundPermissionRationale()) {
                    MethodChannel.Result result = this.result;
                    if (result != null) {
                        result.error("PERMISSION_DENIED_NEVER_ASK", "Background location permission denied forever - please open app settings", null);
                    }
                } else {
                    MethodChannel.Result result = this.result;
                    if (result != null) {
                        result.error("PERMISSION_DENIED", "Background location permission denied", null);
                    }
                }
                this.result = null;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldShowRequestBackgroundPermissionRationale() {
        if (Build.VERSION.SDK_INT < 29) return false;
        Activity activity = this.activity;
        if (activity == null) throw new ActivityNotFoundException();
        Activity it = activity;
        boolean bl = false;
        boolean bl2 = ActivityCompat.shouldShowRequestPermissionRationale((Activity)it, (String)"android.permission.ACCESS_BACKGROUND_LOCATION");
        return bl2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/lyokone/location/FlutterLocationService$Companion;", "", "()V", "CHANNEL_ID", "", "ONGOING_NOTIFICATION_ID", "", "REQUEST_PERMISSIONS_REQUEST_CODE", "TAG", "location_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/lyokone/location/FlutterLocationService$LocalBinder;", "Landroid/os/Binder;", "(Lcom/lyokone/location/FlutterLocationService;)V", "getService", "Lcom/lyokone/location/FlutterLocationService;", "location_release"})
    public final class LocalBinder
    extends Binder {
        @NotNull
        public final FlutterLocationService getService() {
            return FlutterLocationService.this;
        }
    }
}

