/*
 * Decompiled with CFR 0.152.
 */
package com.lyokone.location;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.lyokone.location.NotificationOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0018R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/lyokone/location/BackgroundNotification;", "", "context", "Landroid/content/Context;", "channelId", "", "notificationId", "", "(Landroid/content/Context;Ljava/lang/String;I)V", "builder", "Landroidx/core/app/NotificationCompat$Builder;", "options", "Lcom/lyokone/location/NotificationOptions;", "build", "Landroid/app/Notification;", "buildBringToFrontIntent", "Landroid/app/PendingIntent;", "getDrawableId", "iconName", "updateChannel", "", "channelName", "updateNotification", "notify", "", "updateOptions", "isVisible", "location_release"})
public final class BackgroundNotification {
    @NotNull
    private final Context context;
    @NotNull
    private final String channelId;
    private final int notificationId;
    @NotNull
    private NotificationOptions options;
    @NotNull
    private NotificationCompat.Builder builder;

    public BackgroundNotification(@NotNull Context context, @NotNull String channelId, int notificationId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.context = context;
        this.channelId = channelId;
        this.notificationId = notificationId;
        this.options = new NotificationOptions(null, null, null, null, null, null, false, 127, null);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, this.channelId).setPriority(1);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, channel\u2026tionCompat.PRIORITY_HIGH)");
        this.builder = builder;
        this.updateNotification(this.options, false);
    }

    private final int getDrawableId(String iconName) {
        return this.context.getResources().getIdentifier(iconName, "drawable", this.context.getPackageName());
    }

    private final PendingIntent buildBringToFrontIntent() {
        Intent intent;
        Intent intent2 = this.context.getPackageManager().getLaunchIntentForPackage(this.context.getPackageName());
        Intent intent3 = intent2 != null && (intent = intent2.setPackage(null)) != null ? intent.setFlags(0x10200000) : null;
        return intent3 != null ? PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent3, (int)0x4000000) : null;
    }

    private final void updateChannel(String channelName) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel;
            NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)this.context);
            Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"from(context)");
            NotificationManagerCompat notificationManager = notificationManagerCompat;
            NotificationChannel $this$updateChannel_u24lambda_u240 = notificationChannel = new NotificationChannel(this.channelId, (CharSequence)channelName, 0);
            boolean bl = false;
            $this$updateChannel_u24lambda_u240.setLockscreenVisibility(0);
            NotificationChannel channel = notificationChannel;
            notificationManager.createNotificationChannel(channel);
        }
    }

    private final void updateNotification(NotificationOptions options, boolean notify) {
        NotificationCompat.Builder builder;
        NotificationCompat.Builder builder2;
        int it = this.getDrawableId(options.getIconName());
        boolean bl = false;
        int iconId = it != 0 ? it : this.getDrawableId("navigation_empty_icon");
        NotificationCompat.Builder builder3 = this.builder.setContentTitle((CharSequence)options.getTitle()).setSmallIcon(iconId).setContentText((CharSequence)options.getSubtitle()).setSubText((CharSequence)options.getDescription());
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder\n            .set\u2026Text(options.description)");
        this.builder = builder3;
        if (options.getColor() != null) {
            NotificationCompat.Builder builder4 = this.builder.setColor(options.getColor().intValue()).setColorized(true);
            builder2 = builder4;
            Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"{\n            builder.se\u2026Colorized(true)\n        }");
        } else {
            NotificationCompat.Builder builder5 = this.builder.setColor(0).setColorized(false);
            builder2 = builder5;
            Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"{\n            builder.se\u2026olorized(false)\n        }");
        }
        this.builder = builder2;
        if (options.getOnTapBringToFront()) {
            NotificationCompat.Builder builder6 = this.builder.setContentIntent(this.buildBringToFrontIntent());
            builder = builder6;
            Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"{\n            builder.se\u2026oFrontIntent())\n        }");
        } else {
            NotificationCompat.Builder builder7 = this.builder.setContentIntent(null);
            builder = builder7;
            Intrinsics.checkNotNullExpressionValue((Object)builder7, (String)"{\n            builder.se\u2026entIntent(null)\n        }");
        }
        this.builder = builder;
        if (notify) {
            NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)this.context);
            Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"from(context)");
            NotificationManagerCompat notificationManager = notificationManagerCompat;
            notificationManager.notify(this.notificationId, this.builder.build());
        }
    }

    public final void updateOptions(@NotNull NotificationOptions options, boolean isVisible) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!Intrinsics.areEqual((Object)options.getChannelName(), (Object)this.options.getChannelName())) {
            this.updateChannel(options.getChannelName());
        }
        this.updateNotification(options, isVisible);
        this.options = options;
    }

    @NotNull
    public final Notification build() {
        this.updateChannel(this.options.getChannelName());
        Notification notification = this.builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"builder.build()");
        return notification;
    }
}

