/*
 * Decompiled with CFR 0.152.
 */
package com.lyokone.location;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.lyokone.location.FlutterLocationService;
import com.lyokone.location.MethodCallHandlerImpl;
import com.lyokone.location.StreamHandlerImpl;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;

public class LocationPlugin
implements FlutterPlugin,
ActivityAware {
    private static final String TAG = "LocationPlugin";
    @Nullable
    private MethodCallHandlerImpl methodCallHandler;
    @Nullable
    private StreamHandlerImpl streamHandlerImpl;
    @Nullable
    private FlutterLocationService locationService;
    @Nullable
    private ActivityPluginBinding activityBinding;
    private final ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.d((String)LocationPlugin.TAG, (String)("Service connected: " + name));
            if (service instanceof FlutterLocationService.LocalBinder) {
                LocationPlugin.this.initialize(((FlutterLocationService.LocalBinder)service).getService());
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.d((String)LocationPlugin.TAG, (String)("Service disconnected:" + name));
        }
    };

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.methodCallHandler = new MethodCallHandlerImpl();
        this.methodCallHandler.startListening(binding.getBinaryMessenger());
        this.streamHandlerImpl = new StreamHandlerImpl();
        this.streamHandlerImpl.startListening(binding.getBinaryMessenger());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        if (this.methodCallHandler != null) {
            this.methodCallHandler.stopListening();
            this.methodCallHandler = null;
        }
        if (this.streamHandlerImpl != null) {
            this.streamHandlerImpl.stopListening();
            this.streamHandlerImpl = null;
        }
    }

    private void attachToActivity(ActivityPluginBinding binding) {
        this.activityBinding = binding;
        this.activityBinding.getActivity().bindService(new Intent((Context)binding.getActivity(), FlutterLocationService.class), this.serviceConnection, 1);
    }

    private void detachActivity() {
        this.dispose();
        this.activityBinding.getActivity().unbindService(this.serviceConnection);
        this.activityBinding = null;
    }

    public void onAttachedToActivity(@NonNull ActivityPluginBinding binding) {
        this.attachToActivity(binding);
    }

    public void onDetachedFromActivity() {
        this.detachActivity();
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.detachActivity();
    }

    public void onReattachedToActivityForConfigChanges(@NonNull ActivityPluginBinding binding) {
        this.attachToActivity(binding);
    }

    private void initialize(FlutterLocationService service) {
        this.locationService = service;
        this.locationService.setActivity(this.activityBinding.getActivity());
        this.activityBinding.addActivityResultListener(this.locationService.getLocationActivityResultListener());
        this.activityBinding.addRequestPermissionsResultListener(this.locationService.getLocationRequestPermissionsResultListener());
        this.activityBinding.addRequestPermissionsResultListener(this.locationService.getServiceRequestPermissionsResultListener());
        this.methodCallHandler.setLocation(this.locationService.getLocation());
        this.methodCallHandler.setLocationService(this.locationService);
        this.streamHandlerImpl.setLocation(this.locationService.getLocation());
    }

    private void dispose() {
        this.streamHandlerImpl.setLocation(null);
        this.methodCallHandler.setLocationService(null);
        this.methodCallHandler.setLocation(null);
        if (this.locationService != null) {
            this.activityBinding.removeRequestPermissionsResultListener(this.locationService.getServiceRequestPermissionsResultListener());
            this.activityBinding.removeRequestPermissionsResultListener(this.locationService.getLocationRequestPermissionsResultListener());
            this.activityBinding.removeActivityResultListener(this.locationService.getLocationActivityResultListener());
            this.locationService.setActivity(null);
            this.locationService = null;
        }
    }
}

