/*
 * Decompiled with CFR 0.152.
 */
package dev.steenbakker.mobile_scanner;

import android.app.Activity;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Size;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ExperimentalGetImage;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import dev.steenbakker.mobile_scanner.AlreadyStarted;
import dev.steenbakker.mobile_scanner.AlreadyStopped;
import dev.steenbakker.mobile_scanner.BarcodeHandler;
import dev.steenbakker.mobile_scanner.CameraError;
import dev.steenbakker.mobile_scanner.MobileScanner;
import dev.steenbakker.mobile_scanner.MobileScannerHandler;
import dev.steenbakker.mobile_scanner.MobileScannerPermissions;
import dev.steenbakker.mobile_scanner.NoCamera;
import dev.steenbakker.mobile_scanner.ZoomNotInRange;
import dev.steenbakker.mobile_scanner.ZoomWhenStopped;
import dev.steenbakker.mobile_scanner.objects.BarcodeFormats;
import dev.steenbakker.mobile_scanner.objects.DetectionSpeed;
import dev.steenbakker.mobile_scanner.objects.MobileScannerStartParameters;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.view.TextureRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u00102\u001a\u00020\r2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001bH\u0002J\u000e\u00106\u001a\u00020\r2\u0006\u00107\u001a\u000208J\u0018\u00109\u001a\u00020\r2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001bH\u0017J\u0010\u0010:\u001a\u00020\r2\u0006\u00105\u001a\u00020\u001bH\u0002J\u0018\u0010;\u001a\u00020\r2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001bH\u0002J\u0018\u0010<\u001a\u00020\r2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001bH\u0003J\u0010\u0010=\u001a\u00020\r2\u0006\u00105\u001a\u00020\u001bH\u0002J\u0018\u0010>\u001a\u00020\r2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001bH\u0002J\u0018\u0010?\u001a\u00020\r2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RC\u0010\u0011\u001a7\u0012)\u0012'\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013\u0018\u00010\u0012\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0086\u0001\u0010\u001c\u001az\u0012'\u0012%\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00130\u0012\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0015\u0012\u0013\u0018\u00010\u001e\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(!\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\r0\u001dj\u0002`#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010$\u001a!\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\r0\u000bj\u0002`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010+\u001a!\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\r0\u000bj\u0002`-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010.\u001a!\u0012\u0013\u0012\u00110/\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(0\u0012\u0004\u0012\u00020\r0\u000bj\u0002`1X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Ldev/steenbakker/mobile_scanner/MobileScannerHandler;", "Lio/flutter/plugin/common/MethodChannel$MethodCallHandler;", "activity", "Landroid/app/Activity;", "barcodeHandler", "Ldev/steenbakker/mobile_scanner/BarcodeHandler;", "binaryMessenger", "Lio/flutter/plugin/common/BinaryMessenger;", "permissions", "Ldev/steenbakker/mobile_scanner/MobileScannerPermissions;", "addPermissionListener", "Lkotlin/Function1;", "Lio/flutter/plugin/common/PluginRegistry$RequestPermissionsResultListener;", "", "textureRegistry", "Lio/flutter/view/TextureRegistry;", "(Landroid/app/Activity;Ldev/steenbakker/mobile_scanner/BarcodeHandler;Lio/flutter/plugin/common/BinaryMessenger;Ldev/steenbakker/mobile_scanner/MobileScannerPermissions;Lkotlin/jvm/functions/Function1;Lio/flutter/view/TextureRegistry;)V", "analyzerCallback", "", "", "", "", "Lkotlin/ParameterName;", "name", "barcodes", "Ldev/steenbakker/mobile_scanner/AnalyzerCallback;", "analyzerResult", "Lio/flutter/plugin/common/MethodChannel$Result;", "callback", "Lkotlin/Function4;", "", "image", "", "width", "height", "Ldev/steenbakker/mobile_scanner/MobileScannerCallback;", "errorCallback", "error", "Ldev/steenbakker/mobile_scanner/MobileScannerErrorCallback;", "methodChannel", "Lio/flutter/plugin/common/MethodChannel;", "mobileScanner", "Ldev/steenbakker/mobile_scanner/MobileScanner;", "torchStateCallback", "state", "Ldev/steenbakker/mobile_scanner/TorchStateCallback;", "zoomScaleStateCallback", "", "zoomScale", "Ldev/steenbakker/mobile_scanner/ZoomScaleStateCallback;", "analyzeImage", "call", "Lio/flutter/plugin/common/MethodCall;", "result", "dispose", "activityPluginBinding", "Lio/flutter/embedding/engine/plugins/activity/ActivityPluginBinding;", "onMethodCall", "resetScale", "setScale", "start", "stop", "toggleTorch", "updateScanWindow", "mobile_scanner_debug"})
@SourceDebugExtension(value={"SMAP\nMobileScannerHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobileScannerHandler.kt\ndev/steenbakker/mobile_scanner/MobileScannerHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,273:1\n1109#2,2:274\n*S KotlinDebug\n*F\n+ 1 MobileScannerHandler.kt\ndev/steenbakker/mobile_scanner/MobileScannerHandler\n*L\n167#1:274,2\n*E\n"})
public final class MobileScannerHandler
implements MethodChannel.MethodCallHandler {
    @NotNull
    private final Activity activity;
    @NotNull
    private final BarcodeHandler barcodeHandler;
    @NotNull
    private final MobileScannerPermissions permissions;
    @NotNull
    private final Function1<PluginRegistry.RequestPermissionsResultListener, Unit> addPermissionListener;
    @NotNull
    private final Function1<List<? extends Map<String, ? extends Object>>, Unit> analyzerCallback;
    @Nullable
    private MethodChannel.Result analyzerResult;
    @NotNull
    private final Function4<List<? extends Map<String, ? extends Object>>, byte[], Integer, Integer, Unit> callback;
    @NotNull
    private final Function1<String, Unit> errorCallback;
    @Nullable
    private MethodChannel methodChannel;
    @Nullable
    private MobileScanner mobileScanner;
    @NotNull
    private final Function1<Integer, Unit> torchStateCallback;
    @NotNull
    private final Function1<Double, Unit> zoomScaleStateCallback;

    public MobileScannerHandler(@NotNull Activity activity, @NotNull BarcodeHandler barcodeHandler, @NotNull BinaryMessenger binaryMessenger, @NotNull MobileScannerPermissions permissions, @NotNull Function1<? super PluginRegistry.RequestPermissionsResultListener, Unit> addPermissionListener, @NotNull TextureRegistry textureRegistry) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)barcodeHandler, (String)"barcodeHandler");
        Intrinsics.checkNotNullParameter((Object)binaryMessenger, (String)"binaryMessenger");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter(addPermissionListener, (String)"addPermissionListener");
        Intrinsics.checkNotNullParameter((Object)textureRegistry, (String)"textureRegistry");
        this.activity = activity;
        this.barcodeHandler = barcodeHandler;
        this.permissions = permissions;
        this.addPermissionListener = addPermissionListener;
        this.analyzerCallback = (Function1)new Function1<List<? extends Map<String, ? extends Object>>, Unit>(this){
            final /* synthetic */ MobileScannerHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable List<? extends Map<String, ? extends Object>> barcodes) {
                if (barcodes != null) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"barcode"), TuplesKt.to((Object)"data", barcodes)};
                    MobileScannerHandler.access$getBarcodeHandler$p(this.this$0).publishEvent(MapsKt.mapOf((Pair[])pairArray));
                }
                new Handler(Looper.getMainLooper()).post(() -> analyzerCallback.1.invoke$lambda$0(this.this$0, barcodes));
            }

            private static final void invoke$lambda$0(MobileScannerHandler this$0, List $barcodes) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                MethodChannel.Result result = MobileScannerHandler.access$getAnalyzerResult$p(this$0);
                if (result != null) {
                    result.success((Object)($barcodes != null ? 1 : 0));
                }
                MobileScannerHandler.access$setAnalyzerResult$p(this$0, null);
            }
        };
        this.callback = (Function4)new Function4<List<? extends Map<String, ? extends Object>>, byte[], Integer, Integer, Unit>(this){
            final /* synthetic */ MobileScannerHandler this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            public final void invoke(@NotNull List<? extends Map<String, ? extends Object>> barcodes, @Nullable byte[] image, @Nullable Integer width, @Nullable Integer height) {
                Intrinsics.checkNotNullParameter(barcodes, (String)"barcodes");
                if (image != null) {
                    BarcodeHandler barcodeHandler = MobileScannerHandler.access$getBarcodeHandler$p(this.this$0);
                    Pair[] pairArray = new Pair[5];
                    pairArray[0] = TuplesKt.to((Object)"name", (Object)"barcode");
                    pairArray[1] = TuplesKt.to((Object)"data", barcodes);
                    pairArray[2] = TuplesKt.to((Object)"image", (Object)image);
                    Integer n = width;
                    Intrinsics.checkNotNull((Object)n);
                    pairArray[3] = TuplesKt.to((Object)"width", (Object)n);
                    Integer n2 = height;
                    Intrinsics.checkNotNull((Object)n2);
                    pairArray[4] = TuplesKt.to((Object)"height", (Object)n2);
                    barcodeHandler.publishEvent(MapsKt.mapOf((Pair[])pairArray));
                } else {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"barcode"), TuplesKt.to((Object)"data", barcodes)};
                    MobileScannerHandler.access$getBarcodeHandler$p(this.this$0).publishEvent(MapsKt.mapOf((Pair[])pairArray));
                }
            }
        };
        this.errorCallback = (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ MobileScannerHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"error"), TuplesKt.to((Object)"data", (Object)error)};
                MobileScannerHandler.access$getBarcodeHandler$p(this.this$0).publishEvent(MapsKt.mapOf((Pair[])pairArray));
            }
        };
        this.torchStateCallback = (Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ MobileScannerHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int state) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"torchState"), TuplesKt.to((Object)"data", (Object)state)};
                MobileScannerHandler.access$getBarcodeHandler$p(this.this$0).publishEvent(MapsKt.mapOf((Pair[])pairArray));
            }
        };
        this.zoomScaleStateCallback = (Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ MobileScannerHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(double zoomScale) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"zoomScaleState"), TuplesKt.to((Object)"data", (Object)zoomScale)};
                MobileScannerHandler.access$getBarcodeHandler$p(this.this$0).publishEvent(MapsKt.mapOf((Pair[])pairArray));
            }
        };
        MethodChannel methodChannel = this.methodChannel = new MethodChannel(binaryMessenger, "dev.steenbakker.mobile_scanner/scanner/method");
        Intrinsics.checkNotNull((Object)methodChannel);
        methodChannel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        this.mobileScanner = new MobileScanner(this.activity, textureRegistry, this.callback, this.errorCallback);
    }

    public final void dispose(@NotNull ActivityPluginBinding activityPluginBinding) {
        Intrinsics.checkNotNullParameter((Object)activityPluginBinding, (String)"activityPluginBinding");
        MethodChannel methodChannel = this.methodChannel;
        if (methodChannel != null) {
            methodChannel.setMethodCallHandler(null);
        }
        this.methodChannel = null;
        this.mobileScanner = null;
        PluginRegistry.RequestPermissionsResultListener listener = this.permissions.getPermissionListener();
        if (listener != null) {
            activityPluginBinding.removeRequestPermissionsResultListener(listener);
        }
    }

    /*
     * Unable to fully structure code
     */
    @ExperimentalGetImage
    public void onMethodCall(@NotNull MethodCall call, @NotNull MethodChannel.Result result) {
        block27: {
            block19: {
                block23: {
                    block25: {
                        block22: {
                            block20: {
                                block21: {
                                    block26: {
                                        block24: {
                                            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                                            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                                            if (this.mobileScanner == null) {
                                                result.error("MobileScanner", "Called " + call.method + " before initializing.", null);
                                                return;
                                            }
                                            var3_3 = call.method;
                                            if (var3_3 == null) break block19;
                                            switch (var3_3.hashCode()) {
                                                case 1095692943: {
                                                    if (var3_3.equals("request")) break;
                                                    ** break;
                                                }
                                                case 16698223: {
                                                    if (!var3_3.equals("analyzeImage")) {
                                                        ** break;
                                                    }
                                                    break block20;
                                                }
                                                case 3540994: {
                                                    if (!var3_3.equals("stop")) {
                                                        ** break;
                                                    }
                                                    break block21;
                                                }
                                                case 1403963912: {
                                                    if (!var3_3.equals("setScale")) {
                                                        ** break;
                                                    }
                                                    break block22;
                                                }
                                                case 2023844470: {
                                                    if (!var3_3.equals("updateScanWindow")) {
                                                        ** break;
                                                    }
                                                    break block23;
                                                }
                                                case 109757538: {
                                                    if (!var3_3.equals("start")) {
                                                        ** break;
                                                    }
                                                    break block24;
                                                }
                                                case -1688013509: {
                                                    if (!var3_3.equals("resetScale")) {
                                                        ** break;
                                                    }
                                                    break block25;
                                                }
                                                case 110547964: {
                                                    if (!var3_3.equals("torch")) {
                                                        ** break;
                                                    }
                                                    break block26;
                                                }
                                                case 109757585: {
                                                    if (!var3_3.equals("state")) ** break;
                                                    result.success((Object)this.permissions.hasCameraPermission(this.activity));
                                                    break block27;
                                                }
                                            }
                                            this.permissions.requestPermission(this.activity, this.addPermissionListener, new MobileScannerPermissions.ResultCallback(result){
                                                final /* synthetic */ MethodChannel.Result $result;
                                                {
                                                    this.$result = $result;
                                                }

                                                public void onResult(@Nullable String errorCode, @Nullable String errorDescription) {
                                                    String string = errorCode;
                                                    if (string == null) {
                                                        this.$result.success((Object)true);
                                                    } else if (Intrinsics.areEqual((Object)string, (Object)"CameraAccessDenied")) {
                                                        this.$result.success((Object)false);
                                                    } else {
                                                        this.$result.error(errorCode, errorDescription, null);
                                                    }
                                                }
                                            });
                                            break block27;
                                        }
                                        this.start(call, result);
                                        break block27;
                                    }
                                    this.toggleTorch(call, result);
                                    break block27;
                                }
                                this.stop(result);
                                break block27;
                            }
                            this.analyzeImage(call, result);
                            break block27;
                        }
                        this.setScale(call, result);
                        break block27;
                    }
                    this.resetScale(result);
                    break block27;
                }
                this.updateScanWindow(call, result);
                break block27;
            }
            result.notImplemented();
        }
    }

    @ExperimentalGetImage
    private final void start(MethodCall call, MethodChannel.Result result) {
        DetectionSpeed element$iv;
        CameraSelector position;
        BarcodeScannerOptions barcodeScannerOptions;
        Size cameraResolution;
        boolean useNewCameraSelector;
        int timeout;
        boolean returnImage;
        boolean torch;
        block6: {
            Boolean bl = (Boolean)call.argument("torch");
            torch = bl == null ? false : bl;
            Integer n = (Integer)call.argument("facing");
            int facing = n == null ? 0 : n;
            List formats = (List)call.argument("formats");
            Boolean bl2 = (Boolean)call.argument("returnImage");
            returnImage = bl2 == null ? false : bl2;
            Integer n2 = (Integer)call.argument("speed");
            int speed = n2 == null ? 1 : n2;
            Integer n3 = (Integer)call.argument("timeout");
            timeout = n3 == null ? 250 : n3;
            List cameraResolutionValues = (List)call.argument("cameraResolution");
            Boolean bl3 = (Boolean)call.argument("useNewCameraSelector");
            useNewCameraSelector = bl3 == null ? false : bl3;
            cameraResolution = cameraResolutionValues != null ? new Size(((Number)cameraResolutionValues.get(0)).intValue(), ((Number)cameraResolutionValues.get(1)).intValue()) : null;
            barcodeScannerOptions = null;
            if (formats != null) {
                BarcodeScannerOptions barcodeScannerOptions2;
                List formatsList = new ArrayList();
                Object object = formats.iterator();
                while (object.hasNext()) {
                    int formatValue = ((Number)object.next()).intValue();
                    formatsList.add(BarcodeFormats.Companion.fromRawValue(formatValue).getIntValue());
                }
                if (formatsList.size() == 1) {
                    barcodeScannerOptions2 = new BarcodeScannerOptions.Builder().setBarcodeFormats(((Number)CollectionsKt.first((List)formatsList)).intValue(), new int[0]).build();
                } else {
                    object = CollectionsKt.toIntArray((Collection)formatsList.subList(1, formatsList.size()));
                    barcodeScannerOptions2 = new BarcodeScannerOptions.Builder().setBarcodeFormats(((Number)CollectionsKt.first((List)formatsList)).intValue(), Arrays.copyOf((int[])object, ((Object)object).length)).build();
                }
                barcodeScannerOptions = barcodeScannerOptions2;
            }
            CameraSelector cameraSelector = facing == 0 ? CameraSelector.DEFAULT_FRONT_CAMERA : CameraSelector.DEFAULT_BACK_CAMERA;
            Intrinsics.checkNotNullExpressionValue((Object)cameraSelector, (String)"if (facing == 0) CameraS\u2026ector.DEFAULT_BACK_CAMERA");
            position = cameraSelector;
            DetectionSpeed[] $this$first$iv = DetectionSpeed.values();
            boolean $i$f$first = false;
            int n4 = $this$first$iv.length;
            for (int i = 0; i < n4; ++i) {
                DetectionSpeed it = element$iv = $this$first$iv[i];
                boolean bl4 = false;
                if (!(it.getIntValue() == speed)) {
                    continue;
                }
                break block6;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        DetectionSpeed detectionSpeed = element$iv;
        MobileScanner mobileScanner = this.mobileScanner;
        Intrinsics.checkNotNull((Object)mobileScanner);
        mobileScanner.start(barcodeScannerOptions, returnImage, position, torch, detectionSpeed, this.torchStateCallback, this.zoomScaleStateCallback, (Function1<? super MobileScannerStartParameters, Unit>)((Function1)new Function1<MobileScannerStartParameters, Unit>(result){
            final /* synthetic */ MethodChannel.Result $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull MobileScannerStartParameters it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                new Handler(Looper.getMainLooper()).post(() -> start.1.invoke$lambda$0(this.$result, it));
            }

            private static final void invoke$lambda$0(MethodChannel.Result $result, MobileScannerStartParameters $it) {
                Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                Pair[] pairArray = new Pair[4];
                pairArray[0] = TuplesKt.to((Object)"textureId", (Object)$it.getId());
                Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"width", (Object)$it.getWidth()), TuplesKt.to((Object)"height", (Object)$it.getHeight())};
                pairArray[1] = TuplesKt.to((Object)"size", (Object)MapsKt.mapOf((Pair[])pairArray2));
                pairArray[2] = TuplesKt.to((Object)"torchable", (Object)$it.getHasFlashUnit());
                pairArray[3] = TuplesKt.to((Object)"numberOfCameras", (Object)$it.getNumberOfCameras());
                $result.success((Object)MapsKt.mapOf((Pair[])pairArray));
            }
        }), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(result){
            final /* synthetic */ MethodChannel.Result $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull Exception it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                new Handler(Looper.getMainLooper()).post(() -> start.2.invoke$lambda$0(it, this.$result));
            }

            private static final void invoke$lambda$0(Exception $it, MethodChannel.Result $result) {
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
                Exception exception = $it;
                if (exception instanceof AlreadyStarted) {
                    $result.error("MobileScanner", "Called start() while already started", null);
                } else if (exception instanceof CameraError) {
                    $result.error("MobileScanner", "Error occurred when setting up camera!", null);
                } else if (exception instanceof NoCamera) {
                    $result.error("MobileScanner", "No camera found or failed to open camera!", null);
                } else {
                    $result.error("MobileScanner", "Unknown error occurred.", null);
                }
            }
        }), timeout, cameraResolution, useNewCameraSelector);
    }

    private final void stop(MethodChannel.Result result) {
        try {
            MobileScanner mobileScanner = this.mobileScanner;
            Intrinsics.checkNotNull((Object)mobileScanner);
            mobileScanner.stop();
            result.success(null);
        }
        catch (AlreadyStopped e) {
            result.success(null);
        }
    }

    private final void analyzeImage(MethodCall call, MethodChannel.Result result) {
        this.analyzerResult = result;
        Uri uri = Uri.fromFile((File)new File(call.arguments.toString()));
        MobileScanner mobileScanner = this.mobileScanner;
        Intrinsics.checkNotNull((Object)mobileScanner);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        mobileScanner.analyzeImage(uri, this.analyzerCallback);
    }

    private final void toggleTorch(MethodCall call, MethodChannel.Result result) {
        MobileScanner mobileScanner = this.mobileScanner;
        Intrinsics.checkNotNull((Object)mobileScanner);
        mobileScanner.toggleTorch(Intrinsics.areEqual((Object)call.arguments, (Object)1));
        result.success(null);
    }

    private final void setScale(MethodCall call, MethodChannel.Result result) {
        try {
            MobileScanner mobileScanner = this.mobileScanner;
            Intrinsics.checkNotNull((Object)mobileScanner);
            Object object = call.arguments;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            mobileScanner.setScale((Double)object);
            result.success(null);
        }
        catch (ZoomWhenStopped e) {
            result.error("MobileScanner", "Called setScale() while stopped!", null);
        }
        catch (ZoomNotInRange e) {
            result.error("MobileScanner", "Scale should be within 0 and 1", null);
        }
    }

    private final void resetScale(MethodChannel.Result result) {
        try {
            MobileScanner mobileScanner = this.mobileScanner;
            Intrinsics.checkNotNull((Object)mobileScanner);
            mobileScanner.resetScale();
            result.success(null);
        }
        catch (ZoomWhenStopped e) {
            result.error("MobileScanner", "Called resetScale() while stopped!", null);
        }
    }

    private final void updateScanWindow(MethodCall call, MethodChannel.Result result) {
        MobileScanner mobileScanner = this.mobileScanner;
        Intrinsics.checkNotNull((Object)mobileScanner);
        mobileScanner.setScanWindow((List)call.argument("rect"));
        result.success(null);
    }

    public static final /* synthetic */ BarcodeHandler access$getBarcodeHandler$p(MobileScannerHandler $this) {
        return $this.barcodeHandler;
    }

    public static final /* synthetic */ MethodChannel.Result access$getAnalyzerResult$p(MobileScannerHandler $this) {
        return $this.analyzerResult;
    }

    public static final /* synthetic */ void access$setAnalyzerResult$p(MobileScannerHandler $this, MethodChannel.Result result) {
        $this.analyzerResult = result;
    }
}

