/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.sharedpreferences;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.preference.PreferenceManager;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugins.sharedpreferences.ListEncoder;
import io.flutter.plugins.sharedpreferences.SharedPreferencesAsyncApi;
import io.flutter.plugins.sharedpreferences.SharedPreferencesListEncoder;
import io.flutter.plugins.sharedpreferences.SharedPreferencesPigeonOptions;
import io.flutter.plugins.sharedpreferences.SharedPreferencesPluginKt;
import io.flutter.plugins.sharedpreferences.StringListLookupResultType;
import io.flutter.plugins.sharedpreferences.StringListResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00140\u00132\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001f\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010 \u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010$\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010&\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J \u0010'\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010(\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010)\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010*\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010+\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/flutter/plugins/sharedpreferences/SharedPreferencesBackend;", "Lio/flutter/plugins/sharedpreferences/SharedPreferencesAsyncApi;", "messenger", "Lio/flutter/plugin/common/BinaryMessenger;", "context", "Landroid/content/Context;", "listEncoder", "Lio/flutter/plugins/sharedpreferences/SharedPreferencesListEncoder;", "(Lio/flutter/plugin/common/BinaryMessenger;Landroid/content/Context;Lio/flutter/plugins/sharedpreferences/SharedPreferencesListEncoder;)V", "clear", "", "allowList", "", "", "options", "Lio/flutter/plugins/sharedpreferences/SharedPreferencesPigeonOptions;", "createSharedPreferences", "Landroid/content/SharedPreferences;", "getAll", "", "", "getBool", "", "key", "(Ljava/lang/String;Lio/flutter/plugins/sharedpreferences/SharedPreferencesPigeonOptions;)Ljava/lang/Boolean;", "getDouble", "", "(Ljava/lang/String;Lio/flutter/plugins/sharedpreferences/SharedPreferencesPigeonOptions;)Ljava/lang/Double;", "getInt", "", "(Ljava/lang/String;Lio/flutter/plugins/sharedpreferences/SharedPreferencesPigeonOptions;)Ljava/lang/Long;", "getKeys", "getPlatformEncodedStringList", "getString", "getStringList", "Lio/flutter/plugins/sharedpreferences/StringListResult;", "setBool", "value", "setDeprecatedStringList", "setDouble", "setEncodedStringList", "setInt", "setString", "tearDown", "shared_preferences_android_release"})
@SourceDebugExtension(value={"SMAP\nSharedPreferencesPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedPreferencesPlugin.kt\nio/flutter/plugins/sharedpreferences/SharedPreferencesBackend\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,514:1\n1#2:515\n800#3,11:516\n526#4:527\n511#4,6:528\n*S KotlinDebug\n*F\n+ 1 SharedPreferencesPlugin.kt\nio/flutter/plugins/sharedpreferences/SharedPreferencesBackend\n*L\n447#1:516,11\n460#1:527\n460#1:528,6\n*E\n"})
public final class SharedPreferencesBackend
implements SharedPreferencesAsyncApi {
    @NotNull
    private BinaryMessenger messenger;
    @NotNull
    private Context context;
    @NotNull
    private SharedPreferencesListEncoder listEncoder;

    public SharedPreferencesBackend(@NotNull BinaryMessenger messenger, @NotNull Context context, @NotNull SharedPreferencesListEncoder listEncoder) {
        Intrinsics.checkNotNullParameter((Object)messenger, (String)"messenger");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listEncoder, (String)"listEncoder");
        this.messenger = messenger;
        this.context = context;
        this.listEncoder = listEncoder;
        try {
            SharedPreferencesAsyncApi.Companion.setUp(this.messenger, this, "shared_preferences");
        }
        catch (Exception ex) {
            Log.e((String)"SharedPreferencesPlugin", (String)"Received exception while setting up SharedPreferencesBackend", (Throwable)ex);
        }
    }

    public /* synthetic */ SharedPreferencesBackend(BinaryMessenger binaryMessenger, Context context, SharedPreferencesListEncoder sharedPreferencesListEncoder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            sharedPreferencesListEncoder = new ListEncoder();
        }
        this(binaryMessenger, context, sharedPreferencesListEncoder);
    }

    public final void tearDown() {
        SharedPreferencesAsyncApi.Companion.setUp(this.messenger, null, "shared_preferences");
    }

    private final SharedPreferences createSharedPreferences(SharedPreferencesPigeonOptions options) {
        SharedPreferences sharedPreferences;
        if (options.getFileName() == null) {
            SharedPreferences sharedPreferences2 = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
            sharedPreferences = sharedPreferences2;
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences2, (String)"{\n      PreferenceManage\u2026references(context)\n    }");
        } else {
            SharedPreferences sharedPreferences3 = this.context.getSharedPreferences(options.getFileName(), 0);
            sharedPreferences = sharedPreferences3;
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences3, (String)"{\n      context.getShare\u2026ntext.MODE_PRIVATE)\n    }");
        }
        return sharedPreferences;
    }

    @Override
    public void setBool(@NotNull String key, boolean value, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.createSharedPreferences(options).edit().putBoolean(key, value).apply();
    }

    @Override
    public void setString(@NotNull String key, @NotNull String value, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.createSharedPreferences(options).edit().putString(key, value).apply();
    }

    @Override
    public void setInt(@NotNull String key, long value, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.createSharedPreferences(options).edit().putLong(key, value).apply();
    }

    @Override
    public void setDouble(@NotNull String key, double value, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.createSharedPreferences(options).edit().putString(key, "VGhpcyBpcyB0aGUgcHJlZml4IGZvciBEb3VibGUu" + value).apply();
    }

    @Override
    public void setEncodedStringList(@NotNull String key, @NotNull String value, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.createSharedPreferences(options).edit().putString(key, value).apply();
    }

    @Override
    @Deprecated(message="This is just for testing, use `setEncodedStringList`")
    public void setDeprecatedStringList(@NotNull String key, @NotNull List<String> value, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String valueString = "VGhpcyBpcyB0aGUgcHJlZml4IGZvciBhIGxpc3Qu" + this.listEncoder.encode(value);
        this.createSharedPreferences(options).edit().putString(key, valueString).apply();
    }

    @Override
    public void clear(@Nullable List<String> allowList, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        SharedPreferences preferences = this.createSharedPreferences(options);
        SharedPreferences.Editor editor = preferences.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"preferences.edit()");
        SharedPreferences.Editor clearEditor = editor;
        Map map2 = preferences.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"preferences.all");
        Map allPrefs = map2;
        ArrayList<String> filteredPrefs = new ArrayList<String>();
        for (String key : allPrefs.keySet()) {
            List<String> list = allowList;
            if (!SharedPreferencesPluginKt.preferencesFilter(key, allPrefs.get(key), list != null ? CollectionsKt.toSet((Iterable)list) : null)) continue;
            filteredPrefs.add(key);
        }
        for (String key : filteredPrefs) {
            clearEditor.remove(key);
        }
        clearEditor.apply();
    }

    @Override
    @NotNull
    public Map<String, Object> getAll(@Nullable List<String> allowList, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        SharedPreferences preferences = this.createSharedPreferences(options);
        Map map2 = preferences.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"preferences.all");
        Map allPrefs = map2;
        HashMap filteredPrefs = new HashMap();
        for (Map.Entry entry : allPrefs.entrySet()) {
            Object it;
            List<String> list = allowList;
            if (!SharedPreferencesPluginKt.preferencesFilter((String)entry.getKey(), entry.getValue(), list != null ? CollectionsKt.toSet((Iterable)list) : null)) continue;
            if (entry.getValue() == null) continue;
            boolean bl = false;
            Object k = entry.getKey();
            Object object = SharedPreferencesPluginKt.transformPref(it, this.listEncoder);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
            filteredPrefs.put(k, object);
        }
        return filteredPrefs;
    }

    @Override
    @Nullable
    public Long getInt(@NotNull String key, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        SharedPreferences preferences = this.createSharedPreferences(options);
        return preferences.contains(key) ? Long.valueOf(preferences.getLong(key, 0L)) : null;
    }

    @Override
    @Nullable
    public Boolean getBool(@NotNull String key, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        SharedPreferences preferences = this.createSharedPreferences(options);
        return preferences.contains(key) ? Boolean.valueOf(preferences.getBoolean(key, true)) : null;
    }

    @Override
    @Nullable
    public Double getDouble(@NotNull String key, @NotNull SharedPreferencesPigeonOptions options) {
        Double d;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        SharedPreferences preferences = this.createSharedPreferences(options);
        if (preferences.contains(key)) {
            Object object = SharedPreferencesPluginKt.transformPref(preferences.getString(key, ""), this.listEncoder);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            d = (Double)object;
        } else {
            d = null;
        }
        return d;
    }

    @Override
    @Nullable
    public String getString(@NotNull String key, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        SharedPreferences preferences = this.createSharedPreferences(options);
        return preferences.contains(key) ? preferences.getString(key, "") : null;
    }

    @Override
    @Nullable
    public StringListResult getStringList(@NotNull String key, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        SharedPreferences preferences = this.createSharedPreferences(options);
        if (preferences.contains(key)) {
            String value;
            String string = value = preferences.getString(key, "");
            Intrinsics.checkNotNull((Object)string);
            return StringsKt.startsWith$default((String)string, (String)"VGhpcyBpcyB0aGUgcHJlZml4IGZvciBhIGxpc3Qu!", (boolean)false, (int)2, null) ? new StringListResult(value, StringListLookupResultType.JSON_ENCODED) : (StringsKt.startsWith$default((String)value, (String)"VGhpcyBpcyB0aGUgcHJlZml4IGZvciBhIGxpc3Qu", (boolean)false, (int)2, null) ? new StringListResult(null, StringListLookupResultType.PLATFORM_ENCODED) : new StringListResult(null, StringListLookupResultType.UNEXPECTED_STRING));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<String> getPlatformEncodedStringList(@NotNull String key, @NotNull SharedPreferencesPigeonOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        SharedPreferences preferences = this.createSharedPreferences(options);
        if (preferences.contains(key)) {
            String value;
            String string = value = preferences.getString(key, "");
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.startsWith$default((String)string, (String)"VGhpcyBpcyB0aGUgcHJlZml4IGZvciBhIGxpc3Qu", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)value, (String)"VGhpcyBpcyB0aGUgcHJlZml4IGZvciBhIGxpc3Qu!", (boolean)false, (int)2, null)) {
                List list;
                Object transformed = SharedPreferencesPluginKt.transformPref(preferences.getString(key, ""), this.listEncoder);
                List list2 = (List)transformed;
                if (list2 != null) {
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv = list2;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof String)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = null;
                }
                return list;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getKeys(@Nullable List<String> allowList, @NotNull SharedPreferencesPigeonOptions options) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        SharedPreferences preferences = this.createSharedPreferences(options);
        Map map2 = preferences.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"preferences.all");
        Map map3 = map2;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            List<String> list = allowList;
            if (!SharedPreferencesPluginKt.preferencesFilter((String)k, it.getValue(), list != null ? CollectionsKt.toSet((Iterable)list) : null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.keySet());
    }
}

