/*
 * Decompiled with CFR 0.152.
 */
package com.tekartik.sqflite;

import android.os.Handler;
import android.os.HandlerThread;
import com.tekartik.sqflite.DatabaseTask;

class DatabaseWorker {
    private final String name;
    private final int priority;
    private HandlerThread handlerThread;
    private Handler handler;
    protected Runnable onIdle;
    private DatabaseTask lastTask;

    DatabaseWorker(String name, int priority) {
        this.name = name;
        this.priority = priority;
    }

    synchronized void start(Runnable onIdle) {
        this.handlerThread = new HandlerThread(this.name, this.priority);
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
        this.onIdle = onIdle;
    }

    synchronized void quit() {
        if (this.handlerThread != null) {
            this.handlerThread.quit();
            this.handlerThread = null;
            this.handler = null;
        }
    }

    boolean isLastTaskInTransaction() {
        return this.lastTask != null && this.lastTask.isInTransaction();
    }

    Integer lastTaskDatabaseId() {
        return this.lastTask != null ? this.lastTask.getDatabaseId() : null;
    }

    void postTask(DatabaseTask task) {
        this.handler.post(() -> this.work(task));
    }

    void work(DatabaseTask task) {
        task.runnable.run();
        this.lastTask = task;
        this.onIdle.run();
    }
}

