/*
 * Decompiled with CFR 0.152.
 */
package com.tekartik.sqflite;

import com.tekartik.sqflite.DatabaseTask;
import com.tekartik.sqflite.DatabaseWorker;
import com.tekartik.sqflite.DatabaseWorkerPool;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class DatabaseWorkerPoolImpl
implements DatabaseWorkerPool {
    final String name;
    final int numberOfWorkers;
    final int priority;
    private final LinkedList<DatabaseTask> waitingList = new LinkedList();
    private final Set<DatabaseWorker> idleWorkers = new HashSet<DatabaseWorker>();
    private final Set<DatabaseWorker> busyWorkers = new HashSet<DatabaseWorker>();
    private final Map<Integer, DatabaseWorker> onlyEligibleWorkers = new HashMap<Integer, DatabaseWorker>();

    DatabaseWorkerPoolImpl(String name, int numberOfWorkers, int priority) {
        this.name = name;
        this.numberOfWorkers = numberOfWorkers;
        this.priority = priority;
    }

    @Override
    public synchronized void start() {
        for (int i = 0; i < this.numberOfWorkers; ++i) {
            DatabaseWorker worker = this.createWorker(this.name + i, this.priority);
            worker.start(() -> this.onWorkerIdle(worker));
            this.idleWorkers.add(worker);
        }
    }

    protected DatabaseWorker createWorker(String name, int priority) {
        return new DatabaseWorker(name, priority);
    }

    @Override
    public synchronized void quit() {
        for (DatabaseWorker worker : this.idleWorkers) {
            worker.quit();
        }
        for (DatabaseWorker worker : this.busyWorkers) {
            worker.quit();
        }
    }

    @Override
    public synchronized void post(DatabaseTask task) {
        this.waitingList.add(task);
        HashSet<DatabaseWorker> workers = new HashSet<DatabaseWorker>(this.idleWorkers);
        for (DatabaseWorker worker : workers) {
            this.tryPostingTaskToWorker(worker);
        }
    }

    private synchronized void tryPostingTaskToWorker(DatabaseWorker worker) {
        DatabaseTask task = this.findTaskForWorker(worker);
        if (task != null) {
            this.busyWorkers.add(worker);
            this.idleWorkers.remove(worker);
            if (task.getDatabaseId() != null) {
                this.onlyEligibleWorkers.put(task.getDatabaseId(), worker);
            }
            worker.postTask(task);
        }
    }

    private synchronized DatabaseTask findTaskForWorker(DatabaseWorker worker) {
        ListIterator iter = this.waitingList.listIterator();
        while (iter.hasNext()) {
            DatabaseTask task = (DatabaseTask)iter.next();
            DatabaseWorker onlyEligibleWorker = null;
            if (task.getDatabaseId() != null) {
                onlyEligibleWorker = this.onlyEligibleWorkers.get(task.getDatabaseId());
            }
            if (onlyEligibleWorker != null && onlyEligibleWorker != worker) continue;
            iter.remove();
            return task;
        }
        return null;
    }

    private synchronized void onWorkerIdle(DatabaseWorker worker) {
        HashSet<DatabaseWorker> others = new HashSet<DatabaseWorker>(this.idleWorkers);
        this.busyWorkers.remove(worker);
        this.idleWorkers.add(worker);
        if (!worker.isLastTaskInTransaction() && worker.lastTaskDatabaseId() != null) {
            this.onlyEligibleWorkers.remove(worker.lastTaskDatabaseId());
        }
        this.tryPostingTaskToWorker(worker);
        for (DatabaseWorker other : others) {
            this.tryPostingTaskToWorker(other);
        }
    }
}

