/*
 * Decompiled with CFR 0.152.
 */
package com.tekartik.sqflite;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.tekartik.sqflite.Database;
import com.tekartik.sqflite.DatabaseWorkerPool;
import com.tekartik.sqflite.LogLevel;
import com.tekartik.sqflite.Utils;
import com.tekartik.sqflite.dev.Debug;
import com.tekartik.sqflite.operation.MethodCallOperation;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.MethodCodec;
import io.flutter.plugin.common.StandardMethodCodec;
import java.io.File;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SqflitePlugin
implements FlutterPlugin,
MethodChannel.MethodCallHandler {
    static final Map<String, Integer> _singleInstancesByPath = new HashMap<String, Integer>();
    @SuppressLint(value={"UseSparseArrays"})
    static final Map<Integer, Database> databaseMap = new HashMap<Integer, Database>();
    private static final Object databaseMapLocker = new Object();
    private static final Object openCloseLocker = new Object();
    static int logLevel = 0;
    static String databasesPath;
    private static int THREAD_PRIORITY;
    private static int THREAD_COUNT;
    private static int databaseId;
    private static DatabaseWorkerPool databaseWorkerPool;
    private Context context;
    private MethodChannel methodChannel;

    public SqflitePlugin() {
    }

    public SqflitePlugin(Context context) {
        this.context = context.getApplicationContext();
    }

    private static Map<String, Object> fixMap(Map<Object, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Map<String, Object> value = entry.getValue();
            if (value instanceof Map) {
                Map mapValue = value;
                value = SqflitePlugin.fixMap(mapValue);
            } else {
                value = SqflitePlugin.toString(value);
            }
            newMap.put(SqflitePlugin.toString(entry.getKey()), value);
        }
        return newMap;
    }

    private static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (byte _byte : (byte[])value) {
                list.add(Integer.valueOf(_byte));
            }
            return ((Object)list).toString();
        }
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            return SqflitePlugin.fixMap(mapValue).toString();
        }
        return value.toString();
    }

    static boolean isInMemoryPath(String path) {
        return path == null || path.equals(":memory:");
    }

    static Map makeOpenResult(int databaseId, boolean recovered, boolean recoveredInTransaction) {
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        result.put("id", Integer.valueOf(databaseId));
        if (recovered) {
            result.put("recovered", Boolean.valueOf(true));
        }
        if (recoveredInTransaction) {
            result.put("recoveredInTransaction", Boolean.valueOf(true));
        }
        return result;
    }

    public void onAttachedToEngine(FlutterPlugin.FlutterPluginBinding binding) {
        this.onAttachedToEngine(binding.getApplicationContext(), binding.getBinaryMessenger());
    }

    private void onAttachedToEngine(Context applicationContext, BinaryMessenger messenger) {
        this.context = applicationContext;
        this.methodChannel = new MethodChannel(messenger, "com.tekartik.sqflite", (MethodCodec)StandardMethodCodec.INSTANCE, messenger.makeBackgroundTaskQueue());
        this.methodChannel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
    }

    public void onDetachedFromEngine(FlutterPlugin.FlutterPluginBinding binding) {
        this.context = null;
        this.methodChannel.setMethodCallHandler(null);
        this.methodChannel = null;
    }

    private Context getContext() {
        return this.context;
    }

    private Database getDatabase(int databaseId) {
        return databaseMap.get(databaseId);
    }

    private Database getDatabaseOrError(MethodCall call, MethodChannel.Result result) {
        int databaseId = (Integer)call.argument("id");
        Database database = this.getDatabase(databaseId);
        if (database != null) {
            return database;
        }
        result.error("sqlite_error", "database_closed " + databaseId, null);
        return null;
    }

    private void onQueryCall(MethodCall call, MethodChannel.Result result) {
        Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        databaseWorkerPool.post(database, () -> {
            MethodCallOperation operation = new MethodCallOperation(call, result);
            database.query(operation);
        });
    }

    private void onQueryCursorNextCall(MethodCall call, MethodChannel.Result result) {
        Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        databaseWorkerPool.post(database, () -> {
            MethodCallOperation operation = new MethodCallOperation(call, result);
            database.queryCursorNext(operation);
        });
    }

    private void onBatchCall(MethodCall call, MethodChannel.Result result) {
        Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        databaseWorkerPool.post(database, () -> database.batch(call, result));
    }

    private void onInsertCall(MethodCall call, MethodChannel.Result result) {
        Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        databaseWorkerPool.post(database, () -> {
            MethodCallOperation operation = new MethodCallOperation(call, result);
            database.insert(operation);
        });
    }

    private void onExecuteCall(MethodCall call, MethodChannel.Result result) {
        Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        databaseWorkerPool.post(database, () -> {
            MethodCallOperation operation = new MethodCallOperation(call, result);
            database.execute(operation);
        });
    }

    private void onSetLocaleCall(MethodCall call, MethodChannel.Result result) {
        Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        databaseWorkerPool.post(database, () -> {
            String localeString = (String)call.argument("locale");
            try {
                database.sqliteDatabase.setLocale(Utils.localeForLanguateTag(localeString));
                result.success(null);
            }
            catch (Exception exception) {
                result.error("sqlite_error", "Error calling setLocale: " + exception.getMessage(), null);
            }
        });
    }

    private void onUpdateCall(MethodCall call, MethodChannel.Result result) {
        Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        databaseWorkerPool.post(database, () -> {
            MethodCallOperation operation = new MethodCallOperation(call, result);
            database.update(operation);
        });
    }

    private void onDebugCall(MethodCall call, MethodChannel.Result result) {
        String cmd = (String)call.argument("cmd");
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        if ("get".equals(cmd)) {
            if (logLevel > 0) {
                map.put("logLevel", Integer.valueOf(logLevel));
            }
            if (!databaseMap.isEmpty()) {
                HashMap databasesInfo = new HashMap();
                for (Map.Entry<Integer, Database> entry : databaseMap.entrySet()) {
                    Database database = entry.getValue();
                    HashMap<String, Object> info = new HashMap<String, Object>();
                    info.put("path", database.path);
                    info.put("singleInstance", database.singleInstance);
                    if (database.logLevel > 0) {
                        info.put("logLevel", database.logLevel);
                    }
                    databasesInfo.put(entry.getKey().toString(), info);
                }
                map.put("databases", databasesInfo);
            }
        }
        result.success(map);
    }

    private void onDebugModeCall(MethodCall call, MethodChannel.Result result) {
        Object on = call.arguments();
        Debug.LOGV = Boolean.TRUE.equals(on);
        boolean bl = Debug.EXTRA_LOGV = Debug._EXTRA_LOGV && Debug.LOGV;
        if (Debug.LOGV) {
            if (Debug.EXTRA_LOGV) {
                logLevel = 2;
            } else if (Debug.LOGV) {
                logLevel = 1;
            }
        } else {
            logLevel = 0;
        }
        result.success(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOpenDatabaseCall(MethodCall call, MethodChannel.Result result) {
        int newDatabaseId;
        Database database;
        Object databaseId;
        boolean singleInstance;
        String path = (String)call.argument("path");
        Boolean readOnly = (Boolean)call.argument("readOnly");
        boolean inMemory = SqflitePlugin.isInMemoryPath(path);
        boolean bl = singleInstance = !Boolean.FALSE.equals(call.argument("singleInstance")) && !inMemory;
        if (singleInstance) {
            Object object = databaseMapLocker;
            synchronized (object) {
                if (LogLevel.hasVerboseLevel(logLevel)) {
                    Log.d((String)"Sqflite", (String)("Look for " + path + " in " + _singleInstancesByPath.keySet()));
                }
                if ((databaseId = _singleInstancesByPath.get(path)) != null && (database = databaseMap.get(databaseId)) != null) {
                    if (!database.sqliteDatabase.isOpen()) {
                        if (LogLevel.hasVerboseLevel(logLevel)) {
                            Log.d((String)"Sqflite", (String)(database.getThreadLogPrefix() + "single instance database of " + path + " not opened"));
                        }
                    } else {
                        if (LogLevel.hasVerboseLevel(logLevel)) {
                            Log.d((String)"Sqflite", (String)(database.getThreadLogPrefix() + "re-opened single instance " + (database.isInTransaction() ? "(in transaction) " : "") + databaseId + " " + path));
                        }
                        result.success((Object)SqflitePlugin.makeOpenResult((Integer)databaseId, true, database.isInTransaction()));
                        return;
                    }
                }
            }
        }
        databaseId = databaseMapLocker;
        synchronized (databaseId) {
            newDatabaseId = ++SqflitePlugin.databaseId;
        }
        int databaseId2 = newDatabaseId;
        database = new Database(this.context, path, databaseId2, singleInstance, logLevel);
        Object object = databaseMapLocker;
        synchronized (object) {
            if (databaseWorkerPool == null) {
                databaseWorkerPool = DatabaseWorkerPool.create("Sqflite", THREAD_COUNT, THREAD_PRIORITY);
                databaseWorkerPool.start();
                if (LogLevel.hasSqlLevel(database.logLevel)) {
                    Log.d((String)"Sqflite", (String)(database.getThreadLogPrefix() + "starting worker pool with priority " + THREAD_PRIORITY));
                }
            }
            database.databaseWorkerPool = databaseWorkerPool;
            if (LogLevel.hasSqlLevel(database.logLevel)) {
                Log.d((String)"Sqflite", (String)(database.getThreadLogPrefix() + "opened " + databaseId2 + " " + path));
            }
            databaseWorkerPool.post(database, () -> {
                Object object = openCloseLocker;
                synchronized (object) {
                    File file;
                    File directory;
                    if (!(inMemory || (directory = new File((file = new File(path)).getParent())).exists() || directory.mkdirs() || directory.exists())) {
                        result.error("sqlite_error", "open_failed " + path, null);
                        return;
                    }
                    try {
                        if (Boolean.TRUE.equals(readOnly)) {
                            database.openReadOnly();
                        } else {
                            database.open();
                        }
                    }
                    catch (Exception e) {
                        MethodCallOperation operation = new MethodCallOperation(call, result);
                        database.handleException(e, operation);
                        return;
                    }
                    Object object2 = databaseMapLocker;
                    synchronized (object2) {
                        if (singleInstance) {
                            _singleInstancesByPath.put(path, databaseId2);
                        }
                        databaseMap.put(databaseId2, database);
                    }
                    if (LogLevel.hasSqlLevel(database.logLevel)) {
                        Log.d((String)"Sqflite", (String)(database.getThreadLogPrefix() + "opened " + databaseId2 + " " + path));
                    }
                }
                result.success((Object)SqflitePlugin.makeOpenResult(databaseId2, false, false));
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCloseDatabaseCall(MethodCall call, final MethodChannel.Result result) {
        int databaseId = (Integer)call.argument("id");
        final Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        if (LogLevel.hasSqlLevel(database.logLevel)) {
            Log.d((String)"Sqflite", (String)(database.getThreadLogPrefix() + "closing " + databaseId + " " + database.path));
        }
        String path = database.path;
        Object object = databaseMapLocker;
        synchronized (object) {
            databaseMap.remove(databaseId);
            if (database.singleInstance) {
                _singleInstancesByPath.remove(path);
            }
        }
        databaseWorkerPool.post(database, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = openCloseLocker;
                synchronized (object) {
                    SqflitePlugin.this.closeDatabase(database);
                }
                result.success(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDeleteDatabaseCall(MethodCall call, final MethodChannel.Result result) {
        final String path = (String)call.argument("path");
        Database foundOpenedDatabase = null;
        Object object = databaseMapLocker;
        synchronized (object) {
            Database database;
            Integer databaseId;
            if (LogLevel.hasVerboseLevel(logLevel)) {
                Log.d((String)"Sqflite", (String)("Look for " + path + " in " + _singleInstancesByPath.keySet()));
            }
            if ((databaseId = _singleInstancesByPath.get(path)) != null && (database = databaseMap.get(databaseId)) != null && database.sqliteDatabase.isOpen()) {
                if (LogLevel.hasVerboseLevel(logLevel)) {
                    Log.d((String)"Sqflite", (String)(database.getThreadLogPrefix() + "found single instance " + (database.isInTransaction() ? "(in transaction) " : "") + databaseId + " " + path));
                }
                foundOpenedDatabase = database;
                databaseMap.remove(databaseId);
                _singleInstancesByPath.remove(path);
            }
        }
        final Database openedDatabase = foundOpenedDatabase;
        Runnable deleteRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = openCloseLocker;
                synchronized (object) {
                    if (openedDatabase != null) {
                        SqflitePlugin.this.closeDatabase(openedDatabase);
                    }
                    try {
                        if (LogLevel.hasVerboseLevel(logLevel)) {
                            Log.d((String)"Sqflite", (String)("delete database " + path));
                        }
                        Database.deleteDatabase(path);
                    }
                    catch (Exception e) {
                        Log.e((String)"Sqflite", (String)("error " + e + " while closing database " + databaseId));
                    }
                }
                result.success(null);
            }
        };
        if (databaseWorkerPool != null) {
            databaseWorkerPool.post(openedDatabase, deleteRunnable);
        } else {
            deleteRunnable.run();
        }
    }

    private void onDatabaseExistsCall(MethodCall call, MethodChannel.Result result) {
        String path = (String)call.argument("path");
        boolean exists = Database.existsDatabase(path);
        result.success((Object)exists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDatabase(Database database) {
        try {
            if (LogLevel.hasSqlLevel(database.logLevel)) {
                Log.d((String)"Sqflite", (String)(database.getThreadLogPrefix() + "closing database "));
            }
            database.close();
        }
        catch (Exception e) {
            Log.e((String)"Sqflite", (String)("error " + e + " while closing database " + databaseId));
        }
        Object object = databaseMapLocker;
        synchronized (object) {
            if (databaseMap.isEmpty() && databaseWorkerPool != null) {
                if (LogLevel.hasSqlLevel(database.logLevel)) {
                    Log.d((String)"Sqflite", (String)(database.getThreadLogPrefix() + "stopping thread"));
                }
                databaseWorkerPool.quit();
                databaseWorkerPool = null;
            }
        }
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        switch (call.method) {
            case "getPlatformVersion": {
                result.success((Object)("Android " + Build.VERSION.RELEASE));
                break;
            }
            case "closeDatabase": {
                this.onCloseDatabaseCall(call, result);
                break;
            }
            case "query": {
                this.onQueryCall(call, result);
                break;
            }
            case "insert": {
                this.onInsertCall(call, result);
                break;
            }
            case "update": {
                this.onUpdateCall(call, result);
                break;
            }
            case "execute": {
                this.onExecuteCall(call, result);
                break;
            }
            case "openDatabase": {
                this.onOpenDatabaseCall(call, result);
                break;
            }
            case "batch": {
                this.onBatchCall(call, result);
                break;
            }
            case "options": {
                this.onOptionsCall(call, result);
                break;
            }
            case "getDatabasesPath": {
                this.onGetDatabasesPathCall(call, result);
                break;
            }
            case "deleteDatabase": {
                this.onDeleteDatabaseCall(call, result);
                break;
            }
            case "debug": {
                this.onDebugCall(call, result);
                break;
            }
            case "queryCursorNext": {
                this.onQueryCursorNextCall(call, result);
                break;
            }
            case "databaseExists": {
                this.onDatabaseExistsCall(call, result);
                break;
            }
            case "debugMode": {
                this.onDebugModeCall(call, result);
                break;
            }
            case "androidSetLocale": {
                this.onSetLocaleCall(call, result);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    void onOptionsCall(MethodCall call, MethodChannel.Result result) {
        Integer logLevel;
        Object threadCount;
        Object threadPriority = call.argument("androidThreadPriority");
        if (threadPriority != null) {
            THREAD_PRIORITY = (Integer)threadPriority;
        }
        if ((threadCount = call.argument("androidThreadCount")) != null && !threadCount.equals(THREAD_COUNT)) {
            THREAD_COUNT = (Integer)threadCount;
            if (databaseWorkerPool != null) {
                databaseWorkerPool.quit();
                databaseWorkerPool = null;
            }
        }
        if ((logLevel = LogLevel.getLogLevel(call)) != null) {
            SqflitePlugin.logLevel = logLevel;
        }
        result.success(null);
    }

    void onGetDatabasesPathCall(MethodCall call, MethodChannel.Result result) {
        if (databasesPath == null) {
            String dummyDatabaseName = "tekartik_sqflite.db";
            File file = this.context.getDatabasePath(dummyDatabaseName);
            databasesPath = file.getParent();
        }
        result.success((Object)databasesPath);
    }

    static {
        THREAD_PRIORITY = 0;
        THREAD_COUNT = 1;
        databaseId = 0;
    }
}

