/*
 * Decompiled with CFR 0.152.
 */
package com.tekartik.sqflite;

import android.os.Build;
import androidx.annotation.RequiresApi;
import java.util.Locale;

public class LocaleUtils {
    static Locale localeForLanguateTag(String localeString) {
        if (Build.VERSION.SDK_INT >= 21) {
            return LocaleUtils.localeForLanguageTag21(localeString);
        }
        return LocaleUtils.localeForLanguageTagPre21(localeString);
    }

    @RequiresApi(api=21)
    static Locale localeForLanguageTag21(String localeString) {
        return Locale.forLanguageTag(localeString);
    }

    static Locale localeForLanguageTagPre21(String localeString) {
        String[] parts = localeString.split("-");
        String language = "";
        String country = "";
        String variant = "";
        if (parts.length > 0) {
            language = parts[0];
            if (parts.length > 1) {
                country = parts[1];
                if (parts.length > 2) {
                    variant = parts[parts.length - 1];
                }
            }
        }
        return new Locale(language, country, variant);
    }
}

