/*
 * Decompiled with CFR 0.152.
 */
package com.tekartik.sqflite;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.SQLException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteProgram;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.tekartik.sqflite.Constant;
import com.tekartik.sqflite.DatabaseWorkerPool;
import com.tekartik.sqflite.LogLevel;
import com.tekartik.sqflite.SqfliteCursor;
import com.tekartik.sqflite.SqlCommand;
import com.tekartik.sqflite.Utils;
import com.tekartik.sqflite.operation.BatchOperation;
import com.tekartik.sqflite.operation.MethodCallOperation;
import com.tekartik.sqflite.operation.Operation;
import com.tekartik.sqflite.operation.QueuedOperation;
import com.tekartik.sqflite.operation.SqlErrorInfo;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class Database {
    static final boolean WAL_ENABLED_BY_DEFAULT = false;
    private static final String WAL_ENABLED_META_NAME = "com.tekartik.sqflite.wal_enabled";
    private static Boolean walGloballyEnabled;
    final boolean singleInstance;
    @NonNull
    final String path;
    final int id;
    final int logLevel;
    @NonNull
    final Context context;
    final List<QueuedOperation> noTransactionOperationQueue = new ArrayList<QueuedOperation>();
    final Map<Integer, SqfliteCursor> cursors = new HashMap<Integer, SqfliteCursor>();
    public DatabaseWorkerPool databaseWorkerPool;
    @Nullable
    SQLiteDatabase sqliteDatabase;
    private int transactionDepth = 0;
    private int lastTransactionId = 0;
    @Nullable
    private Integer currentTransactionId;
    private int lastCursorId = 0;

    Database(Context context, String path, int id, boolean singleInstance, int logLevel) {
        this.context = context;
        this.path = path;
        this.singleInstance = singleInstance;
        this.id = id;
        this.logLevel = logLevel;
    }

    @VisibleForTesting
    @NotNull
    protected static boolean checkWalEnabled(Context context) {
        return Database.checkMetaBoolean(context, WAL_ENABLED_META_NAME, false);
    }

    static ApplicationInfo getApplicationInfoWithMeta32(Context context, String packageName, int flags) throws PackageManager.NameNotFoundException {
        return context.getPackageManager().getApplicationInfo(packageName, flags);
    }

    @VisibleForTesting
    @NotNull
    protected static boolean checkMetaBoolean(Context context, String metaKey, boolean defaultValue) {
        try {
            String packageName = context.getPackageName();
            ApplicationInfo applicationInfo = Build.VERSION.SDK_INT >= 33 ? context.getPackageManager().getApplicationInfo(packageName, PackageManager.ApplicationInfoFlags.of((long)128L)) : Database.getApplicationInfoWithMeta32(context, packageName, 128);
            boolean walEnabled = applicationInfo.metaData.getBoolean(metaKey, defaultValue);
            if (walEnabled) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    static void deleteDatabase(String path) {
        SQLiteDatabase.deleteDatabase((File)new File(path));
    }

    public static boolean existsDatabase(String path) {
        boolean exists = false;
        try {
            exists = new File(path).exists();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    public void open() {
        int flags = 0x10000000;
        if (walGloballyEnabled == null && (walGloballyEnabled = Boolean.valueOf(Database.checkWalEnabled(this.context))).booleanValue() && LogLevel.hasVerboseLevel(this.logLevel)) {
            Log.d((String)"Sqflite", (String)(this.getThreadLogPrefix() + "[sqflite] WAL enabled"));
        }
        if (walGloballyEnabled.booleanValue()) {
            flags |= 0x20000000;
        }
        this.sqliteDatabase = SQLiteDatabase.openDatabase((String)this.path, null, (int)flags);
    }

    public void openReadOnly() {
        this.sqliteDatabase = SQLiteDatabase.openDatabase((String)this.path, null, (int)1, (DatabaseErrorHandler)new DatabaseErrorHandler(){

            public void onCorruption(SQLiteDatabase dbObj) {
            }
        });
    }

    public void close() {
        if (!this.cursors.isEmpty() && LogLevel.hasSqlLevel(this.logLevel)) {
            Log.d((String)"Sqflite", (String)(this.getThreadLogPrefix() + this.cursors.size() + " cursor(s) are left opened"));
        }
        this.sqliteDatabase.close();
    }

    public SQLiteDatabase getWritableDatabase() {
        return this.sqliteDatabase;
    }

    public SQLiteDatabase getReadableDatabase() {
        return this.sqliteDatabase;
    }

    public boolean enableWriteAheadLogging() {
        try {
            return this.sqliteDatabase.enableWriteAheadLogging();
        }
        catch (Exception e) {
            Log.e((String)"Sqflite", (String)(this.getThreadLogPrefix() + "enable WAL error: " + e));
            return false;
        }
    }

    String getThreadLogTag() {
        Thread thread = Thread.currentThread();
        return this.id + "," + thread.getName() + "(" + thread.getId() + ")";
    }

    String getThreadLogPrefix() {
        return "[" + this.getThreadLogTag() + "] ";
    }

    private Map<String, Object> cursorToResults(Cursor cursor, @Nullable Integer cursorPageSize) {
        HashMap<String, List<Object>> results = null;
        ArrayList<List<Object>> rows = null;
        int columnCount = 0;
        while (cursor.moveToNext()) {
            if (results == null) {
                rows = new ArrayList<List<Object>>();
                results = new HashMap();
                columnCount = cursor.getColumnCount();
                results.put("columns", Arrays.asList(cursor.getColumnNames()));
                results.put("rows", rows);
            }
            rows.add(Utils.cursorRowToList(cursor, columnCount));
            if (cursorPageSize == null || rows.size() < cursorPageSize) continue;
        }
        if (results == null) {
            results = new HashMap<String, List<Object>>();
        }
        return results;
    }

    private void runQueuedOperations() {
        while (!this.noTransactionOperationQueue.isEmpty() && this.currentTransactionId == null) {
            QueuedOperation queuedOperation = this.noTransactionOperationQueue.get(0);
            queuedOperation.run();
            this.noTransactionOperationQueue.remove(0);
        }
    }

    private void wrapSqlOperationHandler(@NonNull Operation operation, Runnable r) {
        Integer transactionId = operation.getTransactionId();
        if (this.currentTransactionId == null) {
            r.run();
        } else if (transactionId != null && (transactionId.equals(this.currentTransactionId) || transactionId == -1)) {
            r.run();
            if (this.currentTransactionId == null && !this.noTransactionOperationQueue.isEmpty()) {
                this.databaseWorkerPool.post(this, this::runQueuedOperations);
            }
        } else {
            QueuedOperation queuedOperation = new QueuedOperation(operation, r);
            this.noTransactionOperationQueue.add(queuedOperation);
        }
    }

    public void query(@NonNull Operation operation) {
        this.wrapSqlOperationHandler(operation, () -> this.doQuery(operation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doQuery(@NonNull Operation operation) {
        Integer cursorPageSize = (Integer)operation.getArgument("cursorPageSize");
        boolean cursorHasMoreData = false;
        SqlCommand command = operation.getSqlCommand();
        SqfliteCursor sqfliteCursor = null;
        if (LogLevel.hasSqlLevel(this.logLevel)) {
            Log.d((String)"Sqflite", (String)(this.getThreadLogPrefix() + command));
        }
        Cursor cursor = null;
        try {
            cursor = this.getReadableDatabase().rawQueryWithFactory((sqLiteDatabase, sqLiteCursorDriver, editTable, sqLiteQuery) -> {
                command.bindTo((SQLiteProgram)sqLiteQuery);
                return new SQLiteCursor(sqLiteCursorDriver, editTable, sqLiteQuery);
            }, command.getSql(), Constant.EMPTY_STRING_ARRAY, null);
            Map<String, Object> results = this.cursorToResults(cursor, cursorPageSize);
            if (cursorPageSize != null) {
                boolean bl = cursorHasMoreData = !cursor.isLast() && !cursor.isAfterLast();
            }
            if (cursorHasMoreData) {
                int cursorId = ++this.lastCursorId;
                results.put("cursorId", cursorId);
                sqfliteCursor = new SqfliteCursor(cursorId, cursorPageSize, cursor);
                this.cursors.put(cursorId, sqfliteCursor);
            }
            operation.success(results);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.handleException(exception, operation);
            if (sqfliteCursor != null) {
                this.closeCursor(sqfliteCursor);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (sqfliteCursor == null && cursor != null) {
                cursor.close();
            }
        }
    }

    public void queryCursorNext(@NonNull Operation operation) {
        this.wrapSqlOperationHandler(operation, () -> this.doQueryCursorNext(operation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doQueryCursorNext(@NonNull Operation operation) {
        int cursorId = (Integer)operation.getArgument("cursorId");
        boolean cancel = Boolean.TRUE.equals(operation.getArgument("cancel"));
        if (LogLevel.hasVerboseLevel(this.logLevel)) {
            Log.d((String)"Sqflite", (String)(this.getThreadLogPrefix() + "cursor " + cursorId + (cancel ? " cancel" : " next")));
        }
        if (cancel) {
            this.closeCursor(cursorId);
            operation.success(null);
            return true;
        }
        SqfliteCursor sqfliteCursor = this.cursors.get(cursorId);
        boolean cursorHasMoreData = false;
        try {
            if (sqfliteCursor == null) {
                throw new IllegalStateException("Cursor " + cursorId + " not found");
            }
            Cursor cursor = sqfliteCursor.cursor;
            Map<String, Object> results = this.cursorToResults(cursor, sqfliteCursor.pageSize);
            boolean bl = cursorHasMoreData = !cursor.isLast() && !cursor.isAfterLast();
            if (cursorHasMoreData) {
                results.put("cursorId", cursorId);
            }
            operation.success(results);
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            this.handleException(exception, operation);
            if (sqfliteCursor != null) {
                this.closeCursor(sqfliteCursor);
                sqfliteCursor = null;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (!cursorHasMoreData && sqfliteCursor != null) {
                this.closeCursor(sqfliteCursor);
            }
        }
    }

    private void closeCursor(@NonNull SqfliteCursor sqfliteCursor) {
        try {
            int cursorId = sqfliteCursor.cursorId;
            if (LogLevel.hasVerboseLevel(this.logLevel)) {
                Log.d((String)"Sqflite", (String)(this.getThreadLogPrefix() + "closing cursor " + cursorId));
            }
            this.cursors.remove(cursorId);
            sqfliteCursor.cursor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeCursor(int cursorId) {
        SqfliteCursor sqfliteCursor = this.cursors.get(cursorId);
        if (sqfliteCursor != null) {
            this.closeCursor(sqfliteCursor);
        }
    }

    void handleException(Exception exception, Operation operation) {
        if (exception instanceof SQLiteCantOpenDatabaseException) {
            operation.error("sqlite_error", "open_failed " + this.path, null);
            return;
        }
        if (exception instanceof SQLException) {
            operation.error("sqlite_error", exception.getMessage(), SqlErrorInfo.getMap(operation));
            return;
        }
        operation.error("sqlite_error", exception.getMessage(), SqlErrorInfo.getMap(operation));
    }

    private boolean executeOrError(Operation operation) {
        SqlCommand command = operation.getSqlCommand();
        if (LogLevel.hasSqlLevel(this.logLevel)) {
            Log.d((String)"Sqflite", (String)(this.getThreadLogPrefix() + command));
        }
        Boolean operationInTransaction = operation.getInTransactionChange();
        try {
            this.getWritableDatabase().execSQL(command.getSql(), command.getSqlArguments());
            this.enterOrLeaveInTransaction(operationInTransaction);
            return true;
        }
        catch (Exception exception) {
            this.handleException(exception, operation);
            return false;
        }
    }

    public void execute(@NonNull Operation operation) {
        this.wrapSqlOperationHandler(operation, () -> {
            boolean enteringTransaction;
            Boolean inTransactionChange = operation.getInTransactionChange();
            boolean bl = enteringTransaction = Boolean.TRUE.equals(inTransactionChange) && operation.hasNullTransactionId();
            if (enteringTransaction) {
                this.currentTransactionId = ++this.lastTransactionId;
            }
            if (!this.executeOrError(operation)) {
                if (enteringTransaction) {
                    this.currentTransactionId = null;
                }
            } else if (enteringTransaction) {
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                result.put("transactionId", this.currentTransactionId);
                operation.success(result);
            } else {
                if (Boolean.FALSE.equals(inTransactionChange)) {
                    this.currentTransactionId = null;
                }
                operation.success(null);
            }
        });
    }

    private boolean doExecute(Operation operation) {
        if (!this.executeOrError(operation)) {
            return false;
        }
        operation.success(null);
        return true;
    }

    public void insert(Operation operation) {
        this.wrapSqlOperationHandler(operation, () -> this.doInsert(operation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doInsert(Operation operation) {
        if (!this.executeOrError(operation)) {
            return false;
        }
        if (operation.getNoResult()) {
            operation.success(null);
            return true;
        }
        String sql = "SELECT changes(), last_insert_rowid()";
        try (Cursor cursor = null;){
            SQLiteDatabase db = this.getWritableDatabase();
            cursor = db.rawQuery(sql, null);
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                int changed = cursor.getInt(0);
                if (changed == 0) {
                    if (LogLevel.hasSqlLevel(this.logLevel)) {
                        Log.d((String)"Sqflite", (String)(this.getThreadLogPrefix() + "no changes (id was " + cursor.getLong(1) + ")"));
                    }
                    operation.success(null);
                    boolean bl = true;
                    return bl;
                }
                long id = cursor.getLong(1);
                if (LogLevel.hasSqlLevel(this.logLevel)) {
                    Log.d((String)"Sqflite", (String)(this.getThreadLogPrefix() + "inserted " + id));
                }
                operation.success(id);
                boolean bl = true;
                return bl;
            }
            Log.e((String)"Sqflite", (String)(this.getThreadLogPrefix() + "fail to read changes for Insert"));
            operation.success(null);
            boolean bl = true;
            return bl;
        }
    }

    public void update(@NonNull Operation operation) {
        this.wrapSqlOperationHandler(operation, () -> this.doUpdate(operation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUpdate(Operation operation) {
        if (!this.executeOrError(operation)) {
            return false;
        }
        if (operation.getNoResult()) {
            operation.success(null);
            return true;
        }
        try (Cursor cursor = null;){
            SQLiteDatabase db = this.getWritableDatabase();
            cursor = db.rawQuery("SELECT changes()", null);
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                int changed = cursor.getInt(0);
                if (LogLevel.hasSqlLevel(this.logLevel)) {
                    Log.d((String)"Sqflite", (String)(this.getThreadLogPrefix() + "changed " + changed));
                }
                operation.success(changed);
                boolean bl = true;
                return bl;
            }
            Log.e((String)"Sqflite", (String)(this.getThreadLogPrefix() + "fail to read changes for Update/Delete"));
            operation.success(null);
            boolean bl = true;
            return bl;
        }
    }

    void batch(MethodCall call, MethodChannel.Result result) {
        MethodCallOperation mainOperation = new MethodCallOperation(call, result);
        boolean noResult = mainOperation.getNoResult();
        boolean continueOnError = mainOperation.getContinueOnError();
        List operations = (List)mainOperation.getArgument("operations");
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        block12: for (Map map : operations) {
            String method;
            BatchOperation operation = new BatchOperation(map, noResult);
            switch (method = operation.getMethod()) {
                case "execute": {
                    if (this.doExecute(operation)) {
                        operation.handleSuccess(results);
                        continue block12;
                    }
                    if (continueOnError) {
                        operation.handleErrorContinue(results);
                        continue block12;
                    }
                    operation.handleError(result);
                    return;
                }
                case "insert": {
                    if (this.doInsert(operation)) {
                        operation.handleSuccess(results);
                        continue block12;
                    }
                    if (continueOnError) {
                        operation.handleErrorContinue(results);
                        continue block12;
                    }
                    operation.handleError(result);
                    return;
                }
                case "query": {
                    if (this.doQuery(operation)) {
                        operation.handleSuccess(results);
                        continue block12;
                    }
                    if (continueOnError) {
                        operation.handleErrorContinue(results);
                        continue block12;
                    }
                    operation.handleError(result);
                    return;
                }
                case "update": {
                    if (this.doUpdate(operation)) {
                        operation.handleSuccess(results);
                        continue block12;
                    }
                    if (continueOnError) {
                        operation.handleErrorContinue(results);
                        continue block12;
                    }
                    operation.handleError(result);
                    return;
                }
            }
            result.error("bad_param", "Batch method '" + method + "' not supported", null);
            return;
        }
        if (noResult) {
            result.success(null);
        } else {
            result.success(results);
        }
    }

    synchronized boolean isInTransaction() {
        return this.transactionDepth > 0;
    }

    synchronized void enterOrLeaveInTransaction(Boolean value) {
        if (Boolean.TRUE.equals(value)) {
            ++this.transactionDepth;
        } else if (Boolean.FALSE.equals(value)) {
            --this.transactionDepth;
        }
    }
}

