/*
 * Decompiled with CFR 0.152.
 */
package com.tekartik.sqflite;

import android.database.sqlite.SQLiteProgram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SqlCommand {
    private final String sql;
    private final List<Object> rawArguments;

    public SqlCommand(String sql, List<Object> rawArguments) {
        this.sql = sql;
        if (rawArguments == null) {
            rawArguments = new ArrayList<Object>();
        }
        this.rawArguments = rawArguments;
    }

    private static Object toValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            byte[] blob = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                blob[i] = (byte)((Integer)list.get(i)).intValue();
            }
            value = blob;
        }
        return value;
    }

    public String getSql() {
        return this.sql;
    }

    private Object[] getSqlArguments(List<Object> rawArguments) {
        ArrayList<Object> fixedArguments = new ArrayList<Object>();
        if (rawArguments != null) {
            for (Object rawArgument : rawArguments) {
                fixedArguments.add(SqlCommand.toValue(rawArgument));
            }
        }
        return fixedArguments.toArray(new Object[0]);
    }

    public void bindTo(SQLiteProgram statement) {
        if (this.rawArguments != null) {
            int count = this.rawArguments.size();
            for (int i = 0; i < count; ++i) {
                Object arg = SqlCommand.toValue(this.rawArguments.get(i));
                int sqlIndex = i + 1;
                if (arg == null) {
                    statement.bindNull(sqlIndex);
                    continue;
                }
                if (arg instanceof byte[]) {
                    statement.bindBlob(sqlIndex, (byte[])arg);
                    continue;
                }
                if (arg instanceof Double) {
                    statement.bindDouble(sqlIndex, ((Double)arg).doubleValue());
                    continue;
                }
                if (arg instanceof Integer) {
                    statement.bindLong(sqlIndex, (long)((Integer)arg).intValue());
                    continue;
                }
                if (arg instanceof Long) {
                    statement.bindLong(sqlIndex, ((Long)arg).longValue());
                    continue;
                }
                if (arg instanceof String) {
                    statement.bindString(sqlIndex, (String)arg);
                    continue;
                }
                if (arg instanceof Boolean) {
                    statement.bindLong(sqlIndex, (Boolean)arg != false ? 1L : 0L);
                    continue;
                }
                throw new IllegalArgumentException("Could not bind " + arg + " from index " + i + ": Supported types are null, byte[], double, long, boolean and String");
            }
        }
    }

    public String toString() {
        return this.sql + (this.rawArguments == null || this.rawArguments.isEmpty() ? "" : " " + this.rawArguments);
    }

    public Object[] getSqlArguments() {
        return this.getSqlArguments(this.rawArguments);
    }

    public List<Object> getRawSqlArguments() {
        return this.rawArguments;
    }

    public int hashCode() {
        return this.sql != null ? this.sql.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SqlCommand) {
            SqlCommand o = (SqlCommand)obj;
            if (this.sql != null ? !this.sql.equals(o.sql) : o.sql != null) {
                return false;
            }
            if (this.rawArguments.size() != o.rawArguments.size()) {
                return false;
            }
            for (int i = 0; i < this.rawArguments.size(); ++i) {
                if (!(this.rawArguments.get(i) instanceof byte[] && o.rawArguments.get(i) instanceof byte[] ? !Arrays.equals((byte[])this.rawArguments.get(i), (byte[])o.rawArguments.get(i)) : !this.rawArguments.get(i).equals(o.rawArguments.get(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

