/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.webviewflutter;

import android.graphics.Bitmap;
import android.view.KeyEvent;
import android.webkit.HttpAuthHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.webkit.WebResourceErrorCompat;
import androidx.webkit.WebViewClientCompat;
import io.flutter.plugins.webviewflutter.PigeonApiWebViewClient;
import io.flutter.plugins.webviewflutter.ProxyApiRegistrar;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class WebViewClientProxyApi
extends PigeonApiWebViewClient {
    public WebViewClientProxyApi(@NonNull ProxyApiRegistrar pigeonRegistrar) {
        super(pigeonRegistrar);
    }

    @Override
    @NonNull
    public WebViewClient pigeon_defaultConstructor() {
        if (this.getPigeonRegistrar().sdkIsAtLeast(24)) {
            return new WebViewClientImpl(this);
        }
        return new WebViewClientCompatImpl(this);
    }

    @Override
    public void setSynchronousReturnValueForShouldOverrideUrlLoading(@NonNull WebViewClient pigeon_instance, boolean value) {
        if (pigeon_instance instanceof WebViewClientCompatImpl) {
            ((WebViewClientCompatImpl)pigeon_instance).setReturnValueForShouldOverrideUrlLoading(value);
        } else if (this.getPigeonRegistrar().sdkIsAtLeast(24) && pigeon_instance instanceof WebViewClientImpl) {
            ((WebViewClientImpl)pigeon_instance).setReturnValueForShouldOverrideUrlLoading(value);
        } else {
            throw new IllegalStateException("This WebViewClient doesn't support setting the returnValueForShouldOverrideUrlLoading.");
        }
    }

    @Override
    @NonNull
    public ProxyApiRegistrar getPigeonRegistrar() {
        return (ProxyApiRegistrar)super.getPigeonRegistrar();
    }

    @RequiresApi(value=24)
    public static class WebViewClientImpl
    extends WebViewClient {
        private final WebViewClientProxyApi api;
        private boolean returnValueForShouldOverrideUrlLoading = false;

        public WebViewClientImpl(@NonNull WebViewClientProxyApi api) {
            this.api = api;
        }

        public void onPageStarted(@NonNull WebView view, @NonNull String url, @NonNull Bitmap favicon) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onPageStarted(this, view, url, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onPageFinished(@NonNull WebView view, @NonNull String url) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onPageFinished(this, view, url, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedHttpError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceResponse response) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedHttpError(this, view, request, response, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceError error) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedRequestError(this, view, request, error, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedError(@NonNull WebView view, int errorCode, @NonNull String description, @NonNull String failingUrl) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedError(this, view, errorCode, description, failingUrl, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull WebResourceRequest request) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.requestLoading(this, view, request, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
            return request.isForMainFrame() && this.returnValueForShouldOverrideUrlLoading;
        }

        public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull String url) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.urlLoading(this, view, url, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
            return this.returnValueForShouldOverrideUrlLoading;
        }

        public void doUpdateVisitedHistory(@NonNull WebView view, @NonNull String url, boolean isReload) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.doUpdateVisitedHistory(this, view, url, isReload, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedHttpAuthRequest(@NonNull WebView view, @NonNull HttpAuthHandler handler, @NonNull String host, @NonNull String realm) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedHttpAuthRequest(this, view, handler, host, realm, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onUnhandledKeyEvent(@NonNull WebView view, @NonNull KeyEvent event) {
        }

        public void setReturnValueForShouldOverrideUrlLoading(boolean value) {
            this.returnValueForShouldOverrideUrlLoading = value;
        }
    }

    public static class WebViewClientCompatImpl
    extends WebViewClientCompat {
        private final WebViewClientProxyApi api;
        private boolean returnValueForShouldOverrideUrlLoading = false;

        public WebViewClientCompatImpl(@NonNull WebViewClientProxyApi api) {
            this.api = api;
        }

        public void onPageStarted(@NonNull WebView view, @NonNull String url, @NonNull Bitmap favicon) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onPageStarted((WebViewClient)this, view, url, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onPageFinished(@NonNull WebView view, @NonNull String url) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onPageFinished((WebViewClient)this, view, url, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedHttpError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceResponse response) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedHttpError((WebViewClient)this, view, request, response, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceErrorCompat error) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedRequestErrorCompat((WebViewClient)this, view, request, error, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedError(@NonNull WebView view, int errorCode, @NonNull String description, @NonNull String failingUrl) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedError((WebViewClient)this, view, errorCode, description, failingUrl, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull WebResourceRequest request) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.requestLoading((WebViewClient)this, view, request, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
            return request.isForMainFrame() && this.returnValueForShouldOverrideUrlLoading;
        }

        public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull String url) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.urlLoading((WebViewClient)this, view, url, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
            return this.returnValueForShouldOverrideUrlLoading;
        }

        public void doUpdateVisitedHistory(@NonNull WebView view, @NonNull String url, boolean isReload) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.doUpdateVisitedHistory((WebViewClient)this, view, url, isReload, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onReceivedHttpAuthRequest(@NonNull WebView view, HttpAuthHandler handler, String host, String realm) {
            this.api.getPigeonRegistrar().runOnMainThread(() -> this.api.onReceivedHttpAuthRequest((WebViewClient)this, view, handler, host, realm, (Function1<? super Result<Unit>, Unit>)((Function1)reply -> null)));
        }

        public void onUnhandledKeyEvent(@NonNull WebView view, @NonNull KeyEvent event) {
        }

        public void setReturnValueForShouldOverrideUrlLoading(boolean value) {
            this.returnValueForShouldOverrideUrlLoading = value;
        }
    }
}

