/*
 * Decompiled with CFR 0.152.
 */
package xyz.luan.audioplayers.player;

import android.media.SoundPool;
import android.os.Build;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.luan.audioplayers.AudioContextAndroid;
import xyz.luan.audioplayers.player.Player;
import xyz.luan.audioplayers.player.SoundPoolManager;
import xyz.luan.audioplayers.player.SoundPoolWrapper;
import xyz.luan.audioplayers.player.WrappedPlayer;
import xyz.luan.audioplayers.source.Source;
import xyz.luan.audioplayers.source.UrlSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0013H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0016J\u0010\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020.H\u0016J\u0010\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u000204H\u0016J\n\u00105\u001a\u0004\u0018\u000106H\u0016J\n\u00107\u001a\u0004\u0018\u000106H\u0016J\b\u00108\u001a\u000204H\u0016J\u0010\u00109\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u000bH\u0016J\b\u0010;\u001a\u00020\u001eH\u0016J\b\u0010<\u001a\u00020\u001eH\u0016J\b\u0010=\u001a\u00020\u001eH\u0016J\b\u0010>\u001a\u000204H\u0016J\f\u0010?\u001a\u00020\u000b*\u000204H\u0002J\u0010\u0010@\u001a\u0002062\u0006\u0010A\u001a\u00020BH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR(\u0010'\u001a\u0004\u0018\u00010&2\b\u0010\u0012\u001a\u0004\u0018\u00010&@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006C"}, d2={"Lxyz/luan/audioplayers/player/SoundPoolPlayer;", "Lxyz/luan/audioplayers/player/Player;", "wrappedPlayer", "Lxyz/luan/audioplayers/player/WrappedPlayer;", "soundPoolManager", "Lxyz/luan/audioplayers/player/SoundPoolManager;", "<init>", "(Lxyz/luan/audioplayers/player/WrappedPlayer;Lxyz/luan/audioplayers/player/SoundPoolManager;)V", "getWrappedPlayer", "()Lxyz/luan/audioplayers/player/WrappedPlayer;", "soundId", "", "getSoundId", "()Ljava/lang/Integer;", "setSoundId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "streamId", "value", "Lxyz/luan/audioplayers/AudioContextAndroid;", "audioContext", "setAudioContext", "(Lxyz/luan/audioplayers/AudioContextAndroid;)V", "soundPoolWrapper", "Lxyz/luan/audioplayers/player/SoundPoolWrapper;", "soundPool", "Landroid/media/SoundPool;", "getSoundPool", "()Landroid/media/SoundPool;", "stop", "", "release", "pause", "updateContext", "context", "setSource", "source", "Lxyz/luan/audioplayers/source/Source;", "Lxyz/luan/audioplayers/source/UrlSource;", "urlSource", "getUrlSource", "()Lxyz/luan/audioplayers/source/UrlSource;", "setUrlSource", "(Lxyz/luan/audioplayers/source/UrlSource;)V", "setVolume", "leftVolume", "", "rightVolume", "setRate", "rate", "setLooping", "looping", "", "getDuration", "", "getCurrentPosition", "isActuallyPlaying", "seekTo", "position", "start", "prepare", "reset", "isLiveStream", "loopModeInteger", "unsupportedOperation", "message", "", "audioplayers_android_debug"})
@SourceDebugExtension(value={"SMAP\nSoundPoolPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoundPoolPlayer.kt\nxyz/luan/audioplayers/player/SoundPoolPlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,297:1\n1#2:298\n361#3,7:299\n*S KotlinDebug\n*F\n+ 1 SoundPoolPlayer.kt\nxyz/luan/audioplayers/player/SoundPoolPlayer\n*L\n97#1:299,7\n*E\n"})
public final class SoundPoolPlayer
implements Player {
    @NotNull
    private final WrappedPlayer wrappedPlayer;
    @NotNull
    private final SoundPoolManager soundPoolManager;
    @Nullable
    private Integer soundId;
    @Nullable
    private Integer streamId;
    @NotNull
    private AudioContextAndroid audioContext;
    @NotNull
    private SoundPoolWrapper soundPoolWrapper;
    @Nullable
    private UrlSource urlSource;

    public SoundPoolPlayer(@NotNull WrappedPlayer wrappedPlayer, @NotNull SoundPoolManager soundPoolManager) {
        Intrinsics.checkNotNullParameter((Object)wrappedPlayer, (String)"wrappedPlayer");
        Intrinsics.checkNotNullParameter((Object)soundPoolManager, (String)"soundPoolManager");
        this.wrappedPlayer = wrappedPlayer;
        this.soundPoolManager = soundPoolManager;
        this.audioContext = this.wrappedPlayer.getContext();
        this.soundPoolManager.createSoundPoolWrapper(32, this.audioContext);
        SoundPoolWrapper soundPoolWrapper = this.soundPoolManager.getSoundPoolWrapper(this.audioContext);
        if (soundPoolWrapper == null) {
            throw new IllegalStateException(("Could not create SoundPool " + this.audioContext).toString());
        }
        this.soundPoolWrapper = soundPoolWrapper;
    }

    @NotNull
    public final WrappedPlayer getWrappedPlayer() {
        return this.wrappedPlayer;
    }

    @Nullable
    public final Integer getSoundId() {
        return this.soundId;
    }

    public final void setSoundId(@Nullable Integer n) {
        this.soundId = n;
    }

    private final void setAudioContext(AudioContextAndroid value) {
        if (Build.VERSION.SDK_INT >= 21 && !Intrinsics.areEqual((Object)this.audioContext.buildAttributes(), (Object)value.buildAttributes())) {
            this.release();
            this.soundPoolManager.createSoundPoolWrapper(32, value);
            SoundPoolWrapper soundPoolWrapper = this.soundPoolManager.getSoundPoolWrapper(value);
            if (soundPoolWrapper == null) {
                throw new IllegalStateException(("Could not create SoundPool " + value).toString());
            }
            this.soundPoolWrapper = soundPoolWrapper;
        }
        this.audioContext = value;
    }

    private final SoundPool getSoundPool() {
        return this.soundPoolWrapper.getSoundPool();
    }

    @Override
    public void stop() {
        block0: {
            Integer n = this.streamId;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.getSoundPool().stop(it);
            this.streamId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.stop();
        Integer n = this.soundId;
        if (n == null) {
            return;
        }
        int soundId = n;
        UrlSource urlSource = this.urlSource;
        if (urlSource == null) {
            return;
        }
        UrlSource urlSource2 = urlSource;
        Map<UrlSource, List<SoundPoolPlayer>> map = this.soundPoolWrapper.getUrlToPlayers();
        synchronized (map) {
            boolean bl = false;
            List<SoundPoolPlayer> list = this.soundPoolWrapper.getUrlToPlayers().get(urlSource2);
            if (list == null) {
                return;
            }
            List<SoundPoolPlayer> playersForSoundId = list;
            if (CollectionsKt.singleOrNull(playersForSoundId) == this) {
                this.soundPoolWrapper.getUrlToPlayers().remove(urlSource2);
                this.getSoundPool().unload(soundId);
                this.soundPoolWrapper.getSoundIdToPlayer().remove(soundId);
                this.wrappedPlayer.handleLog("unloaded soundId " + soundId);
            } else {
                playersForSoundId.remove(this);
            }
            this.soundId = null;
            this.setUrlSource(null);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void pause() {
        block0: {
            Integer n = this.streamId;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.getSoundPool().pause(it);
        }
    }

    @Override
    public void updateContext(@NotNull AudioContextAndroid context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.setAudioContext(context);
    }

    @Override
    public void setSource(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        source.setForSoundPool(this);
    }

    @Nullable
    public final UrlSource getUrlSource() {
        return this.urlSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void setUrlSource(@Nullable UrlSource value) {
        if (value != null) {
            Map<UrlSource, List<SoundPoolPlayer>> map = this.soundPoolWrapper.getUrlToPlayers();
            synchronized (map) {
                List urlPlayers;
                SoundPoolPlayer originalPlayer;
                Object object;
                void $this$getOrPut$iv;
                boolean bl = false;
                Map<UrlSource, List<SoundPoolPlayer>> map2 = this.soundPoolWrapper.getUrlToPlayers();
                UrlSource key$iv = value;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                if ((originalPlayer = (SoundPoolPlayer)CollectionsKt.firstOrNull((List)(urlPlayers = (List)object))) != null) {
                    boolean prepared = originalPlayer.wrappedPlayer.getPrepared();
                    this.wrappedPlayer.setPrepared(prepared);
                    this.soundId = originalPlayer.soundId;
                    this.wrappedPlayer.handleLog("Reusing soundId " + this.soundId + " for " + value + " is prepared=" + prepared + ' ' + this);
                } else {
                    long start = System.currentTimeMillis();
                    this.wrappedPlayer.setPrepared(false);
                    this.wrappedPlayer.handleLog("Fetching actual URL for " + value);
                    String actualUrl = value.getAudioPathForSoundPool();
                    this.wrappedPlayer.handleLog("Now loading " + actualUrl);
                    int intSoundId = this.getSoundPool().load(actualUrl, 1);
                    this.soundPoolWrapper.getSoundIdToPlayer().put(intSoundId, this);
                    this.soundId = intSoundId;
                    this.wrappedPlayer.handleLog("time to call load() for " + value + ": " + (System.currentTimeMillis() - start) + " player=" + this);
                }
                boolean bl3 = urlPlayers.add(this);
            }
        }
        this.urlSource = value;
    }

    @Override
    public void setVolume(float leftVolume, float rightVolume) {
        block0: {
            Integer n = this.streamId;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.getSoundPool().setVolume(it, leftVolume, rightVolume);
        }
    }

    @Override
    public void setRate(float rate) {
        block0: {
            Integer n = this.streamId;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.getSoundPool().setRate(it, rate);
        }
    }

    @Override
    public void setLooping(boolean looping) {
        block0: {
            Integer n = this.streamId;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.getSoundPool().setLoop(it, this.loopModeInteger(looping));
        }
    }

    @Nullable
    public Void getDuration() {
        return null;
    }

    @Nullable
    public Void getCurrentPosition() {
        return null;
    }

    @Override
    public boolean isActuallyPlaying() {
        return false;
    }

    @Override
    public void seekTo(int position) {
        if (position == 0) {
            Integer n = this.streamId;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                this.stop();
                if (this.wrappedPlayer.getPlaying()) {
                    this.getSoundPool().resume(it);
                }
            }
        } else {
            this.unsupportedOperation("seek");
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public void start() {
        Integer streamId = this.streamId;
        Integer soundId = this.soundId;
        if (streamId != null) {
            this.getSoundPool().resume(streamId.intValue());
        } else if (soundId != null) {
            this.streamId = this.getSoundPool().play(soundId.intValue(), this.wrappedPlayer.getVolume(), this.wrappedPlayer.getVolume(), 0, this.loopModeInteger(this.wrappedPlayer.isLooping()), this.wrappedPlayer.getRate());
        }
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isLiveStream() {
        return false;
    }

    private final int loopModeInteger(boolean $this$loopModeInteger) {
        return $this$loopModeInteger ? -1 : 0;
    }

    private final Void unsupportedOperation(String message) {
        throw new UnsupportedOperationException("LOW_LATENCY mode does not support: " + message);
    }
}

