/*
 * Decompiled with CFR 0.152.
 */
package xyz.luan.audioplayers.source;

import android.media.MediaDataSource;
import android.media.MediaPlayer;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.luan.audioplayers.ByteDataSource;
import xyz.luan.audioplayers.player.SoundPoolPlayer;
import xyz.luan.audioplayers.source.Source;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lxyz/luan/audioplayers/source/BytesSource;", "Lxyz/luan/audioplayers/source/Source;", "dataSource", "Lxyz/luan/audioplayers/ByteDataSource;", "<init>", "(Lxyz/luan/audioplayers/ByteDataSource;)V", "bytes", "", "([B)V", "getDataSource", "()Lxyz/luan/audioplayers/ByteDataSource;", "setForMediaPlayer", "", "mediaPlayer", "Landroid/media/MediaPlayer;", "setForSoundPool", "soundPoolPlayer", "Lxyz/luan/audioplayers/player/SoundPoolPlayer;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "audioplayers_android_debug"})
@RequiresApi(value=23)
public final class BytesSource
implements Source {
    @NotNull
    private final ByteDataSource dataSource;

    public BytesSource(@NotNull ByteDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataSource), (String)"dataSource");
        this.dataSource = dataSource;
    }

    @NotNull
    public final ByteDataSource getDataSource() {
        return this.dataSource;
    }

    public BytesSource(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this(new ByteDataSource(bytes));
    }

    @Override
    public void setForMediaPlayer(@NotNull MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)mediaPlayer, (String)"mediaPlayer");
        mediaPlayer.setDataSource((MediaDataSource)this.dataSource);
    }

    @Override
    public void setForSoundPool(@NotNull SoundPoolPlayer soundPoolPlayer) {
        Intrinsics.checkNotNullParameter((Object)soundPoolPlayer, (String)"soundPoolPlayer");
        throw new IllegalStateException("Bytes sources are not supported on LOW_LATENCY mode yet.".toString());
    }

    @NotNull
    public final ByteDataSource component1() {
        return this.dataSource;
    }

    @NotNull
    public final BytesSource copy(@NotNull ByteDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataSource), (String)"dataSource");
        return new BytesSource(dataSource);
    }

    public static /* synthetic */ BytesSource copy$default(BytesSource bytesSource, ByteDataSource byteDataSource, int n, Object object) {
        if ((n & 1) != 0) {
            byteDataSource = bytesSource.dataSource;
        }
        return bytesSource.copy(byteDataSource);
    }

    @NotNull
    public String toString() {
        return "BytesSource(dataSource=" + (Object)((Object)this.dataSource) + ')';
    }

    public int hashCode() {
        return this.dataSource.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BytesSource)) {
            return false;
        }
        BytesSource bytesSource = (BytesSource)other;
        return Intrinsics.areEqual((Object)((Object)this.dataSource), (Object)((Object)bytesSource.dataSource));
    }
}

