/*
 * Decompiled with CFR 0.152.
 */
package xyz.luan.audioplayers.player;

import android.media.AudioAttributes;
import android.media.SoundPool;
import android.os.Build;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.luan.audioplayers.AudioContextAndroid;
import xyz.luan.audioplayers.AudioplayersPlugin;
import xyz.luan.audioplayers.player.SoundPoolPlayer;
import xyz.luan.audioplayers.player.SoundPoolWrapper;
import xyz.luan.audioplayers.source.UrlSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxyz/luan/audioplayers/player/SoundPoolManager;", "", "ref", "Lxyz/luan/audioplayers/AudioplayersPlugin;", "<init>", "(Lxyz/luan/audioplayers/AudioplayersPlugin;)V", "legacySoundPoolWrapper", "Lxyz/luan/audioplayers/player/SoundPoolWrapper;", "soundPoolWrappers", "Ljava/util/HashMap;", "Landroid/media/AudioAttributes;", "Lkotlin/collections/HashMap;", "createSoundPoolWrapper", "", "maxStreams", "", "audioContext", "Lxyz/luan/audioplayers/AudioContextAndroid;", "getSoundPoolWrapper", "dispose", "audioplayers_android_release"})
public final class SoundPoolManager {
    @NotNull
    private final AudioplayersPlugin ref;
    @Nullable
    private SoundPoolWrapper legacySoundPoolWrapper;
    @NotNull
    private final HashMap<AudioAttributes, SoundPoolWrapper> soundPoolWrappers;

    public SoundPoolManager(@NotNull AudioplayersPlugin ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        this.ref = ref;
        this.soundPoolWrappers = new HashMap();
    }

    public final void createSoundPoolWrapper(int maxStreams, @NotNull AudioContextAndroid audioContext) {
        Intrinsics.checkNotNullParameter((Object)audioContext, (String)"audioContext");
        if (Build.VERSION.SDK_INT >= 21) {
            AudioAttributes attrs = audioContext.buildAttributes();
            if (!this.soundPoolWrappers.containsKey(attrs)) {
                SoundPool soundPool = new SoundPool.Builder().setAudioAttributes(attrs).setMaxStreams(maxStreams).build();
                this.ref.handleGlobalLog("Create SoundPool with " + attrs);
                Intrinsics.checkNotNull((Object)soundPool);
                SoundPoolWrapper soundPoolWrapper = new SoundPoolWrapper(soundPool);
                soundPoolWrapper.getSoundPool().setOnLoadCompleteListener((arg_0, arg_1, arg_2) -> SoundPoolManager.createSoundPoolWrapper$lambda$0(this, soundPoolWrapper, arg_0, arg_1, arg_2));
                ((Map)this.soundPoolWrappers).put(attrs, soundPoolWrapper);
            }
        } else if (this.legacySoundPoolWrapper == null) {
            SoundPool soundPool = new SoundPool(maxStreams, 3, 0);
            this.ref.handleGlobalLog("Create legacy SoundPool");
            this.legacySoundPoolWrapper = new SoundPoolWrapper(soundPool);
        }
    }

    @Nullable
    public final SoundPoolWrapper getSoundPoolWrapper(@NotNull AudioContextAndroid audioContext) {
        SoundPoolWrapper soundPoolWrapper;
        Intrinsics.checkNotNullParameter((Object)audioContext, (String)"audioContext");
        if (Build.VERSION.SDK_INT >= 21) {
            AudioAttributes attrs = audioContext.buildAttributes();
            soundPoolWrapper = this.soundPoolWrappers.get(attrs);
        } else {
            soundPoolWrapper = this.legacySoundPoolWrapper;
        }
        return soundPoolWrapper;
    }

    public final void dispose() {
        for (Map.Entry soundPoolEntry : ((Map)this.soundPoolWrappers).entrySet()) {
            ((SoundPoolWrapper)soundPoolEntry.getValue()).dispose();
        }
        this.soundPoolWrappers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createSoundPoolWrapper$lambda$0(SoundPoolManager this$0, SoundPoolWrapper $soundPoolWrapper, SoundPool soundPool, int sampleId, int n) {
        UrlSource urlSource;
        SoundPoolPlayer loadingPlayer;
        this$0.ref.handleGlobalLog("Loaded " + sampleId);
        SoundPoolPlayer soundPoolPlayer = loadingPlayer = $soundPoolWrapper.getSoundIdToPlayer().get(sampleId);
        UrlSource urlSource2 = urlSource = soundPoolPlayer != null ? soundPoolPlayer.getUrlSource() : null;
        if (urlSource != null) {
            Map<Integer, SoundPoolPlayer> map = $soundPoolWrapper.getSoundIdToPlayer();
            Object object = loadingPlayer.getSoundId();
            TypeIntrinsics.asMutableMap(map).remove(object);
            object = $soundPoolWrapper.getUrlToPlayers();
            synchronized (object) {
                boolean bl = false;
                List list = $soundPoolWrapper.getUrlToPlayers().get(urlSource);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List urlPlayers = list;
                for (SoundPoolPlayer player : urlPlayers) {
                    player.getWrappedPlayer().handleLog("Marking " + player + " as loaded");
                    player.getWrappedPlayer().setPrepared(true);
                    if (!player.getWrappedPlayer().getPlaying()) continue;
                    player.getWrappedPlayer().handleLog("Delayed start of " + player);
                    player.start();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }
}

