/*
 * Decompiled with CFR 0.152.
 */
package xyz.luan.audioplayers.player;

import android.content.Context;
import android.media.AudioManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.luan.audioplayers.AudioContextAndroid;
import xyz.luan.audioplayers.AudioplayersPlugin;
import xyz.luan.audioplayers.EventHandler;
import xyz.luan.audioplayers.PlayerMode;
import xyz.luan.audioplayers.ReleaseMode;
import xyz.luan.audioplayers.player.FocusManager;
import xyz.luan.audioplayers.player.MediaPlayerPlayer;
import xyz.luan.audioplayers.player.Player;
import xyz.luan.audioplayers.player.SoundPoolManager;
import xyz.luan.audioplayers.player.SoundPoolPlayer;
import xyz.luan.audioplayers.source.Source;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010H\u001a\u00020AH\u0002J\b\u0010I\u001a\u00020\u0013H\u0002J\u000e\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u0007J\r\u0010M\u001a\u0004\u0018\u00010A\u00a2\u0006\u0002\u0010NJ\r\u0010O\u001a\u0004\u0018\u00010A\u00a2\u0006\u0002\u0010NJ\u0006\u0010P\u001a\u00020.J\u0006\u0010Y\u001a\u00020KJ\b\u0010Z\u001a\u00020KH\u0002J\u0006\u0010[\u001a\u00020KJ\u0006\u0010\\\u001a\u00020KJ\u0006\u0010]\u001a\u00020KJ\u000e\u0010^\u001a\u00020K2\u0006\u0010_\u001a\u00020AJ\u0006\u0010`\u001a\u00020KJ\u0006\u0010a\u001a\u00020KJ\u000e\u0010b\u001a\u00020K2\u0006\u0010c\u001a\u00020AJ\u0006\u0010d\u001a\u00020KJ\u000e\u0010e\u001a\u00020K2\u0006\u0010f\u001a\u00020gJ$\u0010h\u001a\u00020K2\b\u0010i\u001a\u0004\u0018\u00010g2\b\u0010j\u001a\u0004\u0018\u00010g2\b\u0010k\u001a\u0004\u0018\u00010\u0001J\u0016\u0010l\u001a\u00020.2\u0006\u0010m\u001a\u00020A2\u0006\u0010n\u001a\u00020AJ\b\u0010o\u001a\u00020\u0013H\u0002J\b\u0010p\u001a\u00020KH\u0002J\f\u0010q\u001a\u00020K*\u00020\u0013H\u0002J\u001c\u0010r\u001a\u00020K*\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0006\u0010s\u001a\u00020KR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010!\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R$\u0010$\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R$\u0010(\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020'@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010/R$\u00101\u001a\u0002002\u0006\u0010\u0014\u001a\u000200@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010/\"\u0004\b8\u00109R$\u0010:\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020.@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010/\"\u0004\b<\u00109R\u001a\u0010=\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010/\"\u0004\b?\u00109R\u001a\u0010@\u001a\u00020AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010Q\u001a\u00020R8F\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u0011\u0010U\u001a\u00020V8F\u00a2\u0006\u0006\u001a\u0004\bW\u0010X\u00a8\u0006t"}, d2={"Lxyz/luan/audioplayers/player/WrappedPlayer;", "", "ref", "Lxyz/luan/audioplayers/AudioplayersPlugin;", "eventHandler", "Lxyz/luan/audioplayers/EventHandler;", "context", "Lxyz/luan/audioplayers/AudioContextAndroid;", "soundPoolManager", "Lxyz/luan/audioplayers/player/SoundPoolManager;", "<init>", "(Lxyz/luan/audioplayers/AudioplayersPlugin;Lxyz/luan/audioplayers/EventHandler;Lxyz/luan/audioplayers/AudioContextAndroid;Lxyz/luan/audioplayers/player/SoundPoolManager;)V", "getEventHandler", "()Lxyz/luan/audioplayers/EventHandler;", "getContext", "()Lxyz/luan/audioplayers/AudioContextAndroid;", "setContext", "(Lxyz/luan/audioplayers/AudioContextAndroid;)V", "player", "Lxyz/luan/audioplayers/player/Player;", "value", "Lxyz/luan/audioplayers/source/Source;", "source", "getSource", "()Lxyz/luan/audioplayers/source/Source;", "setSource", "(Lxyz/luan/audioplayers/source/Source;)V", "", "volume", "getVolume", "()F", "setVolume", "(F)V", "balance", "getBalance", "setBalance", "rate", "getRate", "setRate", "Lxyz/luan/audioplayers/ReleaseMode;", "releaseMode", "getReleaseMode", "()Lxyz/luan/audioplayers/ReleaseMode;", "setReleaseMode", "(Lxyz/luan/audioplayers/ReleaseMode;)V", "isLooping", "", "()Z", "Lxyz/luan/audioplayers/PlayerMode;", "playerMode", "getPlayerMode", "()Lxyz/luan/audioplayers/PlayerMode;", "setPlayerMode", "(Lxyz/luan/audioplayers/PlayerMode;)V", "released", "getReleased", "setReleased", "(Z)V", "prepared", "getPrepared", "setPrepared", "playing", "getPlaying", "setPlaying", "shouldSeekTo", "", "getShouldSeekTo", "()I", "setShouldSeekTo", "(I)V", "focusManager", "Lxyz/luan/audioplayers/player/FocusManager;", "maybeGetCurrentPosition", "getOrCreatePlayer", "updateAudioContext", "", "audioContext", "getDuration", "()Ljava/lang/Integer;", "getCurrentPosition", "isActuallyPlaying", "applicationContext", "Landroid/content/Context;", "getApplicationContext", "()Landroid/content/Context;", "audioManager", "Landroid/media/AudioManager;", "getAudioManager", "()Landroid/media/AudioManager;", "play", "actuallyPlay", "stop", "release", "pause", "seek", "position", "onPrepared", "onCompletion", "onBuffering", "percent", "onSeekComplete", "handleLog", "message", "", "handleError", "errorCode", "errorMessage", "errorDetails", "onError", "what", "extra", "createPlayer", "initPlayer", "configAndPrepare", "setVolumeAndBalance", "dispose", "audioplayers_android_release"})
@SourceDebugExtension(value={"SMAP\nWrappedPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrappedPlayer.kt\nxyz/luan/audioplayers/player/WrappedPlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,385:1\n1#2:386\n*E\n"})
public final class WrappedPlayer {
    @NotNull
    private final AudioplayersPlugin ref;
    @NotNull
    private final EventHandler eventHandler;
    @NotNull
    private AudioContextAndroid context;
    @NotNull
    private final SoundPoolManager soundPoolManager;
    @Nullable
    private Player player;
    @Nullable
    private Source source;
    private float volume;
    private float balance;
    private float rate;
    @NotNull
    private ReleaseMode releaseMode;
    @NotNull
    private PlayerMode playerMode;
    private boolean released;
    private boolean prepared;
    private boolean playing;
    private int shouldSeekTo;
    @NotNull
    private final FocusManager focusManager;

    public WrappedPlayer(@NotNull AudioplayersPlugin ref, @NotNull EventHandler eventHandler, @NotNull AudioContextAndroid context, @NotNull SoundPoolManager soundPoolManager) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)soundPoolManager, (String)"soundPoolManager");
        this.ref = ref;
        this.eventHandler = eventHandler;
        this.context = context;
        this.soundPoolManager = soundPoolManager;
        this.volume = 1.0f;
        this.rate = 1.0f;
        this.releaseMode = ReleaseMode.RELEASE;
        this.playerMode = PlayerMode.MEDIA_PLAYER;
        this.released = true;
        this.shouldSeekTo = -1;
        this.focusManager = new FocusManager(this);
    }

    @NotNull
    public final EventHandler getEventHandler() {
        return this.eventHandler;
    }

    @NotNull
    public final AudioContextAndroid getContext() {
        return this.context;
    }

    public final void setContext(@NotNull AudioContextAndroid audioContextAndroid) {
        Intrinsics.checkNotNullParameter((Object)audioContextAndroid, (String)"<set-?>");
        this.context = audioContextAndroid;
    }

    @Nullable
    public final Source getSource() {
        return this.source;
    }

    public final void setSource(@Nullable Source value) {
        if (!Intrinsics.areEqual((Object)this.source, (Object)value)) {
            if (value != null) {
                Player player = this.getOrCreatePlayer();
                player.setSource(value);
                this.configAndPrepare(player);
            } else {
                this.released = true;
                this.setPrepared(false);
                this.playing = false;
                Player player = this.player;
                if (player != null) {
                    player.release();
                }
            }
            this.source = value;
        } else {
            this.ref.handlePrepared(this, true);
        }
    }

    public final float getVolume() {
        return this.volume;
    }

    public final void setVolume(float value) {
        block2: {
            if (this.volume == value) break block2;
            this.volume = value;
            if (!this.released) {
                Player player = this.player;
                if (player != null) {
                    this.setVolumeAndBalance(player, value, this.balance);
                }
            }
        }
    }

    public final float getBalance() {
        return this.balance;
    }

    public final void setBalance(float value) {
        block2: {
            if (this.balance == value) break block2;
            this.balance = value;
            if (!this.released) {
                Player player = this.player;
                if (player != null) {
                    this.setVolumeAndBalance(player, this.volume, value);
                }
            }
        }
    }

    public final float getRate() {
        return this.rate;
    }

    public final void setRate(float value) {
        block2: {
            if (this.rate == value) break block2;
            this.rate = value;
            if (this.playing) {
                Player player = this.player;
                if (player != null) {
                    player.setRate(value);
                }
            }
        }
    }

    @NotNull
    public final ReleaseMode getReleaseMode() {
        return this.releaseMode;
    }

    public final void setReleaseMode(@NotNull ReleaseMode value) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            if (this.releaseMode == value) break block2;
            this.releaseMode = value;
            if (!this.released) {
                Player player = this.player;
                if (player != null) {
                    player.setLooping(this.isLooping());
                }
            }
        }
    }

    public final boolean isLooping() {
        return this.releaseMode == ReleaseMode.LOOP;
    }

    @NotNull
    public final PlayerMode getPlayerMode() {
        return this.playerMode;
    }

    public final void setPlayerMode(@NotNull PlayerMode value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.playerMode != value) {
            this.playerMode = value;
            Player player = this.player;
            if (player != null) {
                Player it = player;
                boolean bl = false;
                this.shouldSeekTo = this.maybeGetCurrentPosition();
                this.setPrepared(false);
                it.release();
            }
            this.initPlayer();
        }
    }

    public final boolean getReleased() {
        return this.released;
    }

    public final void setReleased(boolean bl) {
        this.released = bl;
    }

    public final boolean getPrepared() {
        return this.prepared;
    }

    public final void setPrepared(boolean value) {
        if (this.prepared != value) {
            this.prepared = value;
            this.ref.handlePrepared(this, value);
        }
    }

    public final boolean getPlaying() {
        return this.playing;
    }

    public final void setPlaying(boolean bl) {
        this.playing = bl;
    }

    public final int getShouldSeekTo() {
        return this.shouldSeekTo;
    }

    public final void setShouldSeekTo(int n) {
        this.shouldSeekTo = n;
    }

    private final int maybeGetCurrentPosition() {
        Object object;
        Object object2 = this;
        try {
            Integer n;
            WrappedPlayer $this$maybeGetCurrentPosition_u24lambda_u240 = object2;
            boolean bl = false;
            Player player = $this$maybeGetCurrentPosition_u24lambda_u240.player;
            Integer it = n = player != null ? player.getCurrentPosition() : null;
            boolean bl2 = false;
            Integer n2 = it;
            object = Result.constructor-impl((Object)(!(n2 != null && n2 == 0) ? n : null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Integer n = (Integer)(Result.isFailure-impl((Object)object2) ? null : object2);
        return n != null ? n : -1;
    }

    private final Player getOrCreatePlayer() {
        Player player;
        Player currentPlayer = this.player;
        if (this.released || currentPlayer == null) {
            Player player2;
            Player it = player2 = this.createPlayer();
            boolean bl = false;
            this.player = it;
            this.released = false;
            player = player2;
        } else if (this.prepared) {
            Player player3;
            Player it = player3 = currentPlayer;
            boolean bl = false;
            it.reset();
            this.setPrepared(false);
            player = player3;
        } else {
            player = currentPlayer;
        }
        return player;
    }

    public final void updateAudioContext(@NotNull AudioContextAndroid audioContext) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)audioContext, (String)"audioContext");
            if (Intrinsics.areEqual((Object)this.context, (Object)audioContext)) {
                return;
            }
            if (this.context.getAudioFocus() != 0 && audioContext.getAudioFocus() == 0) {
                this.focusManager.handleStop();
            }
            this.context = AudioContextAndroid.copy$default(audioContext, false, false, 0, 0, 0, 0, 63, null);
            this.getAudioManager().setMode(this.context.getAudioMode());
            this.getAudioManager().setSpeakerphoneOn(this.context.isSpeakerphoneOn());
            Player player = this.player;
            if (player == null) break block3;
            Player p = player;
            boolean bl = false;
            p.stop();
            this.setPrepared(false);
            p.updateContext(this.context);
            Source source = this.source;
            if (source != null) {
                Source it = source;
                boolean bl2 = false;
                p.setSource(it);
                this.configAndPrepare(p);
            }
        }
    }

    @Nullable
    public final Integer getDuration() {
        Integer n;
        if (this.prepared) {
            Player player = this.player;
            n = player != null ? player.getDuration() : null;
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public final Integer getCurrentPosition() {
        Integer n;
        if (this.prepared) {
            Player player = this.player;
            n = player != null ? player.getCurrentPosition() : null;
        } else {
            n = null;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isActuallyPlaying() {
        if (!this.playing) return false;
        if (!this.prepared) return false;
        Player player = this.player;
        if (player == null) return false;
        if (!player.isActuallyPlaying()) return false;
        return true;
    }

    @NotNull
    public final Context getApplicationContext() {
        return this.ref.getApplicationContext();
    }

    @NotNull
    public final AudioManager getAudioManager() {
        return this.ref.getAudioManager();
    }

    public final void play() {
        this.focusManager.maybeRequestAudioFocus((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                WrappedPlayer.access$actuallyPlay((WrappedPlayer)this.receiver);
            }
        }));
    }

    private final void actuallyPlay() {
        if (!this.playing && !this.released) {
            Player currentPlayer = this.player;
            this.playing = true;
            if (currentPlayer == null) {
                this.initPlayer();
            } else if (this.prepared) {
                currentPlayer.start();
                this.ref.handleIsPlaying();
            }
        }
    }

    public final void stop() {
        this.focusManager.handleStop();
        if (this.released) {
            return;
        }
        if (this.releaseMode != ReleaseMode.RELEASE) {
            this.pause();
            if (this.prepared) {
                Player player = this.player;
                boolean bl = player != null ? player.isLiveStream() : false;
                if (bl) {
                    Player player2 = this.player;
                    if (player2 != null) {
                        player2.stop();
                    }
                    this.setPrepared(false);
                    Player player3 = this.player;
                    if (player3 != null) {
                        player3.prepare();
                    }
                } else {
                    this.seek(0);
                }
            }
        } else {
            this.release();
        }
    }

    public final void release() {
        this.focusManager.handleStop();
        if (this.released) {
            return;
        }
        if (this.playing) {
            Player player = this.player;
            if (player != null) {
                player.stop();
            }
        }
        this.setSource(null);
        this.player = null;
    }

    public final void pause() {
        block2: {
            if (!this.playing) break block2;
            this.playing = false;
            if (this.prepared) {
                Player player = this.player;
                if (player != null) {
                    player.pause();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void seek(int position) {
        if (!this.prepared) ** GOTO lbl-1000
        v0 = this.player;
        if (!(v0 != null ? v0.isLiveStream() : false)) {
            v1 = this.player;
            if (v1 != null) {
                v1.seekTo(position);
            }
            v2 = -1;
        } else lbl-1000:
        // 2 sources

        {
            v2 = position;
        }
        this.shouldSeekTo = v2;
    }

    public final void onPrepared() {
        block4: {
            this.setPrepared(true);
            this.ref.handleDuration(this);
            if (this.playing) {
                Player player = this.player;
                if (player != null) {
                    player.start();
                }
                this.ref.handleIsPlaying();
            }
            if (this.shouldSeekTo < 0) break block4;
            Player player = this.player;
            if (!(player != null ? player.isLiveStream() : false)) {
                Player player2 = this.player;
                if (player2 != null) {
                    player2.seekTo(this.shouldSeekTo);
                }
            }
        }
    }

    public final void onCompletion() {
        if (this.releaseMode != ReleaseMode.LOOP) {
            this.stop();
        }
        this.ref.handleComplete(this);
    }

    public final void onBuffering(int percent) {
    }

    public final void onSeekComplete() {
        this.ref.handleSeekComplete(this);
    }

    public final void handleLog(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.ref.handleLog(this, message);
    }

    public final void handleError(@Nullable String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
        this.ref.handleError(this, errorCode, errorMessage, errorDetails);
    }

    public final boolean onError(int what, int extra) {
        String extraMsg;
        String whatMsg = what == 100 ? "MEDIA_ERROR_SERVER_DIED" : "MEDIA_ERROR_UNKNOWN {what:" + what + '}';
        switch (extra) {
            case -2147483648: {
                String string = "MEDIA_ERROR_SYSTEM";
                break;
            }
            case -1004: {
                String string = "MEDIA_ERROR_IO";
                break;
            }
            case -1007: {
                String string = "MEDIA_ERROR_MALFORMED";
                break;
            }
            case -1010: {
                String string = "MEDIA_ERROR_UNSUPPORTED";
                break;
            }
            case -110: {
                String string = "MEDIA_ERROR_TIMED_OUT";
                break;
            }
            default: {
                String string = extraMsg = "MEDIA_ERROR_UNKNOWN {extra:" + extra + '}';
            }
        }
        if (!this.prepared && Intrinsics.areEqual((Object)extraMsg, (Object)"MEDIA_ERROR_SYSTEM")) {
            this.handleError("AndroidAudioError", "Failed to set source. For troubleshooting, see: https://github.com/bluefireteam/audioplayers/blob/main/troubleshooting.md", whatMsg + ", " + extraMsg);
        } else {
            this.setPrepared(false);
            this.handleError("AndroidAudioError", whatMsg, extraMsg);
        }
        return false;
    }

    private final Player createPlayer() {
        Player player;
        switch (WhenMappings.$EnumSwitchMapping$0[this.playerMode.ordinal()]) {
            case 1: {
                player = new MediaPlayerPlayer(this);
                break;
            }
            case 2: {
                player = new SoundPoolPlayer(this, this.soundPoolManager);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return player;
    }

    private final void initPlayer() {
        block0: {
            Player player;
            this.player = player = this.createPlayer();
            Source source = this.source;
            if (source == null) break block0;
            Source it = source;
            boolean bl = false;
            player.setSource(it);
            this.configAndPrepare(player);
        }
    }

    private final void configAndPrepare(Player $this$configAndPrepare) {
        this.setVolumeAndBalance($this$configAndPrepare, this.volume, this.balance);
        $this$configAndPrepare.setLooping(this.isLooping());
        $this$configAndPrepare.prepare();
    }

    private final void setVolumeAndBalance(Player $this$setVolumeAndBalance, float volume, float balance) {
        float leftVolume = Math.min(1.0f, 1.0f - balance) * volume;
        float rightVolume = Math.min(1.0f, 1.0f + balance) * volume;
        $this$setVolumeAndBalance.setVolume(leftVolume, rightVolume);
    }

    public final void dispose() {
        this.release();
        this.eventHandler.dispose();
    }

    public static final /* synthetic */ void access$actuallyPlay(WrappedPlayer $this) {
        $this.actuallyPlay();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlayerMode.values().length];
            try {
                nArray[PlayerMode.MEDIA_PLAYER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerMode.LOW_LATENCY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

