/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import io.flutter.plugins.camera.CameraState;
import io.flutter.plugins.camera.types.CameraCaptureProperties;
import io.flutter.plugins.camera.types.CaptureTimeoutsWrapper;

class CameraCaptureCallback
extends CameraCaptureSession.CaptureCallback {
    private static final String TAG = "CameraCaptureCallback";
    private final CameraCaptureStateListener cameraStateListener;
    private CameraState cameraState;
    private final CaptureTimeoutsWrapper captureTimeouts;
    private final CameraCaptureProperties captureProps;
    @VisibleForTesting
    @NonNull
    CaptureResult.Key<Integer> aeStateKey = CaptureResult.CONTROL_AE_STATE;
    @VisibleForTesting
    @NonNull
    CaptureResult.Key<Integer> afStateKey = CaptureResult.CONTROL_AF_STATE;

    private CameraCaptureCallback(@NonNull CameraCaptureStateListener cameraStateListener, @NonNull CaptureTimeoutsWrapper captureTimeouts, @NonNull CameraCaptureProperties captureProps) {
        this.cameraState = CameraState.STATE_PREVIEW;
        this.cameraStateListener = cameraStateListener;
        this.captureTimeouts = captureTimeouts;
        this.captureProps = captureProps;
    }

    public static CameraCaptureCallback create(@NonNull CameraCaptureStateListener cameraStateListener, @NonNull CaptureTimeoutsWrapper captureTimeouts, @NonNull CameraCaptureProperties captureProps) {
        return new CameraCaptureCallback(cameraStateListener, captureTimeouts, captureProps);
    }

    public CameraState getCameraState() {
        return this.cameraState;
    }

    public void setCameraState(@NonNull CameraState state) {
        this.cameraState = state;
    }

    private void process(CaptureResult result) {
        Integer aeState = (Integer)result.get(this.aeStateKey);
        Integer afState = (Integer)result.get(this.afStateKey);
        if (result instanceof TotalCaptureResult) {
            Float lensAperture = (Float)result.get(CaptureResult.LENS_APERTURE);
            Long sensorExposureTime = (Long)result.get(CaptureResult.SENSOR_EXPOSURE_TIME);
            Integer sensorSensitivity = (Integer)result.get(CaptureResult.SENSOR_SENSITIVITY);
            this.captureProps.setLastLensAperture(lensAperture);
            this.captureProps.setLastSensorExposureTime(sensorExposureTime);
            this.captureProps.setLastSensorSensitivity(sensorSensitivity);
        }
        if (this.cameraState != CameraState.STATE_PREVIEW) {
            Log.d((String)TAG, (String)("CameraCaptureCallback | state: " + (Object)((Object)this.cameraState) + " | afState: " + afState + " | aeState: " + aeState));
        }
        switch (this.cameraState) {
            case STATE_PREVIEW: {
                break;
            }
            case STATE_WAITING_FOCUS: {
                if (afState == null) {
                    return;
                }
                if (afState == 4 || afState == 5) {
                    this.handleWaitingFocusState(aeState);
                    break;
                }
                if (!this.captureTimeouts.getPreCaptureFocusing().getIsExpired()) break;
                Log.w((String)TAG, (String)"Focus timeout, moving on with capture");
                this.handleWaitingFocusState(aeState);
                break;
            }
            case STATE_WAITING_PRECAPTURE_START: {
                if (aeState == null || aeState == 2 || aeState == 5 || aeState == 4) {
                    this.setCameraState(CameraState.STATE_WAITING_PRECAPTURE_DONE);
                    break;
                }
                if (!this.captureTimeouts.getPreCaptureMetering().getIsExpired()) break;
                Log.w((String)TAG, (String)"Metering timeout waiting for pre-capture to start, moving on with capture");
                this.setCameraState(CameraState.STATE_WAITING_PRECAPTURE_DONE);
                break;
            }
            case STATE_WAITING_PRECAPTURE_DONE: {
                if (aeState == null || aeState != 5) {
                    this.cameraStateListener.onConverged();
                    break;
                }
                if (!this.captureTimeouts.getPreCaptureMetering().getIsExpired()) break;
                Log.w((String)TAG, (String)"Metering timeout waiting for pre-capture to finish, moving on with capture");
                this.cameraStateListener.onConverged();
            }
        }
    }

    private void handleWaitingFocusState(Integer aeState) {
        if (aeState == null || aeState == 2) {
            this.cameraStateListener.onConverged();
        } else {
            this.cameraStateListener.onPrecapture();
        }
    }

    public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
        this.process(partialResult);
    }

    public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        this.process((CaptureResult)result);
    }

    static interface CameraCaptureStateListener {
        public void onConverged();

        public void onPrecapture();
    }
}

