/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.media.Image;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ImageSaver
implements Runnable {
    private final Image image;
    private final File file;
    private final Callback callback;

    ImageSaver(@NonNull Image image, @NonNull File file, @NonNull Callback callback) {
        this.image = image;
        this.file = file;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ByteBuffer buffer = this.image.getPlanes()[0].getBuffer();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        FileOutputStream output = null;
        try {
            output = FileOutputStreamFactory.create(this.file);
            output.write(bytes);
            this.callback.onComplete(this.file.getAbsolutePath());
        }
        catch (IOException e) {
            this.callback.onError("IOError", "Failed saving image");
        }
        finally {
            this.image.close();
            if (null != output) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    this.callback.onError("cameraAccess", e.getMessage());
                }
            }
        }
    }

    public static interface Callback {
        public void onComplete(@NonNull String var1);

        public void onError(@NonNull String var1, @NonNull String var2);
    }

    static class FileOutputStreamFactory {
        FileOutputStreamFactory() {
        }

        @VisibleForTesting
        public static FileOutputStream create(File file) throws FileNotFoundException {
            return new FileOutputStream(file);
        }
    }
}

