/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Messages {
    @NonNull
    protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
        ArrayList<Object> errorList = new ArrayList<Object>(3);
        if (exception instanceof FlutterError) {
            FlutterError error = (FlutterError)exception;
            errorList.add(error.code);
            errorList.add(error.getMessage());
            errorList.add(error.details);
        } else {
            errorList.add(exception.toString());
            errorList.add(exception.getClass().getSimpleName());
            errorList.add("Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString((Throwable)exception));
        }
        return errorList;
    }

    @NonNull
    protected static FlutterError createConnectionError(@NonNull String channelName) {
        return new FlutterError("channel-error", "Unable to establish connection on channel: " + channelName + ".", "");
    }

    public static class FlutterError
    extends RuntimeException {
        public final String code;
        public final Object details;

        public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
            super(message);
            this.code = code;
            this.details = details;
        }
    }

    public static class CameraEventApi {
        @NonNull
        private final BinaryMessenger binaryMessenger;
        private final String messageChannelSuffix;

        public CameraEventApi(@NonNull BinaryMessenger argBinaryMessenger) {
            this(argBinaryMessenger, "");
        }

        public CameraEventApi(@NonNull BinaryMessenger argBinaryMessenger, @NonNull String messageChannelSuffix) {
            this.binaryMessenger = argBinaryMessenger;
            this.messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
        }

        @NonNull
        static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public void initialized(@NonNull PlatformCameraState initialStateArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.camera_android.CameraEventApi.initialized" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, CameraEventApi.getCodec());
            channel.send(new ArrayList<PlatformCameraState>(Collections.singletonList(initialStateArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void error(@NonNull String messageArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.camera_android.CameraEventApi.error" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, CameraEventApi.getCodec());
            channel.send(new ArrayList<String>(Collections.singletonList(messageArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }

        public void closed(@NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.camera_android.CameraEventApi.closed" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, CameraEventApi.getCodec());
            channel.send(null, channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }
    }

    public static class CameraGlobalEventApi {
        @NonNull
        private final BinaryMessenger binaryMessenger;
        private final String messageChannelSuffix;

        public CameraGlobalEventApi(@NonNull BinaryMessenger argBinaryMessenger) {
            this(argBinaryMessenger, "");
        }

        public CameraGlobalEventApi(@NonNull BinaryMessenger argBinaryMessenger, @NonNull String messageChannelSuffix) {
            this.binaryMessenger = argBinaryMessenger;
            this.messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
        }

        @NonNull
        static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public void deviceOrientationChanged(@NonNull PlatformDeviceOrientation orientationArg, @NonNull VoidResult result) {
            String channelName = "dev.flutter.pigeon.camera_android.CameraGlobalEventApi.deviceOrientationChanged" + this.messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(this.binaryMessenger, channelName, CameraGlobalEventApi.getCodec());
            channel.send(new ArrayList<PlatformDeviceOrientation>(Collections.singletonList(orientationArg)), channelReply -> {
                if (channelReply instanceof List) {
                    List listReply = (List)channelReply;
                    if (listReply.size() > 1) {
                        result.error(new FlutterError((String)listReply.get(0), (String)listReply.get(1), listReply.get(2)));
                    } else {
                        result.success();
                    }
                } else {
                    result.error(Messages.createConnectionError(channelName));
                }
            });
        }
    }

    public static interface CameraApi {
        @NonNull
        public List<PlatformCameraDescription> getAvailableCameras();

        public void create(@NonNull String var1, @NonNull PlatformMediaSettings var2, @NonNull Result<Long> var3);

        public void initialize(@NonNull PlatformImageFormatGroup var1);

        public void dispose();

        public void lockCaptureOrientation(@NonNull PlatformDeviceOrientation var1);

        public void unlockCaptureOrientation();

        public void takePicture(@NonNull Result<String> var1);

        public void startVideoRecording(@NonNull Boolean var1);

        @NonNull
        public String stopVideoRecording();

        public void pauseVideoRecording();

        public void resumeVideoRecording();

        public void startImageStream();

        public void stopImageStream();

        public void setFlashMode(@NonNull PlatformFlashMode var1, @NonNull VoidResult var2);

        public void setExposureMode(@NonNull PlatformExposureMode var1, @NonNull VoidResult var2);

        public void setExposurePoint(@Nullable PlatformPoint var1, @NonNull VoidResult var2);

        @NonNull
        public Double getMinExposureOffset();

        @NonNull
        public Double getMaxExposureOffset();

        @NonNull
        public Double getExposureOffsetStepSize();

        public void setExposureOffset(@NonNull Double var1, @NonNull Result<Double> var2);

        public void setFocusMode(@NonNull PlatformFocusMode var1);

        public void setFocusPoint(@Nullable PlatformPoint var1, @NonNull VoidResult var2);

        @NonNull
        public Double getMaxZoomLevel();

        @NonNull
        public Double getMinZoomLevel();

        public void setZoomLevel(@NonNull Double var1, @NonNull VoidResult var2);

        public void pausePreview();

        public void resumePreview();

        public void setDescriptionWhileRecording(@NonNull String var1);

        @NonNull
        public static MessageCodec<Object> getCodec() {
            return PigeonCodec.INSTANCE;
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable CameraApi api) {
            CameraApi.setUp(binaryMessenger, "", api);
        }

        public static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable CameraApi api) {
            messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
            BasicMessageChannel channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.getAvailableCameras" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<List<PlatformCameraDescription>>();
                    try {
                        List<PlatformCameraDescription> output = api.getAvailableCameras();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.create" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    String cameraNameArg = (String)args.get(0);
                    PlatformMediaSettings mediaSettingsArg = (PlatformMediaSettings)args.get(1);
                    Result<Long> resultCallback = new Result<Long>(){

                        @Override
                        public void success(Long result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.create(cameraNameArg, mediaSettingsArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.initialize" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    PlatformImageFormatGroup imageFormatArg = (PlatformImageFormatGroup)((Object)((Object)args.get(0)));
                    try {
                        api.initialize(imageFormatArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.dispose" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    try {
                        api.dispose();
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.lockCaptureOrientation" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    PlatformDeviceOrientation orientationArg = (PlatformDeviceOrientation)((Object)((Object)args.get(0)));
                    try {
                        api.lockCaptureOrientation(orientationArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.unlockCaptureOrientation" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    try {
                        api.unlockCaptureOrientation();
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.takePicture" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    Result<String> resultCallback = new Result<String>(){

                        @Override
                        public void success(String result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.takePicture(resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.startVideoRecording" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    Boolean enableStreamArg = (Boolean)args.get(0);
                    try {
                        api.startVideoRecording(enableStreamArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.stopVideoRecording" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<String>();
                    try {
                        String output = api.stopVideoRecording();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.pauseVideoRecording" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    try {
                        api.pauseVideoRecording();
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.resumeVideoRecording" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    try {
                        api.resumeVideoRecording();
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.startImageStream" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    try {
                        api.startImageStream();
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.stopImageStream" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    try {
                        api.stopImageStream();
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.setFlashMode" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PlatformFlashMode flashModeArg = (PlatformFlashMode)((Object)((Object)args.get(0)));
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setFlashMode(flashModeArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.setExposureMode" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PlatformExposureMode exposureModeArg = (PlatformExposureMode)((Object)((Object)args.get(0)));
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setExposureMode(exposureModeArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.setExposurePoint" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PlatformPoint pointArg = (PlatformPoint)args.get(0);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setExposurePoint(pointArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.getMinExposureOffset" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Double>();
                    try {
                        Double output = api.getMinExposureOffset();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.getMaxExposureOffset" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Double>();
                    try {
                        Double output = api.getMaxExposureOffset();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.getExposureOffsetStepSize" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Double>();
                    try {
                        Double output = api.getExposureOffsetStepSize();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.setExposureOffset" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    Double offsetArg = (Double)args.get(0);
                    Result<Double> resultCallback = new Result<Double>(){

                        @Override
                        public void success(Double result) {
                            wrapped.add(0, result);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setExposureOffset(offsetArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.setFocusMode" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    PlatformFocusMode focusModeArg = (PlatformFocusMode)((Object)((Object)args.get(0)));
                    try {
                        api.setFocusMode(focusModeArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.setFocusPoint" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    PlatformPoint pointArg = (PlatformPoint)args.get(0);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setFocusPoint(pointArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.getMaxZoomLevel" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Double>();
                    try {
                        Double output = api.getMaxZoomLevel();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.getMinZoomLevel" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Double>();
                    try {
                        Double output = api.getMinZoomLevel();
                        wrapped.add(0, output);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.setZoomLevel" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    final ArrayList wrapped = new ArrayList();
                    ArrayList args = (ArrayList)message;
                    Double zoomArg = (Double)args.get(0);
                    VoidResult resultCallback = new VoidResult(){

                        @Override
                        public void success() {
                            wrapped.add(0, null);
                            reply.reply((Object)wrapped);
                        }

                        @Override
                        public void error(Throwable error) {
                            ArrayList<Object> wrappedError = Messages.wrapError(error);
                            reply.reply(wrappedError);
                        }
                    };
                    api.setZoomLevel(zoomArg, resultCallback);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.pausePreview" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    try {
                        api.pausePreview();
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.resumePreview" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    try {
                        api.resumePreview();
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
            channel = new BasicMessageChannel(binaryMessenger, "dev.flutter.pigeon.camera_android.CameraApi.setDescriptionWhileRecording" + messageChannelSuffix, CameraApi.getCodec());
            if (api != null) {
                channel.setMessageHandler((message, reply) -> {
                    ArrayList<Object> wrapped = new ArrayList<Object>();
                    ArrayList args = (ArrayList)message;
                    String descriptionArg = (String)args.get(0);
                    try {
                        api.setDescriptionWhileRecording(descriptionArg);
                        wrapped.add(0, null);
                    }
                    catch (Throwable exception) {
                        wrapped = Messages.wrapError(exception);
                    }
                    reply.reply(wrapped);
                });
            } else {
                channel.setMessageHandler(null);
            }
        }
    }

    public static interface VoidResult {
        public void success();

        public void error(@NonNull Throwable var1);
    }

    public static interface NullableResult<T> {
        public void success(@Nullable T var1);

        public void error(@NonNull Throwable var1);
    }

    public static interface Result<T> {
        public void success(@NonNull T var1);

        public void error(@NonNull Throwable var1);
    }

    private static class PigeonCodec
    extends StandardMessageCodec {
        public static final PigeonCodec INSTANCE = new PigeonCodec();

        private PigeonCodec() {
        }

        protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
            switch (type) {
                case -127: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformCameraLensDirection.values()[((Long)value).intValue()];
                }
                case -126: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformDeviceOrientation.values()[((Long)value).intValue()];
                }
                case -125: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformExposureMode.values()[((Long)value).intValue()];
                }
                case -124: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformFocusMode.values()[((Long)value).intValue()];
                }
                case -123: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformResolutionPreset.values()[((Long)value).intValue()];
                }
                case -122: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformImageFormatGroup.values()[((Long)value).intValue()];
                }
                case -121: {
                    Object value = this.readValue(buffer);
                    return value == null ? null : PlatformFlashMode.values()[((Long)value).intValue()];
                }
                case -120: {
                    return PlatformCameraDescription.fromList((ArrayList)this.readValue(buffer));
                }
                case -119: {
                    return PlatformCameraState.fromList((ArrayList)this.readValue(buffer));
                }
                case -118: {
                    return PlatformSize.fromList((ArrayList)this.readValue(buffer));
                }
                case -117: {
                    return PlatformPoint.fromList((ArrayList)this.readValue(buffer));
                }
                case -116: {
                    return PlatformMediaSettings.fromList((ArrayList)this.readValue(buffer));
                }
            }
            return super.readValueOfType(type, buffer);
        }

        protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
            if (value instanceof PlatformCameraLensDirection) {
                stream.write(129);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformCameraLensDirection)((Object)value)).index));
            } else if (value instanceof PlatformDeviceOrientation) {
                stream.write(130);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformDeviceOrientation)((Object)value)).index));
            } else if (value instanceof PlatformExposureMode) {
                stream.write(131);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformExposureMode)((Object)value)).index));
            } else if (value instanceof PlatformFocusMode) {
                stream.write(132);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformFocusMode)((Object)value)).index));
            } else if (value instanceof PlatformResolutionPreset) {
                stream.write(133);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformResolutionPreset)((Object)value)).index));
            } else if (value instanceof PlatformImageFormatGroup) {
                stream.write(134);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformImageFormatGroup)((Object)value)).index));
            } else if (value instanceof PlatformFlashMode) {
                stream.write(135);
                this.writeValue(stream, value == null ? null : Integer.valueOf(((PlatformFlashMode)((Object)value)).index));
            } else if (value instanceof PlatformCameraDescription) {
                stream.write(136);
                this.writeValue(stream, ((PlatformCameraDescription)value).toList());
            } else if (value instanceof PlatformCameraState) {
                stream.write(137);
                this.writeValue(stream, ((PlatformCameraState)value).toList());
            } else if (value instanceof PlatformSize) {
                stream.write(138);
                this.writeValue(stream, ((PlatformSize)value).toList());
            } else if (value instanceof PlatformPoint) {
                stream.write(139);
                this.writeValue(stream, ((PlatformPoint)value).toList());
            } else if (value instanceof PlatformMediaSettings) {
                stream.write(140);
                this.writeValue(stream, ((PlatformMediaSettings)value).toList());
            } else {
                super.writeValue(stream, value);
            }
        }
    }

    public static final class PlatformMediaSettings {
        @NonNull
        private PlatformResolutionPreset resolutionPreset;
        @Nullable
        private Long fps;
        @Nullable
        private Long videoBitrate;
        @Nullable
        private Long audioBitrate;
        @NonNull
        private Boolean enableAudio;

        @NonNull
        public PlatformResolutionPreset getResolutionPreset() {
            return this.resolutionPreset;
        }

        public void setResolutionPreset(@NonNull PlatformResolutionPreset setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"resolutionPreset\" is null.");
            }
            this.resolutionPreset = setterArg;
        }

        @Nullable
        public Long getFps() {
            return this.fps;
        }

        public void setFps(@Nullable Long setterArg) {
            this.fps = setterArg;
        }

        @Nullable
        public Long getVideoBitrate() {
            return this.videoBitrate;
        }

        public void setVideoBitrate(@Nullable Long setterArg) {
            this.videoBitrate = setterArg;
        }

        @Nullable
        public Long getAudioBitrate() {
            return this.audioBitrate;
        }

        public void setAudioBitrate(@Nullable Long setterArg) {
            this.audioBitrate = setterArg;
        }

        @NonNull
        public Boolean getEnableAudio() {
            return this.enableAudio;
        }

        public void setEnableAudio(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"enableAudio\" is null.");
            }
            this.enableAudio = setterArg;
        }

        PlatformMediaSettings() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformMediaSettings that = (PlatformMediaSettings)o;
            return this.resolutionPreset.equals((Object)that.resolutionPreset) && Objects.equals(this.fps, that.fps) && Objects.equals(this.videoBitrate, that.videoBitrate) && Objects.equals(this.audioBitrate, that.audioBitrate) && this.enableAudio.equals(that.enableAudio);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.resolutionPreset, this.fps, this.videoBitrate, this.audioBitrate, this.enableAudio});
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(5);
            toListResult.add((Object)this.resolutionPreset);
            toListResult.add(this.fps);
            toListResult.add(this.videoBitrate);
            toListResult.add(this.audioBitrate);
            toListResult.add(this.enableAudio);
            return toListResult;
        }

        @NonNull
        static PlatformMediaSettings fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformMediaSettings pigeonResult = new PlatformMediaSettings();
            Object resolutionPreset = pigeonVar_list.get(0);
            pigeonResult.setResolutionPreset((PlatformResolutionPreset)((Object)resolutionPreset));
            Object fps = pigeonVar_list.get(1);
            pigeonResult.setFps((Long)fps);
            Object videoBitrate = pigeonVar_list.get(2);
            pigeonResult.setVideoBitrate((Long)videoBitrate);
            Object audioBitrate = pigeonVar_list.get(3);
            pigeonResult.setAudioBitrate((Long)audioBitrate);
            Object enableAudio = pigeonVar_list.get(4);
            pigeonResult.setEnableAudio((Boolean)enableAudio);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PlatformResolutionPreset resolutionPreset;
            @Nullable
            private Long fps;
            @Nullable
            private Long videoBitrate;
            @Nullable
            private Long audioBitrate;
            @Nullable
            private Boolean enableAudio;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setResolutionPreset(@NonNull PlatformResolutionPreset setterArg) {
                this.resolutionPreset = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setFps(@Nullable Long setterArg) {
                this.fps = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setVideoBitrate(@Nullable Long setterArg) {
                this.videoBitrate = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setAudioBitrate(@Nullable Long setterArg) {
                this.audioBitrate = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setEnableAudio(@NonNull Boolean setterArg) {
                this.enableAudio = setterArg;
                return this;
            }

            @NonNull
            public PlatformMediaSettings build() {
                PlatformMediaSettings pigeonReturn = new PlatformMediaSettings();
                pigeonReturn.setResolutionPreset(this.resolutionPreset);
                pigeonReturn.setFps(this.fps);
                pigeonReturn.setVideoBitrate(this.videoBitrate);
                pigeonReturn.setAudioBitrate(this.audioBitrate);
                pigeonReturn.setEnableAudio(this.enableAudio);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformPoint {
        @NonNull
        private Double x;
        @NonNull
        private Double y;

        @NonNull
        public Double getX() {
            return this.x;
        }

        public void setX(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"x\" is null.");
            }
            this.x = setterArg;
        }

        @NonNull
        public Double getY() {
            return this.y;
        }

        public void setY(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"y\" is null.");
            }
            this.y = setterArg;
        }

        PlatformPoint() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformPoint that = (PlatformPoint)o;
            return this.x.equals(that.x) && this.y.equals(that.y);
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.x);
            toListResult.add(this.y);
            return toListResult;
        }

        @NonNull
        static PlatformPoint fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformPoint pigeonResult = new PlatformPoint();
            Object x = pigeonVar_list.get(0);
            pigeonResult.setX((Double)x);
            Object y = pigeonVar_list.get(1);
            pigeonResult.setY((Double)y);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double x;
            @Nullable
            private Double y;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setX(@NonNull Double setterArg) {
                this.x = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setY(@NonNull Double setterArg) {
                this.y = setterArg;
                return this;
            }

            @NonNull
            public PlatformPoint build() {
                PlatformPoint pigeonReturn = new PlatformPoint();
                pigeonReturn.setX(this.x);
                pigeonReturn.setY(this.y);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformSize {
        @NonNull
        private Double width;
        @NonNull
        private Double height;

        @NonNull
        public Double getWidth() {
            return this.width;
        }

        public void setWidth(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"width\" is null.");
            }
            this.width = setterArg;
        }

        @NonNull
        public Double getHeight() {
            return this.height;
        }

        public void setHeight(@NonNull Double setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"height\" is null.");
            }
            this.height = setterArg;
        }

        PlatformSize() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformSize that = (PlatformSize)o;
            return this.width.equals(that.width) && this.height.equals(that.height);
        }

        public int hashCode() {
            return Objects.hash(this.width, this.height);
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(2);
            toListResult.add(this.width);
            toListResult.add(this.height);
            return toListResult;
        }

        @NonNull
        static PlatformSize fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformSize pigeonResult = new PlatformSize();
            Object width = pigeonVar_list.get(0);
            pigeonResult.setWidth((Double)width);
            Object height = pigeonVar_list.get(1);
            pigeonResult.setHeight((Double)height);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private Double width;
            @Nullable
            private Double height;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setWidth(@NonNull Double setterArg) {
                this.width = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setHeight(@NonNull Double setterArg) {
                this.height = setterArg;
                return this;
            }

            @NonNull
            public PlatformSize build() {
                PlatformSize pigeonReturn = new PlatformSize();
                pigeonReturn.setWidth(this.width);
                pigeonReturn.setHeight(this.height);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraState {
        @NonNull
        private PlatformSize previewSize;
        @NonNull
        private PlatformExposureMode exposureMode;
        @NonNull
        private PlatformFocusMode focusMode;
        @NonNull
        private Boolean exposurePointSupported;
        @NonNull
        private Boolean focusPointSupported;

        @NonNull
        public PlatformSize getPreviewSize() {
            return this.previewSize;
        }

        public void setPreviewSize(@NonNull PlatformSize setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"previewSize\" is null.");
            }
            this.previewSize = setterArg;
        }

        @NonNull
        public PlatformExposureMode getExposureMode() {
            return this.exposureMode;
        }

        public void setExposureMode(@NonNull PlatformExposureMode setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"exposureMode\" is null.");
            }
            this.exposureMode = setterArg;
        }

        @NonNull
        public PlatformFocusMode getFocusMode() {
            return this.focusMode;
        }

        public void setFocusMode(@NonNull PlatformFocusMode setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"focusMode\" is null.");
            }
            this.focusMode = setterArg;
        }

        @NonNull
        public Boolean getExposurePointSupported() {
            return this.exposurePointSupported;
        }

        public void setExposurePointSupported(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"exposurePointSupported\" is null.");
            }
            this.exposurePointSupported = setterArg;
        }

        @NonNull
        public Boolean getFocusPointSupported() {
            return this.focusPointSupported;
        }

        public void setFocusPointSupported(@NonNull Boolean setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"focusPointSupported\" is null.");
            }
            this.focusPointSupported = setterArg;
        }

        PlatformCameraState() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraState that = (PlatformCameraState)o;
            return this.previewSize.equals(that.previewSize) && this.exposureMode.equals((Object)that.exposureMode) && this.focusMode.equals((Object)that.focusMode) && this.exposurePointSupported.equals(that.exposurePointSupported) && this.focusPointSupported.equals(that.focusPointSupported);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.previewSize, this.exposureMode, this.focusMode, this.exposurePointSupported, this.focusPointSupported});
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(5);
            toListResult.add(this.previewSize);
            toListResult.add((Object)this.exposureMode);
            toListResult.add((Object)this.focusMode);
            toListResult.add(this.exposurePointSupported);
            toListResult.add(this.focusPointSupported);
            return toListResult;
        }

        @NonNull
        static PlatformCameraState fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraState pigeonResult = new PlatformCameraState();
            Object previewSize = pigeonVar_list.get(0);
            pigeonResult.setPreviewSize((PlatformSize)previewSize);
            Object exposureMode = pigeonVar_list.get(1);
            pigeonResult.setExposureMode((PlatformExposureMode)((Object)exposureMode));
            Object focusMode = pigeonVar_list.get(2);
            pigeonResult.setFocusMode((PlatformFocusMode)((Object)focusMode));
            Object exposurePointSupported = pigeonVar_list.get(3);
            pigeonResult.setExposurePointSupported((Boolean)exposurePointSupported);
            Object focusPointSupported = pigeonVar_list.get(4);
            pigeonResult.setFocusPointSupported((Boolean)focusPointSupported);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private PlatformSize previewSize;
            @Nullable
            private PlatformExposureMode exposureMode;
            @Nullable
            private PlatformFocusMode focusMode;
            @Nullable
            private Boolean exposurePointSupported;
            @Nullable
            private Boolean focusPointSupported;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setPreviewSize(@NonNull PlatformSize setterArg) {
                this.previewSize = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setExposureMode(@NonNull PlatformExposureMode setterArg) {
                this.exposureMode = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setFocusMode(@NonNull PlatformFocusMode setterArg) {
                this.focusMode = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setExposurePointSupported(@NonNull Boolean setterArg) {
                this.exposurePointSupported = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setFocusPointSupported(@NonNull Boolean setterArg) {
                this.focusPointSupported = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraState build() {
                PlatformCameraState pigeonReturn = new PlatformCameraState();
                pigeonReturn.setPreviewSize(this.previewSize);
                pigeonReturn.setExposureMode(this.exposureMode);
                pigeonReturn.setFocusMode(this.focusMode);
                pigeonReturn.setExposurePointSupported(this.exposurePointSupported);
                pigeonReturn.setFocusPointSupported(this.focusPointSupported);
                return pigeonReturn;
            }
        }
    }

    public static final class PlatformCameraDescription {
        @NonNull
        private String name;
        @NonNull
        private PlatformCameraLensDirection lensDirection;
        @NonNull
        private Long sensorOrientation;

        @NonNull
        public String getName() {
            return this.name;
        }

        public void setName(@NonNull String setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"name\" is null.");
            }
            this.name = setterArg;
        }

        @NonNull
        public PlatformCameraLensDirection getLensDirection() {
            return this.lensDirection;
        }

        public void setLensDirection(@NonNull PlatformCameraLensDirection setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"lensDirection\" is null.");
            }
            this.lensDirection = setterArg;
        }

        @NonNull
        public Long getSensorOrientation() {
            return this.sensorOrientation;
        }

        public void setSensorOrientation(@NonNull Long setterArg) {
            if (setterArg == null) {
                throw new IllegalStateException("Nonnull field \"sensorOrientation\" is null.");
            }
            this.sensorOrientation = setterArg;
        }

        PlatformCameraDescription() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformCameraDescription that = (PlatformCameraDescription)o;
            return this.name.equals(that.name) && this.lensDirection.equals((Object)that.lensDirection) && this.sensorOrientation.equals(that.sensorOrientation);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.lensDirection, this.sensorOrientation});
        }

        @NonNull
        ArrayList<Object> toList() {
            ArrayList<Object> toListResult = new ArrayList<Object>(3);
            toListResult.add(this.name);
            toListResult.add((Object)this.lensDirection);
            toListResult.add(this.sensorOrientation);
            return toListResult;
        }

        @NonNull
        static PlatformCameraDescription fromList(@NonNull ArrayList<Object> pigeonVar_list) {
            PlatformCameraDescription pigeonResult = new PlatformCameraDescription();
            Object name = pigeonVar_list.get(0);
            pigeonResult.setName((String)name);
            Object lensDirection = pigeonVar_list.get(1);
            pigeonResult.setLensDirection((PlatformCameraLensDirection)((Object)lensDirection));
            Object sensorOrientation = pigeonVar_list.get(2);
            pigeonResult.setSensorOrientation((Long)sensorOrientation);
            return pigeonResult;
        }

        public static final class Builder {
            @Nullable
            private String name;
            @Nullable
            private PlatformCameraLensDirection lensDirection;
            @Nullable
            private Long sensorOrientation;

            @CanIgnoreReturnValue
            @NonNull
            public Builder setName(@NonNull String setterArg) {
                this.name = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setLensDirection(@NonNull PlatformCameraLensDirection setterArg) {
                this.lensDirection = setterArg;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setSensorOrientation(@NonNull Long setterArg) {
                this.sensorOrientation = setterArg;
                return this;
            }

            @NonNull
            public PlatformCameraDescription build() {
                PlatformCameraDescription pigeonReturn = new PlatformCameraDescription();
                pigeonReturn.setName(this.name);
                pigeonReturn.setLensDirection(this.lensDirection);
                pigeonReturn.setSensorOrientation(this.sensorOrientation);
                return pigeonReturn;
            }
        }
    }

    public static enum PlatformFlashMode {
        OFF(0),
        AUTO(1),
        ALWAYS(2),
        TORCH(3);

        final int index;

        private PlatformFlashMode(int index) {
            this.index = index;
        }
    }

    public static enum PlatformImageFormatGroup {
        YUV420(0),
        JPEG(1),
        NV21(2);

        final int index;

        private PlatformImageFormatGroup(int index) {
            this.index = index;
        }
    }

    public static enum PlatformResolutionPreset {
        LOW(0),
        MEDIUM(1),
        HIGH(2),
        VERY_HIGH(3),
        ULTRA_HIGH(4),
        MAX(5);

        final int index;

        private PlatformResolutionPreset(int index) {
            this.index = index;
        }
    }

    public static enum PlatformFocusMode {
        AUTO(0),
        LOCKED(1);

        final int index;

        private PlatformFocusMode(int index) {
            this.index = index;
        }
    }

    public static enum PlatformExposureMode {
        AUTO(0),
        LOCKED(1);

        final int index;

        private PlatformExposureMode(int index) {
            this.index = index;
        }
    }

    public static enum PlatformDeviceOrientation {
        PORTRAIT_UP(0),
        PORTRAIT_DOWN(1),
        LANDSCAPE_LEFT(2),
        LANDSCAPE_RIGHT(3);

        final int index;

        private PlatformDeviceOrientation(int index) {
            this.index = index;
        }
    }

    public static enum PlatformCameraLensDirection {
        FRONT(0),
        BACK(1),
        EXTERNAL(2);

        final int index;

        private PlatformCameraLensDirection(int index) {
            this.index = index;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    static @interface CanIgnoreReturnValue {
    }
}

