/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import io.flutter.plugins.camera.SdkCapabilityChecker;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class VideoRenderer {
    static String TAG = "VideoRenderer";
    private static final String vertexShaderCode = "  precision highp float;\n            attribute vec3 vertexPosition;\n            attribute vec2 uvs;\n            varying vec2 varUvs;\n            uniform mat4 texMatrix;\n            uniform mat4 mvp;\n\n            void main()\n            {\n                varUvs = (texMatrix * vec4(uvs.x, uvs.y, 0, 1.0)).xy;\n                gl_Position = mvp * vec4(vertexPosition, 1.0);\n            }";
    private static final String fragmentShaderCode = " #extension GL_OES_EGL_image_external : require\n            precision mediump float;\n\n            varying vec2 varUvs;\n            uniform samplerExternalOES texSampler;\n\n            void main()\n            {\n                vec4 c = texture2D(texSampler, varUvs);\n                gl_FragColor = vec4(c.r, c.g, c.b, c.a);\n            }";
    private final int[] textureHandles = new int[1];
    private final float[] vertices = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f};
    private final int[] indices = new int[]{2, 1, 0, 0, 3, 2};
    private int program;
    private int vertexHandle = 0;
    private final int[] bufferHandles = new int[2];
    private int uvsHandle = 0;
    private int texMatrixHandle = 0;
    private int mvpHandle = 0;
    EGLDisplay display;
    EGLContext context;
    EGLSurface surface;
    private Thread thread;
    private final Surface outputSurface;
    SurfaceTexture inputSurfaceTexture;
    private Surface inputSurface;
    private HandlerThread surfaceTextureFrameAvailableHandler;
    final Object surfaceTextureAvailableFrameLock = new Object();
    Boolean surfaceTextureFrameAvailable = false;
    final int recordingWidth;
    final int recordingHeight;
    private int rotation = 0;
    private final Object lock = new Object();
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Surface getInputSurface() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.inputSurface == null) {
                this.lock.wait();
            }
        }
        return this.inputSurface;
    }

    public VideoRenderer(@NonNull Surface outputSurface, int recordingWidth, int recordingHeight, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.outputSurface = outputSurface;
        this.recordingHeight = recordingHeight;
        this.recordingWidth = recordingWidth;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.startOpenGL();
        Log.d((String)TAG, (String)"VideoRenderer setup complete");
    }

    public void close() {
        this.thread.interrupt();
        this.surfaceTextureFrameAvailableHandler.quitSafely();
        this.cleanupOpenGL();
        this.inputSurfaceTexture.release();
    }

    private void cleanupOpenGL() {
        GLES20.glDeleteBuffers((int)2, (int[])this.bufferHandles, (int)0);
        GLES20.glDeleteTextures((int)1, (int[])this.textureHandles, (int)0);
        EGL14.eglDestroyContext((EGLDisplay)this.display, (EGLContext)this.context);
        EGL14.eglDestroySurface((EGLDisplay)this.display, (EGLSurface)this.surface);
        GLES20.glDeleteProgram((int)this.program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configureOpenGL() {
        Object object = this.lock;
        synchronized (object) {
            int[] numConfigs;
            EGLConfig[] configs;
            this.display = EGL14.eglGetDisplay((int)0);
            if (this.display == EGL14.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglDisplay == EGL14.EGL_NO_DISPLAY: " + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
            }
            int[] version = new int[2];
            if (!EGL14.eglInitialize((EGLDisplay)this.display, (int[])version, (int)0, (int[])version, (int)1)) {
                throw new RuntimeException("eglInitialize(): " + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
            }
            String eglExtensions = EGL14.eglQueryString((EGLDisplay)this.display, (int)12373);
            if (!eglExtensions.contains("EGL_ANDROID_presentation_time")) {
                throw new RuntimeException("cannot configure OpenGL. missing EGL_ANDROID_presentation_time");
            }
            int[] attribList = SdkCapabilityChecker.supportsEglRecordableAndroid() ? new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12610, 1, 12344} : new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344};
            if (!EGL14.eglChooseConfig((EGLDisplay)this.display, (int[])attribList, (int)0, (EGLConfig[])(configs = new EGLConfig[1]), (int)0, (int)configs.length, (int[])(numConfigs = new int[1]), (int)0)) {
                throw new RuntimeException(GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
            }
            int err = EGL14.eglGetError();
            if (err != 12288) {
                throw new RuntimeException(GLUtils.getEGLErrorString((int)err));
            }
            int[] ctxAttribs = new int[]{12440, 2, 12344};
            this.context = EGL14.eglCreateContext((EGLDisplay)this.display, (EGLConfig)configs[0], (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])ctxAttribs, (int)0);
            err = EGL14.eglGetError();
            if (err != 12288) {
                throw new RuntimeException(GLUtils.getEGLErrorString((int)err));
            }
            int[] surfaceAttribs = new int[]{12344};
            this.surface = EGL14.eglCreateWindowSurface((EGLDisplay)this.display, (EGLConfig)configs[0], (Object)this.outputSurface, (int[])surfaceAttribs, (int)0);
            err = EGL14.eglGetError();
            if (err != 12288) {
                throw new RuntimeException(GLUtils.getEGLErrorString((int)err));
            }
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.display, (EGLSurface)this.surface, (EGLSurface)this.surface, (EGLContext)this.context)) {
                throw new RuntimeException("eglMakeCurrent(): " + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
            }
            ByteBuffer vertexBuffer = ByteBuffer.allocateDirect(this.vertices.length * 4);
            vertexBuffer.order(ByteOrder.nativeOrder());
            vertexBuffer.asFloatBuffer().put(this.vertices);
            vertexBuffer.asFloatBuffer().position(0);
            ByteBuffer indexBuffer = ByteBuffer.allocateDirect(this.indices.length * 4);
            indexBuffer.order(ByteOrder.nativeOrder());
            indexBuffer.asIntBuffer().put(this.indices);
            indexBuffer.position(0);
            int vertexShader = this.loadShader(35633, vertexShaderCode);
            int fragmentShader = this.loadShader(35632, fragmentShaderCode);
            this.program = GLES20.glCreateProgram();
            GLES20.glAttachShader((int)this.program, (int)vertexShader);
            GLES20.glAttachShader((int)this.program, (int)fragmentShader);
            GLES20.glLinkProgram((int)this.program);
            this.deleteShader(vertexShader);
            this.deleteShader(fragmentShader);
            this.vertexHandle = GLES20.glGetAttribLocation((int)this.program, (String)"vertexPosition");
            this.uvsHandle = GLES20.glGetAttribLocation((int)this.program, (String)"uvs");
            this.texMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"texMatrix");
            this.mvpHandle = GLES20.glGetUniformLocation((int)this.program, (String)"mvp");
            GLES20.glGenBuffers((int)2, (int[])this.bufferHandles, (int)0);
            GLES20.glBindBuffer((int)34962, (int)this.bufferHandles[0]);
            GLES20.glBufferData((int)34962, (int)(this.vertices.length * 4), (Buffer)vertexBuffer, (int)35048);
            GLES20.glBindBuffer((int)34963, (int)this.bufferHandles[1]);
            GLES20.glBufferData((int)34963, (int)(this.indices.length * 4), (Buffer)indexBuffer, (int)35048);
            GLES20.glGenTextures((int)1, (int[])this.textureHandles, (int)0);
            GLES20.glBindTexture((int)36197, (int)this.textureHandles[0]);
            this.inputSurfaceTexture = new SurfaceTexture(this.getTexId());
            this.inputSurfaceTexture.setDefaultBufferSize(this.recordingWidth, this.recordingHeight);
            this.surfaceTextureFrameAvailableHandler = new HandlerThread("FrameHandlerThread");
            this.surfaceTextureFrameAvailableHandler.start();
            this.inputSurface = new Surface(this.inputSurfaceTexture);
            this.inputSurfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    Object object = VideoRenderer.this.surfaceTextureAvailableFrameLock;
                    synchronized (object) {
                        if (VideoRenderer.this.surfaceTextureFrameAvailable.booleanValue()) {
                            Log.w((String)TAG, (String)"Frame available before processing other frames. dropping frames");
                        }
                        VideoRenderer.this.surfaceTextureFrameAvailable = true;
                        VideoRenderer.this.surfaceTextureAvailableFrameLock.notifyAll();
                    }
                }
            }, new Handler(this.surfaceTextureFrameAvailableHandler.getLooper()));
            this.lock.notifyAll();
        }
    }

    private void startOpenGL() {
        Log.d((String)TAG, (String)"Starting OpenGL Thread");
        this.thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VideoRenderer.this.configureOpenGL();
                try {
                    while (!Thread.interrupted()) {
                        Object object = VideoRenderer.this.surfaceTextureAvailableFrameLock;
                        synchronized (object) {
                            while (!VideoRenderer.this.surfaceTextureFrameAvailable.booleanValue()) {
                                VideoRenderer.this.surfaceTextureAvailableFrameLock.wait(500L);
                            }
                            VideoRenderer.this.surfaceTextureFrameAvailable = false;
                        }
                        VideoRenderer.this.inputSurfaceTexture.updateTexImage();
                        float[] surfaceTextureMatrix = new float[16];
                        VideoRenderer.this.inputSurfaceTexture.getTransformMatrix(surfaceTextureMatrix);
                        VideoRenderer.this.draw(VideoRenderer.this.recordingWidth, VideoRenderer.this.recordingHeight, surfaceTextureMatrix);
                    }
                }
                catch (InterruptedException e) {
                    Log.d((String)TAG, (String)"thread interrupted while waiting for frames");
                }
            }
        };
        this.thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        this.thread.start();
    }

    public int getTexId() {
        return this.textureHandles[0];
    }

    @NonNull
    public float[] moveMatrix() {
        float[] m = new float[16];
        Matrix.setIdentityM((float[])m, (int)0);
        Matrix.rotateM((float[])m, (int)0, (float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        return m;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    private int loadShader(int type, String code) {
        int shader = GLES20.glCreateShader((int)type);
        GLES20.glShaderSource((int)shader, (String)code);
        GLES20.glCompileShader((int)shader);
        return shader;
    }

    private void deleteShader(int shader) {
        GLES20.glDeleteShader((int)shader);
    }

    public void draw(int viewportWidth, int viewportHeight, @NonNull float[] texMatrix) {
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glViewport((int)0, (int)0, (int)viewportWidth, (int)viewportHeight);
        GLES20.glUseProgram((int)this.program);
        GLES20.glUniformMatrix4fv((int)this.texMatrixHandle, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.mvpHandle, (int)1, (boolean)false, (float[])this.moveMatrix(), (int)0);
        GLES20.glBindBuffer((int)34962, (int)this.bufferHandles[0]);
        GLES20.glBindBuffer((int)34963, (int)this.bufferHandles[1]);
        GLES20.glEnableVertexAttribArray((int)this.vertexHandle);
        GLES20.glVertexAttribPointer((int)this.vertexHandle, (int)3, (int)5126, (boolean)false, (int)20, (int)0);
        GLES20.glEnableVertexAttribArray((int)this.uvsHandle);
        GLES20.glVertexAttribPointer((int)this.uvsHandle, (int)2, (int)5126, (boolean)false, (int)20, (int)12);
        GLES20.glDrawElements((int)4, (int)6, (int)5125, (int)0);
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.display, (EGLSurface)this.surface, (long)(SystemClock.uptimeMillis() * 1000000L));
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.display, (EGLSurface)this.surface)) {
            Log.w((String)TAG, (String)("eglSwapBuffers() " + GLUtils.getEGLErrorString((int)EGL14.eglGetError())));
        }
    }
}

