/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.features.autofocus;

import android.annotation.SuppressLint;
import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import io.flutter.plugins.camera.CameraProperties;
import io.flutter.plugins.camera.features.CameraFeature;
import io.flutter.plugins.camera.features.autofocus.FocusMode;

public class AutoFocusFeature
extends CameraFeature<FocusMode> {
    @NonNull
    private FocusMode currentSetting = FocusMode.auto;
    private final boolean recordingVideo;

    public AutoFocusFeature(@NonNull CameraProperties cameraProperties, boolean recordingVideo) {
        super(cameraProperties);
        this.recordingVideo = recordingVideo;
    }

    @Override
    @NonNull
    public String getDebugName() {
        return "AutoFocusFeature";
    }

    @Override
    @NonNull
    @SuppressLint(value={"KotlinPropertyAccess"})
    public FocusMode getValue() {
        return this.currentSetting;
    }

    @Override
    public void setValue(@NonNull FocusMode value) {
        this.currentSetting = value;
    }

    @Override
    public boolean checkIsSupported() {
        int[] modes = this.cameraProperties.getControlAutoFocusAvailableModes();
        Float minFocus = this.cameraProperties.getLensInfoMinimumFocusDistance();
        boolean isFixedLength = minFocus == null || minFocus.floatValue() == 0.0f;
        return !isFixedLength && modes.length != 0 && (modes.length != 1 || modes[0] != 0);
    }

    @Override
    public void updateBuilder(@NonNull CaptureRequest.Builder requestBuilder) {
        if (!this.checkIsSupported()) {
            return;
        }
        switch (this.currentSetting) {
            case locked: {
                requestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
                break;
            }
            case auto: {
                requestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)(this.recordingVideo ? 3 : 4));
                break;
            }
        }
    }
}

