/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.features.flash;

import android.annotation.SuppressLint;
import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import io.flutter.plugins.camera.CameraProperties;
import io.flutter.plugins.camera.features.CameraFeature;
import io.flutter.plugins.camera.features.flash.FlashMode;

public class FlashFeature
extends CameraFeature<FlashMode> {
    @NonNull
    private FlashMode currentSetting = FlashMode.auto;

    public FlashFeature(@NonNull CameraProperties cameraProperties) {
        super(cameraProperties);
    }

    @Override
    @NonNull
    public String getDebugName() {
        return "FlashFeature";
    }

    @Override
    @SuppressLint(value={"KotlinPropertyAccess"})
    @NonNull
    public FlashMode getValue() {
        return this.currentSetting;
    }

    @Override
    public void setValue(@NonNull FlashMode value) {
        this.currentSetting = value;
    }

    @Override
    public boolean checkIsSupported() {
        Boolean available = this.cameraProperties.getFlashInfoAvailable();
        return available != null && available != false;
    }

    @Override
    public void updateBuilder(@NonNull CaptureRequest.Builder requestBuilder) {
        if (!this.checkIsSupported()) {
            return;
        }
        switch (this.currentSetting) {
            case off: {
                requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case always: {
                requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)3);
                requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case torch: {
                requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                break;
            }
            case auto: {
                requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            }
        }
    }
}

