/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.features.focuspoint;

import android.annotation.SuppressLint;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.MeteringRectangle;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.plugins.camera.CameraProperties;
import io.flutter.plugins.camera.CameraRegionUtils;
import io.flutter.plugins.camera.features.CameraFeature;
import io.flutter.plugins.camera.features.Point;
import io.flutter.plugins.camera.features.sensororientation.SensorOrientationFeature;

public class FocusPointFeature
extends CameraFeature<Point> {
    private Size cameraBoundaries;
    @Nullable
    private Point focusPoint;
    private MeteringRectangle focusRectangle;
    @NonNull
    private final SensorOrientationFeature sensorOrientationFeature;

    public FocusPointFeature(@NonNull CameraProperties cameraProperties, @NonNull SensorOrientationFeature sensorOrientationFeature) {
        super(cameraProperties);
        this.sensorOrientationFeature = sensorOrientationFeature;
    }

    public void setCameraBoundaries(@NonNull Size cameraBoundaries) {
        this.cameraBoundaries = cameraBoundaries;
        this.buildFocusRectangle();
    }

    @Override
    @NonNull
    public String getDebugName() {
        return "FocusPointFeature";
    }

    @Override
    @SuppressLint(value={"KotlinPropertyAccess"})
    @Nullable
    public Point getValue() {
        return this.focusPoint;
    }

    @Override
    public void setValue(@Nullable Point value) {
        this.focusPoint = value == null || value.x == null || value.y == null ? null : value;
        this.buildFocusRectangle();
    }

    @Override
    public boolean checkIsSupported() {
        Integer supportedRegions = this.cameraProperties.getControlMaxRegionsAutoFocus();
        return supportedRegions != null && supportedRegions > 0;
    }

    @Override
    public void updateBuilder(@NonNull CaptureRequest.Builder requestBuilder) {
        MeteringRectangle[] meteringRectangleArray;
        if (!this.checkIsSupported()) {
            return;
        }
        if (this.focusRectangle == null) {
            meteringRectangleArray = null;
        } else {
            MeteringRectangle[] meteringRectangleArray2 = new MeteringRectangle[1];
            meteringRectangleArray = meteringRectangleArray2;
            meteringRectangleArray2[0] = this.focusRectangle;
        }
        requestBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, meteringRectangleArray);
    }

    private void buildFocusRectangle() {
        if (this.cameraBoundaries == null) {
            throw new AssertionError((Object)"The cameraBoundaries should be set (using `FocusPointFeature.setCameraBoundaries(Size)`) before updating the focus point.");
        }
        if (this.focusPoint == null) {
            this.focusRectangle = null;
        } else {
            PlatformChannel.DeviceOrientation orientation = this.sensorOrientationFeature.getLockedCaptureOrientation();
            if (orientation == null) {
                orientation = this.sensorOrientationFeature.getDeviceOrientationManager().getLastUIOrientation();
            }
            this.focusRectangle = CameraRegionUtils.convertPointToMeteringRectangle(this.cameraBoundaries, this.focusPoint.x, this.focusPoint.y, orientation);
        }
    }
}

