/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.features.resolution;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.hardware.camera2.CaptureRequest;
import android.media.CamcorderProfile;
import android.media.EncoderProfiles;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.plugins.camera.CameraProperties;
import io.flutter.plugins.camera.SdkCapabilityChecker;
import io.flutter.plugins.camera.features.CameraFeature;
import io.flutter.plugins.camera.features.resolution.ResolutionPreset;
import java.util.List;

public class ResolutionFeature
extends CameraFeature<ResolutionPreset> {
    @Nullable
    private Size captureSize;
    @Nullable
    private Size previewSize;
    private CamcorderProfile recordingProfileLegacy;
    private EncoderProfiles recordingProfile;
    @NonNull
    private ResolutionPreset currentSetting;
    private int cameraId;

    public ResolutionFeature(@NonNull CameraProperties cameraProperties, @NonNull ResolutionPreset resolutionPreset, @NonNull String cameraName) {
        super(cameraProperties);
        this.currentSetting = resolutionPreset;
        try {
            this.cameraId = Integer.parseInt(cameraName, 10);
        }
        catch (NumberFormatException e) {
            this.cameraId = -1;
            return;
        }
        this.configureResolution(resolutionPreset, this.cameraId);
    }

    @Nullable
    public CamcorderProfile getRecordingProfileLegacy() {
        return this.recordingProfileLegacy;
    }

    @Nullable
    public EncoderProfiles getRecordingProfile() {
        return this.recordingProfile;
    }

    @Nullable
    public Size getPreviewSize() {
        return this.previewSize;
    }

    @Nullable
    public Size getCaptureSize() {
        return this.captureSize;
    }

    @Override
    @NonNull
    public String getDebugName() {
        return "ResolutionFeature";
    }

    @Override
    @SuppressLint(value={"KotlinPropertyAccess"})
    @NonNull
    public ResolutionPreset getValue() {
        return this.currentSetting;
    }

    @Override
    public void setValue(@NonNull ResolutionPreset value) {
        this.currentSetting = value;
        this.configureResolution(this.currentSetting, this.cameraId);
    }

    @Override
    public final boolean checkIsSupported() {
        return this.cameraId >= 0;
    }

    @Override
    public void updateBuilder(@NonNull CaptureRequest.Builder requestBuilder) {
    }

    @VisibleForTesting
    static Size computeBestPreviewSize(int cameraId, ResolutionPreset preset) throws IndexOutOfBoundsException {
        EncoderProfiles profile;
        List videoProfiles;
        EncoderProfiles.VideoProfile defaultVideoProfile;
        if (preset.ordinal() > ResolutionPreset.high.ordinal()) {
            preset = ResolutionPreset.high;
        }
        if (SdkCapabilityChecker.supportsEncoderProfiles() && (defaultVideoProfile = (EncoderProfiles.VideoProfile)(videoProfiles = (profile = ResolutionFeature.getBestAvailableCamcorderProfileForResolutionPreset(cameraId, preset)).getVideoProfiles()).get(0)) != null) {
            return new Size(defaultVideoProfile.getWidth(), defaultVideoProfile.getHeight());
        }
        profile = ResolutionFeature.getBestAvailableCamcorderProfileForResolutionPresetLegacy(cameraId, preset);
        return new Size(profile.videoFrameWidth, profile.videoFrameHeight);
    }

    @SuppressLint(value={"UseRequiresApi"})
    @TargetApi(value=30)
    @NonNull
    public static CamcorderProfile getBestAvailableCamcorderProfileForResolutionPresetLegacy(int cameraId, @NonNull ResolutionPreset preset) {
        if (cameraId < 0) {
            throw new AssertionError((Object)"getBestAvailableCamcorderProfileForResolutionPreset can only be used with valid (>=0) camera identifiers.");
        }
        switch (preset) {
            case max: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)1)) {
                    return CamcorderProfile.get((int)cameraId, (int)1);
                }
            }
            case ultraHigh: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)8)) {
                    return CamcorderProfile.get((int)cameraId, (int)8);
                }
            }
            case veryHigh: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)6)) {
                    return CamcorderProfile.get((int)cameraId, (int)6);
                }
            }
            case high: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)5)) {
                    return CamcorderProfile.get((int)cameraId, (int)5);
                }
            }
            case medium: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)4)) {
                    return CamcorderProfile.get((int)cameraId, (int)4);
                }
            }
            case low: {
                if (!CamcorderProfile.hasProfile((int)cameraId, (int)7)) break;
                return CamcorderProfile.get((int)cameraId, (int)7);
            }
        }
        if (CamcorderProfile.hasProfile((int)cameraId, (int)0)) {
            return CamcorderProfile.get((int)cameraId, (int)0);
        }
        throw new IllegalArgumentException("No capture session available for current capture session.");
    }

    @SuppressLint(value={"UseRequiresApi"})
    @TargetApi(value=31)
    @NonNull
    public static EncoderProfiles getBestAvailableCamcorderProfileForResolutionPreset(int cameraId, @NonNull ResolutionPreset preset) {
        if (cameraId < 0) {
            throw new AssertionError((Object)"getBestAvailableCamcorderProfileForResolutionPreset can only be used with valid (>=0) camera identifiers.");
        }
        String cameraIdString = Integer.toString(cameraId);
        switch (preset) {
            case max: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)1)) {
                    return CamcorderProfile.getAll((String)cameraIdString, (int)1);
                }
            }
            case ultraHigh: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)8)) {
                    return CamcorderProfile.getAll((String)cameraIdString, (int)8);
                }
            }
            case veryHigh: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)6)) {
                    return CamcorderProfile.getAll((String)cameraIdString, (int)6);
                }
            }
            case high: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)5)) {
                    return CamcorderProfile.getAll((String)cameraIdString, (int)5);
                }
            }
            case medium: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)4)) {
                    return CamcorderProfile.getAll((String)cameraIdString, (int)4);
                }
            }
            case low: {
                if (!CamcorderProfile.hasProfile((int)cameraId, (int)7)) break;
                return CamcorderProfile.getAll((String)cameraIdString, (int)7);
            }
        }
        if (CamcorderProfile.hasProfile((int)cameraId, (int)0)) {
            return CamcorderProfile.getAll((String)cameraIdString, (int)0);
        }
        throw new IllegalArgumentException("No capture session available for current capture session.");
    }

    private void configureResolution(ResolutionPreset resolutionPreset, int cameraId) throws IndexOutOfBoundsException {
        if (!this.checkIsSupported()) {
            return;
        }
        boolean captureSizeCalculated = false;
        if (SdkCapabilityChecker.supportsEncoderProfiles()) {
            this.recordingProfileLegacy = null;
            this.recordingProfile = ResolutionFeature.getBestAvailableCamcorderProfileForResolutionPreset(cameraId, resolutionPreset);
            List videoProfiles = this.recordingProfile.getVideoProfiles();
            EncoderProfiles.VideoProfile defaultVideoProfile = (EncoderProfiles.VideoProfile)videoProfiles.get(0);
            if (defaultVideoProfile != null) {
                captureSizeCalculated = true;
                this.captureSize = new Size(defaultVideoProfile.getWidth(), defaultVideoProfile.getHeight());
            }
        }
        if (!captureSizeCalculated) {
            CamcorderProfile camcorderProfile;
            this.recordingProfile = null;
            this.recordingProfileLegacy = camcorderProfile = ResolutionFeature.getBestAvailableCamcorderProfileForResolutionPresetLegacy(cameraId, resolutionPreset);
            this.captureSize = new Size(this.recordingProfileLegacy.videoFrameWidth, this.recordingProfileLegacy.videoFrameHeight);
        }
        this.previewSize = ResolutionFeature.computeBestPreviewSize(cameraId, resolutionPreset);
    }
}

