/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.features.zoomlevel;

import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.core.math.MathUtils;

final class ZoomUtils {
    ZoomUtils() {
    }

    static Rect computeZoomRect(float zoom, @NonNull Rect sensorArraySize, float minimumZoomLevel, float maximumZoomLevel) {
        float newZoom = ZoomUtils.computeZoomRatio(zoom, minimumZoomLevel, maximumZoomLevel).floatValue();
        int centerX = sensorArraySize.width() / 2;
        int centerY = sensorArraySize.height() / 2;
        int deltaX = (int)(0.5f * (float)sensorArraySize.width() / newZoom);
        int deltaY = (int)(0.5f * (float)sensorArraySize.height() / newZoom);
        return new Rect(centerX - deltaX, centerY - deltaY, centerX + deltaX, centerY + deltaY);
    }

    static Float computeZoomRatio(float zoom, float minimumZoomLevel, float maximumZoomLevel) {
        return Float.valueOf(MathUtils.clamp((float)zoom, (float)minimumZoomLevel, (float)maximumZoomLevel));
    }
}

