/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.media;

import android.media.Image;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;

public class ImageStreamReaderUtils {
    @NonNull
    public ByteBuffer yuv420ThreePlanesToNV21(@NonNull Image.Plane[] yuv420888planes, int width, int height) {
        int imageSize = width * height;
        byte[] out = new byte[imageSize + 2 * (imageSize / 4)];
        if (ImageStreamReaderUtils.areUVPlanesNV21(yuv420888planes, width, height)) {
            yuv420888planes[0].getBuffer().get(out, 0, imageSize);
            ByteBuffer uBuffer = yuv420888planes[1].getBuffer();
            ByteBuffer vBuffer = yuv420888planes[2].getBuffer();
            vBuffer.get(out, imageSize, 1);
            uBuffer.get(out, imageSize + 1, 2 * imageSize / 4 - 1);
        } else {
            ImageStreamReaderUtils.unpackPlane(yuv420888planes[0], width, height, out, 0, 1);
            ImageStreamReaderUtils.unpackPlane(yuv420888planes[1], width, height, out, imageSize + 1, 2);
            ImageStreamReaderUtils.unpackPlane(yuv420888planes[2], width, height, out, imageSize, 2);
        }
        return ByteBuffer.wrap(out);
    }

    private static boolean areUVPlanesNV21(@NonNull Image.Plane[] planes, int width, int height) {
        int imageSize = width * height;
        ByteBuffer uBuffer = planes[1].getBuffer();
        ByteBuffer vBuffer = planes[2].getBuffer();
        int vBufferPosition = vBuffer.position();
        int uBufferLimit = uBuffer.limit();
        vBuffer.position(vBufferPosition + 1);
        uBuffer.limit(uBufferLimit - 1);
        boolean areNV21 = vBuffer.remaining() == 2 * imageSize / 4 - 2 && vBuffer.compareTo(uBuffer) == 0;
        vBuffer.position(vBufferPosition);
        uBuffer.limit(uBufferLimit);
        return areNV21;
    }

    private static void unpackPlane(@NonNull Image.Plane plane, int width, int height, byte[] out, int offset, int pixelStride) throws IllegalStateException {
        ByteBuffer buffer = plane.getBuffer();
        buffer.rewind();
        int numRow = (buffer.limit() + plane.getRowStride() - 1) / plane.getRowStride();
        if (numRow == 0) {
            return;
        }
        int scaleFactor = height / numRow;
        int numCol = width / scaleFactor;
        int outputPos = offset;
        int rowStart = 0;
        for (int row = 0; row < numRow; ++row) {
            int inputPos = rowStart;
            for (int col = 0; col < numCol; ++col) {
                out[outputPos] = buffer.get(inputPos);
                outputPos += pixelStride;
                inputPos += plane.getPixelStride();
            }
            rowStart += plane.getRowStride();
        }
    }
}

