/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.media;

import android.media.CamcorderProfile;
import android.media.EncoderProfiles;
import android.media.MediaRecorder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugins.camera.SdkCapabilityChecker;
import java.io.IOException;

public class MediaRecorderBuilder {
    private final CamcorderProfile camcorderProfile;
    private final EncoderProfiles encoderProfiles;
    private final MediaRecorderFactory recorderFactory;
    @NonNull
    private final RecordingParameters parameters;
    private boolean enableAudio;
    private int mediaOrientation;

    public MediaRecorderBuilder(@NonNull CamcorderProfile camcorderProfile, @NonNull RecordingParameters parameters) {
        this(camcorderProfile, new MediaRecorderFactory(), parameters);
    }

    public MediaRecorderBuilder(@NonNull EncoderProfiles encoderProfiles, @NonNull RecordingParameters parameters) {
        this(encoderProfiles, new MediaRecorderFactory(), parameters);
    }

    MediaRecorderBuilder(@NonNull CamcorderProfile camcorderProfile, MediaRecorderFactory helper, @NonNull RecordingParameters parameters) {
        this.camcorderProfile = camcorderProfile;
        this.encoderProfiles = null;
        this.recorderFactory = helper;
        this.parameters = parameters;
    }

    MediaRecorderBuilder(@NonNull EncoderProfiles encoderProfiles, MediaRecorderFactory helper, @NonNull RecordingParameters parameters) {
        this.encoderProfiles = encoderProfiles;
        this.camcorderProfile = null;
        this.recorderFactory = helper;
        this.parameters = parameters;
    }

    @NonNull
    public MediaRecorderBuilder setEnableAudio(boolean enableAudio) {
        this.enableAudio = enableAudio;
        return this;
    }

    @NonNull
    public MediaRecorderBuilder setMediaOrientation(int orientation) {
        this.mediaOrientation = orientation;
        return this;
    }

    @NonNull
    public MediaRecorder build() throws IOException, NullPointerException, IndexOutOfBoundsException {
        MediaRecorder mediaRecorder = this.recorderFactory.makeMediaRecorder();
        if (this.enableAudio) {
            mediaRecorder.setAudioSource(1);
        }
        mediaRecorder.setVideoSource(2);
        if (SdkCapabilityChecker.supportsEncoderProfiles() && this.encoderProfiles != null) {
            mediaRecorder.setOutputFormat(this.encoderProfiles.getRecommendedFileFormat());
            EncoderProfiles.VideoProfile videoProfile = (EncoderProfiles.VideoProfile)this.encoderProfiles.getVideoProfiles().get(0);
            if (this.enableAudio) {
                EncoderProfiles.AudioProfile audioProfile = (EncoderProfiles.AudioProfile)this.encoderProfiles.getAudioProfiles().get(0);
                mediaRecorder.setAudioEncoder(audioProfile.getCodec());
                mediaRecorder.setAudioEncodingBitRate(this.parameters.audioBitrate != null && this.parameters.audioBitrate > 0 ? this.parameters.audioBitrate.intValue() : audioProfile.getBitrate());
                mediaRecorder.setAudioSamplingRate(audioProfile.getSampleRate());
            }
            mediaRecorder.setVideoEncoder(videoProfile.getCodec());
            int videoBitrate = this.parameters.videoBitrate != null && this.parameters.videoBitrate > 0 ? this.parameters.videoBitrate.intValue() : videoProfile.getBitrate();
            mediaRecorder.setVideoEncodingBitRate(videoBitrate);
            int fps = this.parameters.fps != null && this.parameters.fps > 0 ? this.parameters.fps.intValue() : videoProfile.getFrameRate();
            mediaRecorder.setVideoFrameRate(fps);
            mediaRecorder.setVideoSize(videoProfile.getWidth(), videoProfile.getHeight());
        } else if (this.camcorderProfile != null) {
            mediaRecorder.setOutputFormat(this.camcorderProfile.fileFormat);
            if (this.enableAudio) {
                mediaRecorder.setAudioEncoder(this.camcorderProfile.audioCodec);
                mediaRecorder.setAudioEncodingBitRate(this.parameters.audioBitrate != null && this.parameters.audioBitrate > 0 ? this.parameters.audioBitrate : this.camcorderProfile.audioBitRate);
                mediaRecorder.setAudioSamplingRate(this.camcorderProfile.audioSampleRate);
            }
            mediaRecorder.setVideoEncoder(this.camcorderProfile.videoCodec);
            mediaRecorder.setVideoEncodingBitRate(this.parameters.videoBitrate != null && this.parameters.videoBitrate > 0 ? this.parameters.videoBitrate : this.camcorderProfile.videoBitRate);
            mediaRecorder.setVideoFrameRate(this.parameters.fps != null && this.parameters.fps > 0 ? this.parameters.fps : this.camcorderProfile.videoFrameRate);
            mediaRecorder.setVideoSize(this.camcorderProfile.videoFrameWidth, this.camcorderProfile.videoFrameHeight);
        }
        mediaRecorder.setOutputFile(this.parameters.outputFilePath);
        mediaRecorder.setOrientationHint(this.mediaOrientation);
        mediaRecorder.prepare();
        return mediaRecorder;
    }

    static class MediaRecorderFactory {
        MediaRecorderFactory() {
        }

        MediaRecorder makeMediaRecorder() {
            return new MediaRecorder();
        }
    }

    public static class RecordingParameters {
        @NonNull
        public final String outputFilePath;
        @Nullable
        public final Integer fps;
        @Nullable
        public final Integer videoBitrate;
        @Nullable
        public final Integer audioBitrate;

        public RecordingParameters(@NonNull String outputFilePath) {
            this(outputFilePath, null, null, null);
        }

        public RecordingParameters(@NonNull String outputFilePath, @Nullable Integer fps, @Nullable Integer videoBitrate, @Nullable Integer audioBitrate) {
            this.outputFilePath = outputFilePath;
            this.fps = fps;
            this.videoBitrate = videoBitrate;
            this.audioBitrate = audioBitrate;
        }
    }
}

