/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.SessionConfiguration;
import android.media.CamcorderProfile;
import android.media.EncoderProfiles;
import android.media.Image;
import android.media.ImageReader;
import android.media.MediaRecorder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.view.Display;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugins.camera.CameraCaptureCallback;
import io.flutter.plugins.camera.CameraDeviceWrapper;
import io.flutter.plugins.camera.CameraProperties;
import io.flutter.plugins.camera.CameraRegionUtils;
import io.flutter.plugins.camera.CameraState;
import io.flutter.plugins.camera.CameraUtils;
import io.flutter.plugins.camera.DartMessenger;
import io.flutter.plugins.camera.ErrorCallback;
import io.flutter.plugins.camera.ImageSaver;
import io.flutter.plugins.camera.Messages;
import io.flutter.plugins.camera.SdkCapabilityChecker;
import io.flutter.plugins.camera.VideoRenderer;
import io.flutter.plugins.camera.features.CameraFeature;
import io.flutter.plugins.camera.features.CameraFeatureFactory;
import io.flutter.plugins.camera.features.CameraFeatures;
import io.flutter.plugins.camera.features.Point;
import io.flutter.plugins.camera.features.autofocus.AutoFocusFeature;
import io.flutter.plugins.camera.features.autofocus.FocusMode;
import io.flutter.plugins.camera.features.exposurelock.ExposureLockFeature;
import io.flutter.plugins.camera.features.exposurelock.ExposureMode;
import io.flutter.plugins.camera.features.exposureoffset.ExposureOffsetFeature;
import io.flutter.plugins.camera.features.exposurepoint.ExposurePointFeature;
import io.flutter.plugins.camera.features.flash.FlashFeature;
import io.flutter.plugins.camera.features.flash.FlashMode;
import io.flutter.plugins.camera.features.focuspoint.FocusPointFeature;
import io.flutter.plugins.camera.features.fpsrange.FpsRangeFeature;
import io.flutter.plugins.camera.features.resolution.ResolutionFeature;
import io.flutter.plugins.camera.features.resolution.ResolutionPreset;
import io.flutter.plugins.camera.features.sensororientation.DeviceOrientationManager;
import io.flutter.plugins.camera.features.zoomlevel.ZoomLevelFeature;
import io.flutter.plugins.camera.media.ImageStreamReader;
import io.flutter.plugins.camera.media.MediaRecorderBuilder;
import io.flutter.plugins.camera.types.CameraCaptureProperties;
import io.flutter.plugins.camera.types.CaptureTimeoutsWrapper;
import io.flutter.view.TextureRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

class Camera
implements CameraCaptureCallback.CameraCaptureStateListener,
ImageReader.OnImageAvailableListener {
    private static final String TAG = "Camera";
    CameraFeatures cameraFeatures;
    private int imageFormatGroup;
    @VisibleForTesting
    VideoRenderer videoRenderer;
    @VisibleForTesting
    int initialCameraFacing;
    @VisibleForTesting
    final TextureRegistry.SurfaceTextureEntry flutterTexture;
    private final VideoCaptureSettings videoCaptureSettings;
    private final Context applicationContext;
    final DartMessenger dartMessenger;
    private CameraProperties cameraProperties;
    private final CameraFeatureFactory cameraFeatureFactory;
    private final Activity activity;
    private final CameraCaptureCallback cameraCaptureCallback;
    Handler backgroundHandler;
    private HandlerThread backgroundHandlerThread;
    CameraDeviceWrapper cameraDevice;
    CameraCaptureSession captureSession;
    @VisibleForTesting
    ImageReader pictureImageReader;
    ImageStreamReader imageStreamReader;
    CaptureRequest.Builder previewRequestBuilder;
    @VisibleForTesting
    MediaRecorder mediaRecorder;
    boolean recordingVideo;
    @VisibleForTesting
    boolean pausedPreview;
    private File captureFile;
    private CaptureTimeoutsWrapper captureTimeouts;
    private CameraCaptureProperties captureProps;
    Messages.Result<String> flutterResult;

    public Camera(Activity activity, TextureRegistry.SurfaceTextureEntry flutterTexture, CameraFeatureFactory cameraFeatureFactory, DartMessenger dartMessenger, CameraProperties cameraProperties, VideoCaptureSettings videoCaptureSettings) {
        if (activity == null) {
            throw new IllegalStateException("No activity available!");
        }
        this.activity = activity;
        this.flutterTexture = flutterTexture;
        this.dartMessenger = dartMessenger;
        this.applicationContext = activity.getApplicationContext();
        this.cameraProperties = cameraProperties;
        this.cameraFeatureFactory = cameraFeatureFactory;
        this.videoCaptureSettings = videoCaptureSettings;
        this.cameraFeatures = CameraFeatures.init(cameraFeatureFactory, cameraProperties, activity, dartMessenger, videoCaptureSettings.resolutionPreset);
        this.captureTimeouts = new CaptureTimeoutsWrapper(3000L, 3000L);
        this.captureProps = new CameraCaptureProperties();
        this.cameraCaptureCallback = CameraCaptureCallback.create(this, this.captureTimeouts, this.captureProps);
        this.startBackgroundThread();
    }

    @Override
    public void onConverged() {
        this.takePictureAfterPrecapture();
    }

    @Override
    public void onPrecapture() {
        this.runPrecaptureSequence();
    }

    void updateBuilderSettings(CaptureRequest.Builder requestBuilder) {
        for (CameraFeature<?> feature : this.cameraFeatures.getAllFeatures()) {
            feature.updateBuilder(requestBuilder);
        }
    }

    private void prepareMediaRecorder(String outputFilePath) throws IOException {
        Log.i((String)TAG, (String)"prepareMediaRecorder");
        if (this.mediaRecorder != null) {
            this.mediaRecorder.release();
        }
        this.closeRenderer();
        PlatformChannel.DeviceOrientation lockedOrientation = this.cameraFeatures.getSensorOrientation().getLockedCaptureOrientation();
        MediaRecorderBuilder mediaRecorderBuilder = SdkCapabilityChecker.supportsEncoderProfiles() && this.getRecordingProfile() != null ? new MediaRecorderBuilder(this.getRecordingProfile(), new MediaRecorderBuilder.RecordingParameters(outputFilePath, this.videoCaptureSettings.fps, this.videoCaptureSettings.videoBitrate, this.videoCaptureSettings.audioBitrate)) : new MediaRecorderBuilder(this.getRecordingProfileLegacy(), new MediaRecorderBuilder.RecordingParameters(outputFilePath, this.videoCaptureSettings.fps, this.videoCaptureSettings.videoBitrate, this.videoCaptureSettings.audioBitrate));
        this.mediaRecorder = mediaRecorderBuilder.setEnableAudio(this.videoCaptureSettings.enableAudio).setMediaOrientation(lockedOrientation == null ? this.getDeviceOrientationManager().getVideoOrientation() : this.getDeviceOrientationManager().getVideoOrientation(lockedOrientation)).build();
    }

    private void setFpsCameraFeatureForRecording(CameraProperties cameraProperties) {
        Integer recordingFps = null;
        if (this.videoCaptureSettings.fps != null && this.videoCaptureSettings.fps > 0) {
            recordingFps = this.videoCaptureSettings.fps;
        } else if (SdkCapabilityChecker.supportsEncoderProfiles()) {
            EncoderProfiles encoderProfiles = this.getRecordingProfile();
            if (encoderProfiles != null && encoderProfiles.getVideoProfiles().size() > 0) {
                recordingFps = ((EncoderProfiles.VideoProfile)encoderProfiles.getVideoProfiles().get(0)).getFrameRate();
            }
        } else {
            CamcorderProfile camcorderProfile = this.getRecordingProfileLegacy();
            Integer n = recordingFps = null != camcorderProfile ? Integer.valueOf(camcorderProfile.videoFrameRate) : null;
        }
        if (recordingFps != null && recordingFps > 0) {
            FpsRangeFeature fpsRange = new FpsRangeFeature(cameraProperties);
            fpsRange.setValue((Range<Integer>)new Range((Comparable)recordingFps, (Comparable)recordingFps));
            this.cameraFeatures.setFpsRange(fpsRange);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void open(Integer imageFormatGroup) throws CameraAccessException {
        this.imageFormatGroup = imageFormatGroup;
        final ResolutionFeature resolutionFeature = this.cameraFeatures.getResolution();
        if (!resolutionFeature.checkIsSupported()) {
            this.dartMessenger.sendCameraErrorEvent("Camera with name \"" + this.cameraProperties.getCameraName() + "\" is not supported by this plugin.");
            return;
        }
        this.pictureImageReader = ImageReader.newInstance((int)resolutionFeature.getCaptureSize().getWidth(), (int)resolutionFeature.getCaptureSize().getHeight(), (int)256, (int)1);
        this.imageStreamReader = new ImageStreamReader(resolutionFeature.getPreviewSize().getWidth(), resolutionFeature.getPreviewSize().getHeight(), this.imageFormatGroup, 1);
        CameraManager cameraManager = CameraUtils.getCameraManager((Context)this.activity);
        cameraManager.openCamera(this.cameraProperties.getCameraName(), new CameraDevice.StateCallback(){

            public void onOpened(@NonNull CameraDevice device) {
                Camera.this.cameraDevice = new DefaultCameraDeviceWrapper(device);
                try {
                    Runnable onSuccess = Camera.this.recordingVideo ? null : () -> Camera.this.dartMessenger.sendCameraInitializedEvent(resolutionFeature.getPreviewSize().getWidth(), resolutionFeature.getPreviewSize().getHeight(), Camera.this.cameraFeatures.getExposureLock().getValue(), Camera.this.cameraFeatures.getAutoFocus().getValue(), Camera.this.cameraFeatures.getExposurePoint().checkIsSupported(), Camera.this.cameraFeatures.getFocusPoint().checkIsSupported());
                    Camera.this.startPreview(onSuccess);
                }
                catch (Exception e) {
                    String message = e.getMessage() == null ? e.getClass().getName() + " occurred while opening camera." : e.getMessage();
                    Camera.this.dartMessenger.sendCameraErrorEvent(message);
                    Camera.this.close();
                }
            }

            public void onClosed(@NonNull CameraDevice camera) {
                Log.i((String)Camera.TAG, (String)"open | onClosed");
                Camera.this.cameraDevice = null;
                Camera.this.closeCaptureSession();
                Camera.this.dartMessenger.sendCameraClosingEvent();
            }

            public void onDisconnected(@NonNull CameraDevice cameraDevice) {
                Log.i((String)Camera.TAG, (String)"open | onDisconnected");
                Camera.this.close();
                Camera.this.dartMessenger.sendCameraErrorEvent("The camera was disconnected.");
            }

            public void onError(@NonNull CameraDevice cameraDevice, int errorCode) {
                Log.i((String)Camera.TAG, (String)"open | onError");
                Camera.this.close();
                Camera.this.dartMessenger.sendCameraErrorEvent(switch (errorCode) {
                    case 1 -> "The camera device is in use already.";
                    case 2 -> "Max cameras in use";
                    case 3 -> "The camera device could not be opened due to a device policy.";
                    case 4 -> "The camera device has encountered a fatal error";
                    case 5 -> "The camera service has encountered a fatal error.";
                    default -> "Unknown camera error";
                });
            }
        }, this.backgroundHandler);
    }

    @VisibleForTesting
    void createCaptureSession(int templateType, Surface ... surfaces) throws CameraAccessException {
        this.createCaptureSession(templateType, (Runnable)null, surfaces);
    }

    private void createCaptureSession(int templateType, final Runnable onSuccessCallback, Surface ... surfaces) throws CameraAccessException {
        this.captureSession = null;
        this.previewRequestBuilder = this.cameraDevice.createCaptureRequest(templateType);
        ResolutionFeature resolutionFeature = this.cameraFeatures.getResolution();
        SurfaceTexture surfaceTexture = this.flutterTexture.surfaceTexture();
        surfaceTexture.setDefaultBufferSize(resolutionFeature.getPreviewSize().getWidth(), resolutionFeature.getPreviewSize().getHeight());
        Surface flutterSurface = new Surface(surfaceTexture);
        this.previewRequestBuilder.addTarget(flutterSurface);
        List<Surface> remainingSurfaces = Arrays.asList(surfaces);
        if (templateType != 1) {
            Surface pictureImageReaderSurface = this.pictureImageReader.getSurface();
            for (Surface surface : remainingSurfaces) {
                if (surface == pictureImageReaderSurface) continue;
                this.previewRequestBuilder.addTarget(surface);
            }
        }
        Size cameraBoundaries = CameraRegionUtils.getCameraBoundaries(this.cameraProperties, this.previewRequestBuilder);
        this.cameraFeatures.getExposurePoint().setCameraBoundaries(cameraBoundaries);
        this.cameraFeatures.getFocusPoint().setCameraBoundaries(cameraBoundaries);
        CameraCaptureSession.StateCallback callback = new CameraCaptureSession.StateCallback(){
            boolean captureSessionClosed = false;

            public void onConfigured(@NonNull CameraCaptureSession session) {
                Log.i((String)Camera.TAG, (String)"CameraCaptureSession onConfigured");
                if (Camera.this.cameraDevice == null || this.captureSessionClosed) {
                    Camera.this.dartMessenger.sendCameraErrorEvent("The camera was closed during configuration.");
                    return;
                }
                Camera.this.captureSession = session;
                Log.i((String)Camera.TAG, (String)"Updating builder settings");
                Camera.this.updateBuilderSettings(Camera.this.previewRequestBuilder);
                Camera.this.refreshPreviewCaptureSession(onSuccessCallback, (code, message) -> Camera.this.dartMessenger.sendCameraErrorEvent(message));
            }

            public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                Log.i((String)Camera.TAG, (String)"CameraCaptureSession onConfigureFailed");
                Camera.this.dartMessenger.sendCameraErrorEvent("Failed to configure camera session.");
            }

            public void onClosed(@NonNull CameraCaptureSession session) {
                Log.i((String)Camera.TAG, (String)"CameraCaptureSession onClosed");
                this.captureSessionClosed = true;
            }
        };
        if (SdkCapabilityChecker.supportsSessionConfiguration()) {
            ArrayList<OutputConfiguration> configs = new ArrayList<OutputConfiguration>();
            configs.add(new OutputConfiguration(flutterSurface));
            for (Surface surface : remainingSurfaces) {
                configs.add(new OutputConfiguration(surface));
            }
            this.createCaptureSessionWithSessionConfig(configs, callback);
        } else {
            ArrayList<Surface> surfaceList = new ArrayList<Surface>();
            surfaceList.add(flutterSurface);
            surfaceList.addAll(remainingSurfaces);
            this.createCaptureSession(surfaceList, callback);
        }
    }

    @SuppressLint(value={"UseRequiresApi"})
    @TargetApi(value=28)
    private void createCaptureSessionWithSessionConfig(List<OutputConfiguration> outputConfigs, CameraCaptureSession.StateCallback callback) throws CameraAccessException {
        this.cameraDevice.createCaptureSession(new SessionConfiguration(0, outputConfigs, (Executor)Executors.newSingleThreadExecutor(), callback));
    }

    private void createCaptureSession(List<Surface> surfaces, CameraCaptureSession.StateCallback callback) throws CameraAccessException {
        this.cameraDevice.createCaptureSession(surfaces, callback, this.backgroundHandler);
    }

    void refreshPreviewCaptureSession(@Nullable Runnable onSuccessCallback, @NonNull ErrorCallback onErrorCallback) {
        Log.i((String)TAG, (String)"refreshPreviewCaptureSession");
        if (this.captureSession == null) {
            Log.i((String)TAG, (String)"refreshPreviewCaptureSession: captureSession not yet initialized, skipping preview capture session refresh.");
            return;
        }
        try {
            if (!this.pausedPreview) {
                this.captureSession.setRepeatingRequest(this.previewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.cameraCaptureCallback, this.backgroundHandler);
            }
            if (onSuccessCallback != null) {
                onSuccessCallback.run();
            }
        }
        catch (IllegalStateException e) {
            onErrorCallback.onError("cameraAccess", "Camera is closed: " + e.getMessage());
        }
        catch (CameraAccessException e) {
            onErrorCallback.onError("cameraAccess", e.getMessage());
        }
    }

    private void startCapture(boolean record, boolean stream) throws CameraAccessException {
        ArrayList<Surface> surfaces = new ArrayList<Surface>();
        Runnable successCallback = null;
        if (record) {
            surfaces.add(this.mediaRecorder.getSurface());
            successCallback = () -> this.mediaRecorder.start();
        }
        if (stream && this.imageStreamReader != null) {
            surfaces.add(this.imageStreamReader.getSurface());
        }
        surfaces.add(this.pictureImageReader.getSurface());
        this.createCaptureSession(3, successCallback, surfaces.toArray(new Surface[0]));
    }

    public void takePicture(@NonNull Messages.Result<String> result) {
        if (this.cameraCaptureCallback.getCameraState() != CameraState.STATE_PREVIEW) {
            result.error(new Messages.FlutterError("captureAlreadyActive", "Picture is currently already being captured", null));
            return;
        }
        this.flutterResult = result;
        File outputDir = this.applicationContext.getCacheDir();
        try {
            this.captureFile = File.createTempFile("CAP", ".jpg", outputDir);
            this.captureTimeouts.reset();
        }
        catch (IOException | SecurityException e) {
            this.dartMessenger.error(this.flutterResult, "cannotCreateFile", e.getMessage(), null);
            return;
        }
        this.pictureImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, this.backgroundHandler);
        AutoFocusFeature autoFocusFeature = this.cameraFeatures.getAutoFocus();
        boolean isAutoFocusSupported = autoFocusFeature.checkIsSupported();
        if (isAutoFocusSupported && autoFocusFeature.getValue() == FocusMode.auto) {
            this.runPictureAutoFocus();
        } else {
            this.runPrecaptureSequence();
        }
    }

    private void runPrecaptureSequence() {
        Log.i((String)TAG, (String)"runPrecaptureSequence");
        try {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)0);
            this.captureSession.capture(this.previewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.cameraCaptureCallback, this.backgroundHandler);
            this.refreshPreviewCaptureSession(null, (code, message) -> this.dartMessenger.error(this.flutterResult, "cameraAccess", message, null));
            this.cameraCaptureCallback.setCameraState(CameraState.STATE_WAITING_PRECAPTURE_START);
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.captureSession.capture(this.previewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.cameraCaptureCallback, this.backgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void takePictureAfterPrecapture() {
        CaptureRequest.Builder stillBuilder;
        Log.i((String)TAG, (String)"captureStillPicture");
        this.cameraCaptureCallback.setCameraState(CameraState.STATE_CAPTURING);
        if (this.cameraDevice == null) {
            return;
        }
        try {
            stillBuilder = this.cameraDevice.createCaptureRequest(2);
        }
        catch (CameraAccessException e) {
            this.dartMessenger.error(this.flutterResult, "cameraAccess", e.getMessage(), null);
            return;
        }
        stillBuilder.addTarget(this.pictureImageReader.getSurface());
        stillBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)((Rect)this.previewRequestBuilder.get(CaptureRequest.SCALER_CROP_REGION)));
        this.updateBuilderSettings(stillBuilder);
        PlatformChannel.DeviceOrientation lockedOrientation = this.cameraFeatures.getSensorOrientation().getLockedCaptureOrientation();
        stillBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)(lockedOrientation == null ? this.getDeviceOrientationManager().getPhotoOrientation() : this.getDeviceOrientationManager().getPhotoOrientation(lockedOrientation)));
        CameraCaptureSession.CaptureCallback captureCallback = new CameraCaptureSession.CaptureCallback(){

            public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                Camera.this.unlockAutoFocus();
            }
        };
        try {
            Log.i((String)TAG, (String)"sending capture request");
            this.captureSession.capture(stillBuilder.build(), captureCallback, this.backgroundHandler);
        }
        catch (CameraAccessException e) {
            this.dartMessenger.error(this.flutterResult, "cameraAccess", e.getMessage(), null);
        }
    }

    private Display getDefaultDisplay() {
        return this.activity.getWindowManager().getDefaultDisplay();
    }

    public void startBackgroundThread() {
        if (this.backgroundHandlerThread != null) {
            return;
        }
        this.backgroundHandlerThread = HandlerThreadFactory.create("CameraBackground");
        try {
            this.backgroundHandlerThread.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        this.backgroundHandler = HandlerFactory.create(this.backgroundHandlerThread.getLooper());
    }

    public void stopBackgroundThread() {
        if (this.backgroundHandlerThread != null) {
            this.backgroundHandlerThread.quitSafely();
        }
        this.backgroundHandlerThread = null;
        this.backgroundHandler = null;
    }

    private void runPictureAutoFocus() {
        Log.i((String)TAG, (String)"runPictureAutoFocus");
        this.cameraCaptureCallback.setCameraState(CameraState.STATE_WAITING_FOCUS);
        this.lockAutoFocus();
    }

    private void lockAutoFocus() {
        Log.i((String)TAG, (String)"lockAutoFocus");
        if (this.captureSession == null) {
            Log.i((String)TAG, (String)"[unlockAutoFocus] captureSession null, returning");
            return;
        }
        this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        try {
            this.captureSession.capture(this.previewRequestBuilder.build(), null, this.backgroundHandler);
        }
        catch (CameraAccessException e) {
            String message = e.getMessage() == null ? "CameraAccessException occurred while locking autofocus." : e.getMessage();
            this.dartMessenger.sendCameraErrorEvent(message);
        }
    }

    void unlockAutoFocus() {
        Log.i((String)TAG, (String)"unlockAutoFocus");
        if (this.captureSession == null) {
            Log.i((String)TAG, (String)"[unlockAutoFocus] captureSession null, returning");
            return;
        }
        try {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            this.captureSession.capture(this.previewRequestBuilder.build(), null, this.backgroundHandler);
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            this.captureSession.capture(this.previewRequestBuilder.build(), null, this.backgroundHandler);
        }
        catch (CameraAccessException e) {
            String message = e.getMessage() == null ? "CameraAccessException occurred while unlocking autofocus." : e.getMessage();
            this.dartMessenger.sendCameraErrorEvent(message);
            return;
        }
        this.refreshPreviewCaptureSession(null, (errorCode, errorMessage) -> this.dartMessenger.error(this.flutterResult, errorCode, errorMessage, null));
    }

    public void startVideoRecording(@Nullable EventChannel imageStreamChannel) {
        this.prepareRecording();
        if (imageStreamChannel != null) {
            this.setStreamHandler(imageStreamChannel);
        }
        this.initialCameraFacing = this.cameraProperties.getLensFacing();
        this.recordingVideo = true;
        try {
            this.startCapture(true, imageStreamChannel != null);
        }
        catch (CameraAccessException e) {
            this.recordingVideo = false;
            this.captureFile = null;
            throw new Messages.FlutterError("videoRecordingFailed", e.getMessage(), null);
        }
    }

    private void closeRenderer() {
        if (this.videoRenderer != null) {
            this.videoRenderer.close();
            this.videoRenderer = null;
        }
    }

    public String stopVideoRecording() {
        if (!this.recordingVideo) {
            return "";
        }
        this.cameraFeatures.setAutoFocus(this.cameraFeatureFactory.createAutoFocusFeature(this.cameraProperties, false));
        this.cameraFeatures.setFpsRange(this.cameraFeatureFactory.createFpsRangeFeature(this.cameraProperties));
        this.recordingVideo = false;
        try {
            this.closeRenderer();
            this.captureSession.abortCaptures();
            this.mediaRecorder.stop();
        }
        catch (CameraAccessException | IllegalStateException throwable) {
            // empty catch block
        }
        this.mediaRecorder.reset();
        try {
            this.startPreview(null);
        }
        catch (CameraAccessException | IllegalStateException | InterruptedException e) {
            throw new Messages.FlutterError("videoRecordingFailed", e.getMessage(), null);
        }
        String path = this.captureFile.getAbsolutePath();
        this.captureFile = null;
        return path;
    }

    public void pauseVideoRecording() {
        if (!this.recordingVideo) {
            return;
        }
        try {
            this.mediaRecorder.pause();
        }
        catch (IllegalStateException e) {
            throw new Messages.FlutterError("videoRecordingFailed", e.getMessage(), null);
        }
    }

    public void resumeVideoRecording() {
        if (!this.recordingVideo) {
            return;
        }
        try {
            this.mediaRecorder.resume();
        }
        catch (IllegalStateException e) {
            throw new Messages.FlutterError("videoRecordingFailed", e.getMessage(), null);
        }
    }

    public void setFlashMode(@NonNull Messages.VoidResult result, @NonNull FlashMode newMode) {
        FlashFeature flashFeature = this.cameraFeatures.getFlash();
        flashFeature.setValue(newMode);
        flashFeature.updateBuilder(this.previewRequestBuilder);
        this.refreshPreviewCaptureSession(result::success, (code, message) -> result.error(new Messages.FlutterError("setFlashModeFailed", "Could not set flash mode.", null)));
    }

    public void setExposureMode(@NonNull Messages.VoidResult result, @NonNull ExposureMode newMode) {
        ExposureLockFeature exposureLockFeature = this.cameraFeatures.getExposureLock();
        exposureLockFeature.setValue(newMode);
        exposureLockFeature.updateBuilder(this.previewRequestBuilder);
        this.refreshPreviewCaptureSession(result::success, (code, message) -> result.error(new Messages.FlutterError("setExposureModeFailed", "Could not set exposure mode.", null)));
    }

    public void setExposurePoint(@NonNull Messages.VoidResult result, @Nullable Point point) {
        ExposurePointFeature exposurePointFeature = this.cameraFeatures.getExposurePoint();
        exposurePointFeature.setValue(point);
        exposurePointFeature.updateBuilder(this.previewRequestBuilder);
        this.refreshPreviewCaptureSession(result::success, (code, message) -> result.error(new Messages.FlutterError("setExposurePointFailed", "Could not set exposure point.", null)));
    }

    public double getMaxExposureOffset() {
        return this.cameraFeatures.getExposureOffset().getMaxExposureOffset();
    }

    public double getMinExposureOffset() {
        return this.cameraFeatures.getExposureOffset().getMinExposureOffset();
    }

    public double getExposureOffsetStepSize() {
        return this.cameraFeatures.getExposureOffset().getExposureOffsetStepSize();
    }

    public void setFocusMode(@NonNull FocusMode newMode) {
        AutoFocusFeature autoFocusFeature = this.cameraFeatures.getAutoFocus();
        autoFocusFeature.setValue(newMode);
        autoFocusFeature.updateBuilder(this.previewRequestBuilder);
        if (!this.pausedPreview) {
            switch (newMode) {
                case locked: {
                    if (this.captureSession == null) {
                        Log.i((String)TAG, (String)"[unlockAutoFocus] captureSession null, returning");
                        return;
                    }
                    this.lockAutoFocus();
                    this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
                    try {
                        this.captureSession.setRepeatingRequest(this.previewRequestBuilder.build(), null, this.backgroundHandler);
                        break;
                    }
                    catch (CameraAccessException e) {
                        throw new Messages.FlutterError("setFocusModeFailed", "Error setting focus mode: " + e.getMessage(), null);
                    }
                }
                case auto: {
                    this.unlockAutoFocus();
                }
            }
        }
    }

    public void setFocusPoint(@NonNull Messages.VoidResult result, @Nullable Point point) {
        FocusPointFeature focusPointFeature = this.cameraFeatures.getFocusPoint();
        focusPointFeature.setValue(point);
        focusPointFeature.updateBuilder(this.previewRequestBuilder);
        this.refreshPreviewCaptureSession(result::success, (code, message) -> result.error(new Messages.FlutterError("setFocusPointFailed", "Could not set focus point.", null)));
        this.setFocusMode(this.cameraFeatures.getAutoFocus().getValue());
    }

    public void setExposureOffset(@NonNull Messages.Result<Double> result, double offset) {
        ExposureOffsetFeature exposureOffsetFeature = this.cameraFeatures.getExposureOffset();
        exposureOffsetFeature.setValue(offset);
        exposureOffsetFeature.updateBuilder(this.previewRequestBuilder);
        this.refreshPreviewCaptureSession(() -> result.success(exposureOffsetFeature.getValue()), (code, message) -> result.error(new Messages.FlutterError("setExposureOffsetFailed", "Could not set exposure offset.", null)));
    }

    public float getMaxZoomLevel() {
        return this.cameraFeatures.getZoomLevel().getMaximumZoomLevel();
    }

    public float getMinZoomLevel() {
        return this.cameraFeatures.getZoomLevel().getMinimumZoomLevel();
    }

    CamcorderProfile getRecordingProfileLegacy() {
        return this.cameraFeatures.getResolution().getRecordingProfileLegacy();
    }

    EncoderProfiles getRecordingProfile() {
        return this.cameraFeatures.getResolution().getRecordingProfile();
    }

    DeviceOrientationManager getDeviceOrientationManager() {
        return this.cameraFeatures.getSensorOrientation().getDeviceOrientationManager();
    }

    public void setZoomLevel(@NonNull Messages.VoidResult result, float zoom) {
        ZoomLevelFeature zoomLevel = this.cameraFeatures.getZoomLevel();
        float maxZoom = zoomLevel.getMaximumZoomLevel();
        float minZoom = zoomLevel.getMinimumZoomLevel();
        if (zoom > maxZoom || zoom < minZoom) {
            String errorMessage = String.format(Locale.ENGLISH, "Zoom level out of bounds (zoom level should be between %f and %f).", Float.valueOf(minZoom), Float.valueOf(maxZoom));
            result.error(new Messages.FlutterError("ZOOM_ERROR", errorMessage, null));
            return;
        }
        zoomLevel.setValue(Float.valueOf(zoom));
        zoomLevel.updateBuilder(this.previewRequestBuilder);
        this.refreshPreviewCaptureSession(result::success, (code, message) -> result.error(new Messages.FlutterError("setZoomLevelFailed", "Could not set zoom level.", null)));
    }

    public void lockCaptureOrientation(PlatformChannel.DeviceOrientation orientation) {
        this.cameraFeatures.getSensorOrientation().lockCaptureOrientation(orientation);
    }

    public void unlockCaptureOrientation() {
        this.cameraFeatures.getSensorOrientation().unlockCaptureOrientation();
    }

    public void pausePreview() throws CameraAccessException {
        if (!this.pausedPreview) {
            this.pausedPreview = true;
            if (this.captureSession != null) {
                this.captureSession.stopRepeating();
            }
        }
    }

    public void resumePreview() {
        this.pausedPreview = false;
        this.refreshPreviewCaptureSession(null, (code, message) -> this.dartMessenger.sendCameraErrorEvent(message));
    }

    public void startPreview(@Nullable Runnable onSuccessCallback) throws CameraAccessException, InterruptedException {
        if (this.recordingVideo) {
            this.startPreviewWithVideoRendererStream(onSuccessCallback);
        } else {
            this.startRegularPreview(onSuccessCallback);
        }
    }

    private void startRegularPreview(@Nullable Runnable onSuccessCallback) throws CameraAccessException {
        if (this.pictureImageReader == null || this.pictureImageReader.getSurface() == null) {
            if (onSuccessCallback != null) {
                onSuccessCallback.run();
            }
            return;
        }
        Log.i((String)TAG, (String)"startPreview");
        this.createCaptureSession(1, onSuccessCallback, this.pictureImageReader.getSurface());
    }

    private void startPreviewWithVideoRendererStream(@Nullable Runnable onSuccessCallback) throws CameraAccessException, InterruptedException {
        if (this.videoRenderer == null) {
            if (onSuccessCallback != null) {
                onSuccessCallback.run();
            }
            return;
        }
        PlatformChannel.DeviceOrientation lockedOrientation = this.cameraFeatures.getSensorOrientation().getLockedCaptureOrientation();
        DeviceOrientationManager orientationManager = this.cameraFeatures.getSensorOrientation().getDeviceOrientationManager();
        int rotation = 0;
        if (orientationManager != null) {
            int n = rotation = lockedOrientation == null ? orientationManager.getVideoOrientation() : orientationManager.getVideoOrientation(lockedOrientation);
        }
        if (this.cameraProperties.getLensFacing() != this.initialCameraFacing) {
            rotation = (rotation + 180) % 360;
        }
        this.videoRenderer.setRotation(rotation);
        this.createCaptureSession(3, onSuccessCallback, this.videoRenderer.getInputSurface());
    }

    public void startPreviewWithImageStream(EventChannel imageStreamChannel) throws CameraAccessException {
        this.setStreamHandler(imageStreamChannel);
        this.startCapture(false, true);
        Log.i((String)TAG, (String)"startPreviewWithImageStream");
    }

    public void onImageAvailable(ImageReader reader) {
        Log.i((String)TAG, (String)"onImageAvailable");
        Image image = reader.acquireNextImage();
        if (image == null) {
            return;
        }
        this.backgroundHandler.post((Runnable)new ImageSaver(image, this.captureFile, new ImageSaver.Callback(){

            @Override
            public void onComplete(@NonNull String absolutePath) {
                Camera.this.dartMessenger.finish(Camera.this.flutterResult, absolutePath);
            }

            @Override
            public void onError(@NonNull String errorCode, @NonNull String errorMessage) {
                Camera.this.dartMessenger.error(Camera.this.flutterResult, errorCode, errorMessage, null);
            }
        }));
        this.cameraCaptureCallback.setCameraState(CameraState.STATE_PREVIEW);
    }

    @VisibleForTesting
    void prepareRecording() {
        File outputDir = this.applicationContext.getCacheDir();
        try {
            this.captureFile = File.createTempFile("REC", ".mp4", outputDir);
        }
        catch (IOException | SecurityException e) {
            throw new Messages.FlutterError("cannotCreateFile", e.getMessage(), null);
        }
        try {
            this.prepareMediaRecorder(this.captureFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.recordingVideo = false;
            this.captureFile = null;
            throw new Messages.FlutterError("videoRecordingFailed", e.getMessage(), null);
        }
        this.cameraFeatures.setAutoFocus(this.cameraFeatureFactory.createAutoFocusFeature(this.cameraProperties, true));
        this.setFpsCameraFeatureForRecording(this.cameraProperties);
    }

    private void setStreamHandler(EventChannel imageStreamChannel) {
        imageStreamChannel.setStreamHandler(new EventChannel.StreamHandler(){

            public void onListen(Object o, EventChannel.EventSink imageStreamSink) {
                Camera.this.setImageStreamImageAvailableListener(imageStreamSink);
            }

            public void onCancel(Object o) {
                if (Camera.this.imageStreamReader == null) {
                    return;
                }
                Camera.this.imageStreamReader.removeListener(Camera.this.backgroundHandler);
            }
        });
    }

    void setImageStreamImageAvailableListener(EventChannel.EventSink imageStreamSink) {
        if (this.imageStreamReader == null) {
            return;
        }
        this.imageStreamReader.subscribeListener(this.captureProps, imageStreamSink, this.backgroundHandler);
    }

    void closeCaptureSession() {
        if (this.captureSession != null) {
            Log.i((String)TAG, (String)"closeCaptureSession");
            this.captureSession.close();
            this.captureSession = null;
        }
    }

    public void close() {
        Log.i((String)TAG, (String)"close");
        this.stopAndReleaseCamera();
        if (this.pictureImageReader != null) {
            this.pictureImageReader.close();
            this.pictureImageReader = null;
        }
        if (this.imageStreamReader != null) {
            this.imageStreamReader.close();
            this.imageStreamReader = null;
        }
        if (this.mediaRecorder != null) {
            this.mediaRecorder.reset();
            this.mediaRecorder.release();
            this.mediaRecorder = null;
        }
        this.stopBackgroundThread();
    }

    private void stopAndReleaseCamera() {
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
            this.captureSession = null;
        } else {
            this.closeCaptureSession();
        }
    }

    private void prepareVideoRenderer() {
        if (this.videoRenderer != null) {
            return;
        }
        ResolutionFeature resolutionFeature = this.cameraFeatures.getResolution();
        Thread.UncaughtExceptionHandler videoRendererUncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                Camera.this.dartMessenger.sendCameraErrorEvent("Failed to process frames after camera was flipped.");
            }
        };
        this.videoRenderer = new VideoRenderer(this.mediaRecorder.getSurface(), resolutionFeature.getCaptureSize().getWidth(), resolutionFeature.getCaptureSize().getHeight(), videoRendererUncaughtExceptionHandler);
    }

    public void setDescriptionWhileRecording(CameraProperties properties) {
        if (!this.recordingVideo) {
            throw new Messages.FlutterError("setDescriptionWhileRecordingFailed", "Device was not recording", null);
        }
        if (!SdkCapabilityChecker.supportsEglRecordableAndroid()) {
            throw new Messages.FlutterError("setDescriptionWhileRecordingFailed", "Device does not support switching the camera while recording", null);
        }
        this.stopAndReleaseCamera();
        this.prepareVideoRenderer();
        this.cameraProperties = properties;
        this.cameraFeatures = CameraFeatures.init(this.cameraFeatureFactory, this.cameraProperties, this.activity, this.dartMessenger, this.videoCaptureSettings.resolutionPreset);
        this.cameraFeatures.setAutoFocus(this.cameraFeatureFactory.createAutoFocusFeature(this.cameraProperties, true));
        this.setFpsCameraFeatureForRecording(this.cameraProperties);
        try {
            this.open(this.imageFormatGroup);
        }
        catch (CameraAccessException e) {
            throw new Messages.FlutterError("setDescriptionWhileRecordingFailed", e.getMessage(), null);
        }
    }

    public void dispose() {
        Log.i((String)TAG, (String)"dispose");
        this.close();
        this.flutterTexture.release();
        this.getDeviceOrientationManager().stop();
    }

    public static class VideoCaptureSettings {
        @NonNull
        public final ResolutionPreset resolutionPreset;
        public final boolean enableAudio;
        @Nullable
        public final Integer fps;
        @Nullable
        public final Integer videoBitrate;
        @Nullable
        public final Integer audioBitrate;

        public VideoCaptureSettings(@NonNull ResolutionPreset resolutionPreset, boolean enableAudio, @Nullable Integer fps, @Nullable Integer videoBitrate, @Nullable Integer audioBitrate) {
            this.resolutionPreset = resolutionPreset;
            this.enableAudio = enableAudio;
            this.fps = fps;
            this.videoBitrate = videoBitrate;
            this.audioBitrate = audioBitrate;
        }

        public VideoCaptureSettings(@NonNull ResolutionPreset resolutionPreset, boolean enableAudio) {
            this(resolutionPreset, enableAudio, null, null, null);
        }
    }

    static class HandlerThreadFactory {
        HandlerThreadFactory() {
        }

        @VisibleForTesting
        public static HandlerThread create(String name) {
            return new HandlerThread(name);
        }
    }

    static class HandlerFactory {
        HandlerFactory() {
        }

        @VisibleForTesting
        public static Handler create(Looper looper) {
            return new Handler(looper);
        }
    }

    private class DefaultCameraDeviceWrapper
    implements CameraDeviceWrapper {
        private final CameraDevice cameraDevice;

        DefaultCameraDeviceWrapper(CameraDevice cameraDevice) {
            this.cameraDevice = cameraDevice;
        }

        @Override
        @NonNull
        public CaptureRequest.Builder createCaptureRequest(int templateType) throws CameraAccessException {
            return this.cameraDevice.createCaptureRequest(templateType);
        }

        @Override
        @SuppressLint(value={"UseRequiresApi"})
        @TargetApi(value=28)
        public void createCaptureSession(SessionConfiguration config) throws CameraAccessException {
            this.cameraDevice.createCaptureSession(config);
        }

        @Override
        public void createCaptureSession(@NonNull List<Surface> outputs, @NonNull CameraCaptureSession.StateCallback callback, @Nullable Handler handler) throws CameraAccessException {
            this.cameraDevice.createCaptureSession(outputs, callback, Camera.this.backgroundHandler);
        }

        @Override
        public void close() {
            this.cameraDevice.close();
        }
    }
}

