/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera.features.exposurepoint;

import android.annotation.SuppressLint;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.MeteringRectangle;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.plugins.camera.CameraProperties;
import io.flutter.plugins.camera.CameraRegionUtils;
import io.flutter.plugins.camera.features.CameraFeature;
import io.flutter.plugins.camera.features.Point;
import io.flutter.plugins.camera.features.sensororientation.SensorOrientationFeature;

public class ExposurePointFeature
extends CameraFeature<Point> {
    private Size cameraBoundaries;
    @Nullable
    private Point exposurePoint;
    private MeteringRectangle exposureRectangle;
    @NonNull
    private final SensorOrientationFeature sensorOrientationFeature;
    private boolean defaultRegionsHasBeenSet = false;
    @VisibleForTesting
    @Nullable
    public MeteringRectangle[] defaultRegions;

    public ExposurePointFeature(@NonNull CameraProperties cameraProperties, @NonNull SensorOrientationFeature sensorOrientationFeature) {
        super(cameraProperties);
        this.sensorOrientationFeature = sensorOrientationFeature;
    }

    public void setCameraBoundaries(@NonNull Size cameraBoundaries) {
        this.cameraBoundaries = cameraBoundaries;
        this.buildExposureRectangle();
    }

    @Override
    @NonNull
    public String getDebugName() {
        return "ExposurePointFeature";
    }

    @Override
    @SuppressLint(value={"KotlinPropertyAccess"})
    @Nullable
    public Point getValue() {
        return this.exposurePoint;
    }

    @Override
    public void setValue(@Nullable Point value) {
        this.exposurePoint = value == null || value.x == null || value.y == null ? null : value;
        this.buildExposureRectangle();
    }

    @Override
    public boolean checkIsSupported() {
        Integer supportedRegions = this.cameraProperties.getControlMaxRegionsAutoExposure();
        return supportedRegions != null && supportedRegions > 0;
    }

    @Override
    public void updateBuilder(@NonNull CaptureRequest.Builder requestBuilder) {
        if (!this.checkIsSupported()) {
            return;
        }
        if (!this.defaultRegionsHasBeenSet) {
            this.defaultRegions = (MeteringRectangle[])requestBuilder.get(CaptureRequest.CONTROL_AE_REGIONS);
            this.defaultRegionsHasBeenSet = true;
        }
        if (this.exposureRectangle != null) {
            requestBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{this.exposureRectangle});
        } else {
            requestBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)this.defaultRegions);
        }
    }

    private void buildExposureRectangle() {
        if (this.cameraBoundaries == null) {
            throw new AssertionError((Object)"The cameraBoundaries should be set (using `ExposurePointFeature.setCameraBoundaries(Size)`) before updating the exposure point.");
        }
        if (this.exposurePoint == null) {
            this.exposureRectangle = null;
        } else {
            PlatformChannel.DeviceOrientation orientation = this.sensorOrientationFeature.getLockedCaptureOrientation();
            if (orientation == null) {
                orientation = this.sensorOrientationFeature.getDeviceOrientationManager().getLastUIOrientation();
            }
            this.exposureRectangle = CameraRegionUtils.convertPointToMeteringRectangle(this.cameraBoundaries, this.exposurePoint.x, this.exposurePoint.y, orientation);
        }
    }
}

