/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Rect;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.MeteringRectangle;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.plugins.camera.CameraProperties;
import io.flutter.plugins.camera.SdkCapabilityChecker;
import java.util.Arrays;

public final class CameraRegionUtils {
    @NonNull
    public static Size getCameraBoundaries(@NonNull CameraProperties cameraProperties, @NonNull CaptureRequest.Builder requestBuilder) {
        if (SdkCapabilityChecker.supportsDistortionCorrection() && CameraRegionUtils.supportsDistortionCorrection(cameraProperties)) {
            Integer distortionCorrectionMode = (Integer)requestBuilder.get(CaptureRequest.DISTORTION_CORRECTION_MODE);
            Rect rect = distortionCorrectionMode == null || distortionCorrectionMode == 0 ? cameraProperties.getSensorInfoPreCorrectionActiveArraySize() : cameraProperties.getSensorInfoActiveArraySize();
            return SizeFactory.create(rect.width(), rect.height());
        }
        return cameraProperties.getSensorInfoPixelArraySize();
    }

    @NonNull
    public static MeteringRectangle convertPointToMeteringRectangle(@NonNull Size boundaries, double x, double y, @NonNull PlatformChannel.DeviceOrientation orientation) {
        assert (boundaries.getWidth() > 0 && boundaries.getHeight() > 0);
        assert (x >= 0.0 && x <= 1.0);
        assert (y >= 0.0 && y <= 1.0);
        double oldX = x;
        double oldY = y;
        switch (orientation) {
            case PORTRAIT_UP: {
                y = 1.0 - oldX;
                x = oldY;
                break;
            }
            case PORTRAIT_DOWN: {
                x = 1.0 - oldY;
                y = oldX;
                break;
            }
            case LANDSCAPE_LEFT: {
                break;
            }
            case LANDSCAPE_RIGHT: {
                x = 1.0 - x;
                y = 1.0 - y;
            }
        }
        int targetX = (int)Math.round(x * (double)(boundaries.getWidth() - 1));
        int targetY = (int)Math.round(y * (double)(boundaries.getHeight() - 1));
        int targetWidth = (int)Math.round((double)boundaries.getWidth() / 10.0);
        int targetHeight = (int)Math.round((double)boundaries.getHeight() / 10.0);
        targetY -= targetHeight / 2;
        if ((targetX -= targetWidth / 2) < 0) {
            targetX = 0;
        }
        if (targetY < 0) {
            targetY = 0;
        }
        int maxTargetX = boundaries.getWidth() - 1 - targetWidth;
        int maxTargetY = boundaries.getHeight() - 1 - targetHeight;
        if (targetX > maxTargetX) {
            targetX = maxTargetX;
        }
        if (targetY > maxTargetY) {
            targetY = maxTargetY;
        }
        return MeteringRectangleFactory.create(targetX, targetY, targetWidth, targetHeight, 1);
    }

    @SuppressLint(value={"UseRequiresApi"})
    @TargetApi(value=28)
    private static boolean supportsDistortionCorrection(CameraProperties cameraProperties) {
        long nonOffModesSupported;
        int[] availableDistortionCorrectionModes = cameraProperties.getDistortionCorrectionAvailableModes();
        if (availableDistortionCorrectionModes == null) {
            availableDistortionCorrectionModes = new int[]{};
        }
        return (nonOffModesSupported = Arrays.stream(availableDistortionCorrectionModes).filter(value -> value != 0).count()) > 0L;
    }

    static class SizeFactory {
        SizeFactory() {
        }

        @VisibleForTesting
        public static Size create(int width, int height) {
            return new Size(width, height);
        }
    }

    static class MeteringRectangleFactory {
        MeteringRectangleFactory() {
        }

        @VisibleForTesting
        public static MeteringRectangle create(int x, int y, int width, int height, int meteringWeight) {
            return new MeteringRectangle(x, y, width, height, meteringWeight);
        }
    }
}

